/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.facade.CommodityFacadeService;
import com.bxm.fossicker.commodity.facade.dto.CommodityOriginalInfoDTO;
import com.bxm.fossicker.commodity.facade.dto.CommoditySearchFacadeDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.GoodsListRequestParam;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.service.CommodityListService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.google.common.collect.Lists;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommodityFacadeServiceImpl
implements CommodityFacadeService {
    private static final Logger log = LoggerFactory.getLogger(CommodityFacadeServiceImpl.class);
    @Autowired
    private TbCommodityService tbCommodityService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private CommodityListService commodityListService;

    public CommodityOriginalInfoDTO getCommodity(Long goodsId) {
        return this.convert(this.tbCommodityService.getCommodityDetail(goodsId));
    }

    private CommodityOriginalInfoDTO convert(CommodityDetailDTO commodityDetailDTO) {
        if (commodityDetailDTO == null) {
            return CommodityOriginalInfoDTO.builder().build();
        }
        CommodityOriginalInfoDTO commodityOriginalInfoDTO = CommodityOriginalInfoDTO.builder().goodsId(commodityDetailDTO.getGoodsId()).mainPic(commodityDetailDTO.getMainPic()).commodityTitle(commodityDetailDTO.getCommodityTitle()).couponPrice(Double.valueOf(0.0)).commissionRate(Double.valueOf(0.0)).reservePrice(commodityDetailDTO.getReservePrice()).build();
        CommissionAndCoupon commodityCommissionAndCoupon = this.commodityPriceInfoService.getCommissionAndCouponByThird(commodityOriginalInfoDTO.getGoodsId());
        if (commodityCommissionAndCoupon != null) {
            commodityOriginalInfoDTO.setCommissionRate(commodityCommissionAndCoupon.getCommissionRateByThird());
            commodityOriginalInfoDTO.setCouponPrice(commodityCommissionAndCoupon.getCouponPrice());
        }
        return commodityOriginalInfoDTO;
    }

    public List<CommodityOriginalInfoDTO> getCommodityList(String goodsIdArray) {
        List<CommodityDetailDTO> commodityOriginalInfoDTOS = this.tbCommodityService.getCommodityDetailList(goodsIdArray);
        if (commodityOriginalInfoDTOS == null) {
            return Lists.newArrayList();
        }
        List<CommodityOriginalInfoDTO> infoDTOS = commodityOriginalInfoDTOS.stream().map(this::convert).collect(Collectors.toList());
        return infoDTOS;
    }

    public String getImgUrl(Long goodsId) {
        CommodityDetailDTO commodityDetail = this.tbCommodityService.getCommodityDetail(goodsId);
        if (null == commodityDetail) {
            return null;
        }
        return commodityDetail.getMainPic();
    }

    public Long getWellChoseFirstCommodityId(Long userId) {
        GoodsListRequestParam param = new GoodsListRequestParam();
        param.setUserId(userId);
        param.setPageOn(1);
        param.setPageSize(1);
        param.setType("WELLCHOSE");
        try {
            List<CategoryCommodityListItem> listOther = this.commodityListService.goodsListByLabel(param);
            if (!CollectionUtils.isEmpty(listOther)) {
                return listOther.get(0).getGoodsId();
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5927\u6dd8\u5ba2\u3001\u597d\u5355\u5e93\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public TbkActivitylinkGetResponse getTaoBaoUnion(TbkActivitylinkGetRequest req) {
        return this.tbCommodityService.getTaoBaoUnion(req);
    }

    private CommoditySearchFacadeDTO convert(CommoditySearchDTO commoditySearchDTO) {
        CommoditySearchFacadeDTO result = new CommoditySearchFacadeDTO();
        BeanUtils.copyProperties((Object)commoditySearchDTO, (Object)result);
        return result;
    }
}

