/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.enums.CommodityDrawGoldStatusEnum;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.facade.CommodityGoldFacadeService;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;
import com.bxm.fossicker.commodity.service.BrowseFlowService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityGoldServiceImpl
implements CommodityGoldService,
CommodityGoldFacadeService {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private BrowseFlowService browseFlowService;
    @Autowired
    private TaskFacadeService taskFacadeService;

    @Override
    public CommodityGoldInfoDTO getGoldInfoByCommodityId(Long commodityId, Long userId) {
        if (null == userId) {
            return CommodityGoldInfoDTO.builder().drawFlag(Integer.valueOf(1)).browseGold(this.getGoldByCommodity()).commodityId(commodityId).build();
        }
        return CommodityGoldInfoDTO.builder().drawFlag(this.isAvailableBrowseGold(commodityId, userId)).browseGold(this.getGoldByCommodity()).commodityId(commodityId).build();
    }

    public Integer getBrowseGoldNum() {
        return (int)this.commodityInfoProperties.getBrowseCommonGold();
    }

    public void addLimitTimesByDoubleGold(Long userId) {
        KeyGenerator limitKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_GOLD_LIMIT.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.getCurrentDate());
        this.redisStringAdapter.incrementWithDefault(limitKey, 1L, 2, 172800L);
    }

    @Override
    public Boolean getRewardByBrowse(BrowseCommodityParam browseCommodityParam) {
        Long userId = browseCommodityParam.getUserId();
        Long goodsId = browseCommodityParam.getGoodsId();
        if (!this.isAvailableGold(browseCommodityParam.getGoodsId(), browseCommodityParam.getUserId()).booleanValue()) {
            return false;
        }
        this.browseFlowService.addBrowseCommodityRecord(browseCommodityParam);
        this.saveBrowseCommodityRecordToRedis(userId.toString(), browseCommodityParam.getGoodsId().toString());
        KeyGenerator limitKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_GOLD_LIMIT.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.getCurrentDate());
        this.redisStringAdapter.increment(limitKey, 172800L);
        return this.taskFacadeService.complete(userId, ActivityFacadeEnum.FINISH_VIEW);
    }

    @Override
    public Boolean isAvailableGold(Long goodsId, Long userId) {
        return CommodityDrawGoldStatusEnum.AVAILABLE.getStatus().equals(this.isAvailableBrowseGold(goodsId, userId));
    }

    private Integer isAvailableBrowseGold(Long commodityId, Long userId) {
        if (null == commodityId) {
            return CommodityDrawGoldStatusEnum.UNAVAILABLE.getStatus();
        }
        KeyGenerator browseCommodityKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)commodityId.toString());
        String browseRecord = this.redisStringAdapter.getString(browseCommodityKey);
        KeyGenerator limitKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_GOLD_LIMIT.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.getCurrentDate());
        Integer maxDrawGoldTimes = this.commodityInfoProperties.getMaxDrawGoldTimes();
        if (maxDrawGoldTimes < this.redisStringAdapter.getInt(limitKey)) {
            return CommodityDrawGoldStatusEnum.UNAVAILABLE.getStatus();
        }
        if (StringUtils.isNotBlank((String)browseRecord)) {
            return CommodityDrawGoldStatusEnum.UNAVAILABLE.getStatus();
        }
        return CommodityDrawGoldStatusEnum.AVAILABLE.getStatus();
    }

    private Integer getGoldByCommodity() {
        return this.commodityInfoProperties.getBrowseCommonGold();
    }

    private void saveBrowseCommodityRecordToRedis(String userId, String goodsId) {
        KeyGenerator browseCommodityKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_RECORD.copy().appendKey((Object)userId).appendKey((Object)goodsId);
        this.redisStringAdapter.set(browseCommodityKey, (Object)"record", this.calCountDownTimeByToday().longValue());
    }

    private Long calCountDownTimeByToday() {
        LocalTime localTime = LocalTime.of(23, 59, 59);
        LocalDateTime todayEndTime = LocalDateTime.of(LocalDate.now(), localTime);
        return Duration.between(LocalDateTime.now(), todayEndTime).toMillis() / 1000L;
    }
}

