/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.NomalGoodsLabelDTO;
import com.bxm.fossicker.commodity.model.dto.SubCategorysForNomalLabelDTO;
import com.bxm.fossicker.commodity.service.CommodityGoodsLabelService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityGoodsLabelServiceImpl
implements CommodityGoodsLabelService {
    private static final Logger log = LogManager.getLogger(CommodityGoodsLabelServiceImpl.class);
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public NomalGoodsLabelDTO getNomalLabel(String type) {
        NomalGoodsLabelDTO nomalGoodsLabel = new NomalGoodsLabelDTO();
        String result = null;
        KeyGenerator goodsLabel = CommodityRedisKeyConstants.COMMDITY_GOODS_LABEL_CONTANS.copy().appendKey((Object)type);
        result = this.redisStringAdapter.getString(goodsLabel);
        if (StringUtils.isNotBlank((String)result)) {
            nomalGoodsLabel = (NomalGoodsLabelDTO)JSONObject.parseObject((String)result, NomalGoodsLabelDTO.class);
            return nomalGoodsLabel;
        }
        TreeMap<String, String> paraMap = new TreeMap<String, String>();
        paraMap.put("version", this.commodityInfoProperties.getDtkCommodityVersion());
        paraMap.put("appKey", this.commodityInfoProperties.getDtkCommodityAppKey());
        paraMap.put("sign", SignMD5Util.getSignStr(paraMap, (String)this.commodityInfoProperties.getDtkCommodityAppSecret()));
        try {
            result = OkHttpUtils.get((String)this.commodityInfoProperties.getDtkSuperCategoryUrl(), paraMap);
            if (StringUtils.isNotBlank((String)result) && "HOMEPAGE".equals(type)) {
                nomalGoodsLabel = (NomalGoodsLabelDTO)JSONObject.parseObject((String)result, NomalGoodsLabelDTO.class);
                SubCategorysForNomalLabelDTO sfd = new SubCategorysForNomalLabelDTO();
                sfd.setCname("\u7cbe\u9009");
                sfd.setCid(999999999);
                ArrayList<SubCategorysForNomalLabelDTO> list = new ArrayList<SubCategorysForNomalLabelDTO>();
                list.add(sfd);
                list.addAll(nomalGoodsLabel.getData());
                nomalGoodsLabel.setData(list);
                this.redisStringAdapter.set(goodsLabel, (Object)JSONObject.toJSONString((Object)nomalGoodsLabel), 3600L);
            } else if ("SUPERENTER".equals(type)) {
                nomalGoodsLabel = (NomalGoodsLabelDTO)JSONObject.parseObject((String)result, NomalGoodsLabelDTO.class);
                this.redisStringAdapter.set(goodsLabel, (Object)JSONObject.toJSONString((Object)nomalGoodsLabel), 3600L);
            } else {
                nomalGoodsLabel = new NomalGoodsLabelDTO();
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u5206\u7c7b\u5f02\u5e38:{}" + e);
        }
        return nomalGoodsLabel;
    }
}

