/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.enums.LocalCommodityStatusEnum;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.AdvertTicketProperties;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.facade.AdvertPlaceService;
import com.bxm.fossicker.commodity.model.constant.CommodityDetailResultCode;
import com.bxm.fossicker.commodity.model.dto.AdvertPlaceDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailResult;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.CommodityPrice;
import com.bxm.fossicker.commodity.model.dto.DefaultHeadImgDTO;
import com.bxm.fossicker.commodity.model.dto.H5CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.HdkCommissionDataDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;
import com.bxm.fossicker.commodity.model.param.CommodityDetailParam;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.model.param.H5BrowseCommodityParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.BrowseFlowService;
import com.bxm.fossicker.commodity.service.CommodityCollectService;
import com.bxm.fossicker.commodity.service.CommodityCouponInfoService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.CommodityPoolService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.HistoryBrowsingService;
import com.bxm.fossicker.commodity.service.SecKillCommodityService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.externel.DtkCommodityService;
import com.bxm.fossicker.commodity.service.externel.HdkCommodityService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.fossicker.integration.service.CrawlerIntegrationService;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommodityInfoServiceImpl
implements CommodityInfoService,
AdvertPlaceService {
    private static final Logger log = LoggerFactory.getLogger(CommodityInfoServiceImpl.class);
    @Autowired
    private CommodityCouponInfoService commodityCouponInfoService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private CrawlerIntegrationService crawlerIntegrationService;
    @Autowired
    private CommodityCollectService commodityCollectService;
    @Autowired
    private BrowseFlowService browseFlowService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private TaskFacadeService taskFacadeService;
    @Autowired
    private TbCommodityService tbCommodityService;
    @Autowired
    private SecKillCommodityService secKillCommodityService;
    @Autowired
    private DtkCommodityService dtkCommodityService;
    @Autowired
    private BlackCommodityService blackCommodityService;
    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceProxyService;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private AdvertTicketProperties advertTicketProperties;
    @Autowired
    private HistoryBrowsingService historyBrowsingService;
    @Autowired
    CommodityInfoSourceProxyService commodityInfoSourceService;
    @Autowired
    private HdkCommodityService hdkCommodityService;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private CommodityLabelService commodityLabelService;
    @Autowired
    private CommodityPoolService commodityPoolService;

    @Override
    public CommodityDetailDTO getCommodityDetail(CommodityDetailParam param) {
        CommodityDetailQueryParam param1 = new CommodityDetailQueryParam();
        BeanUtils.copyProperties((Object)param, (Object)param1);
        param1.setGoodsId(param.getGoodsId());
        param1.setUserId(param.getUserId());
        param1.setH5Flag(param.isH5Flag());
        param1.setDetailType(param.getDetailType());
        param1.setValidateCommissionPriceInfo(true);
        param1.setSaveHistory(true);
        param1.setSetLable(true);
        param1.setQueryBrowerAward(true);
        param1.setQueryCollect(true);
        param1.setQueryNewbie(true);
        param1.setQueryRemind(true);
        param1.setQueryDetail(true);
        param1.setQueryShare(true);
        param1.setQueryCouponInfo(true);
        return this.getCommodityDetail(param1);
    }

    @Override
    public CommodityDetailDTO getCommodityDetail(CommodityDetailQueryParam param) {
        CommodityDetailResult result = this.getCommodityDetailWithResultCode(param);
        if (Objects.equals(result.getResultCode(), CommodityDetailResultCode.SUCCESS)) {
            return result.getDetail();
        }
        if (!param.isDoNotPrintWarnLog()) {
            log.warn("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u9519\u8bef: {}, \u67e5\u8be2\u53c2\u6570: {}", (Object)result.getResultCode().getDesc(), (Object)JSON.toJSONString((Object)param));
        }
        if (param.isIfNotValidThenReturnBaseInfo() && Objects.nonNull(result.getDetail())) {
            return result.getDetail();
        }
        if (Objects.equals(result.getResultCode(), CommodityDetailResultCode.LOCAL_DOWN) || Objects.equals(result.getResultCode(), CommodityDetailResultCode.NOT_IN_LOCAL) || Objects.equals(result.getResultCode(), CommodityDetailResultCode.NOT_FOUND)) {
            return null;
        }
        return CommodityDetailDTO.builder().validStatus(Integer.valueOf(0)).build();
    }

    private CommodityDetailResult doGetCommodityDetailFromGuessLikeWyInfo(CommodityDetailQueryParam param) {
        WySearchCommodityInfoDTO wyInfo = param.getWySearchCommodityInfoParam().getWyInfo();
        Double reservePrice = Double.valueOf(wyInfo.getZkFinalPrice());
        CommodityDetailDTO detailDTO = CommodityDetailDTO.builder().commodityPrice(reservePrice).reservePrice(reservePrice).commodityTitle(wyInfo.getShortTitle()).goodsId(wyInfo.getItemId()).mainPic(this.assembleHttps(wyInfo.getPictUrl())).salesNum(Integer.valueOf(wyInfo.getVolume().intValue())).shopName(wyInfo.getShopTitle()).shopType(Integer.valueOf(Objects.isNull(wyInfo.getUserType()) ? 0 : wyInfo.getUserType())).source(Byte.valueOf((byte)0)).validStatus(Integer.valueOf(1)).build();
        CommissionAndCoupon commissionAndCoupon = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(wyInfo.getItemId());
        if (Objects.isNull(commissionAndCoupon)) {
            return this.buildResultCode(CommodityDetailResultCode.PRICE_INFO_NOT_FOUND);
        }
        Double platformCommissionPrice = CommodityCalUtils.calPlatformCommission((CommissionAndCoupon)commissionAndCoupon, (Double)reservePrice);
        detailDTO.setPlatformCommissionPrice(platformCommissionPrice);
        return CommodityDetailResult.builder().resultCode(CommodityDetailResultCode.SUCCESS).detail(detailDTO).build();
    }

    private CommodityDetailResult doGetCommodityDetailFromSearchWyInfo(CommodityDetailQueryParam param) {
        WySearchCommodityInfoDTO wySearchCommodityInfoDTO = param.getWySearchCommodityInfoParam().getWyInfo();
        BigDecimal rate = new BigDecimal("10000");
        if (Objects.equals(param.getWySearchCommodityInfoParam().getSearchType(), "2")) {
            log.info("\u5b9a\u5411\u641c\u7d22\u7c7b\u578b\uff0c\u4f7f\u7528\u6b63\u5e38\u6bd4\u4f8b\u8ba1\u7b97");
            rate = new BigDecimal("100");
        }
        Double reservePrice = Double.valueOf(wySearchCommodityInfoDTO.getZkFinalPrice());
        Double couponPrice = CommodityCalUtils.getCouponPriceByRegex((String)wySearchCommodityInfoDTO.getCouponInfo());
        Double discountPrice = CommodityCalUtils.calDiscountPrice((Double)reservePrice, (Double)couponPrice);
        Double platformCommission = CommodityCalUtils.calPlatformCommission((BigDecimal)new BigDecimal(param.getWySearchCommodityInfoParam().getWyInfo().getCommissionRate()).divide(rate, 2, 1), (BigDecimal)BigDecimal.valueOf(couponPrice), (BigDecimal)BigDecimal.valueOf(reservePrice));
        CommodityDetailDTO detailDTO = CommodityDetailDTO.builder().goodsId(param.getGoodsId()).mainPic(wySearchCommodityInfoDTO.getPictUrl()).commodityTitle(Optional.ofNullable(wySearchCommodityInfoDTO.getShortTitle()).orElse(wySearchCommodityInfoDTO.getTitle())).reservePrice(reservePrice).shopType(wySearchCommodityInfoDTO.getUserType()).shopName(wySearchCommodityInfoDTO.getNick()).platformCommissionPrice(platformCommission).discountPrice(discountPrice).couponPrice(couponPrice).source(Byte.valueOf((byte)0)).salesNum(Integer.valueOf(wySearchCommodityInfoDTO.getVolume().intValue())).validStatus(Integer.valueOf(1)).build();
        return CommodityDetailResult.builder().detail(detailDTO).resultCode(CommodityDetailResultCode.SUCCESS).build();
    }

    private CommodityDetailResult getCommodityBaseDetail(CommodityDetailQueryParam param) {
        CommodityDetailDTO detailInfo;
        if (Objects.nonNull(param.getWySearchCommodityInfoParam())) {
            if (Objects.nonNull(param.getWySearchCommodityInfoParam().getConvertType())) {
                if (param.getWySearchCommodityInfoParam().getConvertType().intValue() == 1) {
                    return this.doGetCommodityDetailFromSearchWyInfo(param);
                }
                if (param.getWySearchCommodityInfoParam().getConvertType().intValue() == 2) {
                    return this.doGetCommodityDetailFromGuessLikeWyInfo(param);
                }
            }
            return this.buildResultCode(CommodityDetailResultCode.WY_INFO_ERROR);
        }
        boolean queryCoupon = param.isH5Flag() || StringUtils.isNotBlank((String)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.compareVersion((String)param.getCurVer(), (String)"1.5.0") < 0;
        param.setQueryCouponInfo(param.isQueryCouponInfo() && queryCoupon);
        CommodityInfoDTO commodityInfoDTO = this.commodityInfoSourceService.getCommodityDetail(GetCommodityDetailParam.builder().commodityId(param.getGoodsId()).queryCouponInfo(param.isQueryCouponInfo()).ifLocalDownThenReturnNull(param.isQueryLocalOnly()).build());
        if (param.isQueryLocalOnly()) {
            if (Objects.isNull(commodityInfoDTO)) {
                return this.buildResultCode(CommodityDetailResultCode.NOT_IN_LOCAL);
            }
            if (LocalCommodityStatusEnum.Valid.getStatus() != commodityInfoDTO.getStatus().byteValue()) {
                return this.buildResultCode(CommodityDetailResultCode.LOCAL_DOWN);
            }
        } else {
            if (Objects.isNull(commodityInfoDTO)) {
                return this.buildResultCode(CommodityDetailResultCode.NOT_FOUND);
            }
            if ((Objects.equals(commodityInfoDTO.getSoruce(), (byte)1) || Objects.equals(commodityInfoDTO.getSoruce(), (byte)2)) && Objects.equals(commodityInfoDTO.getStatus(), LocalCommodityStatusEnum.InValid.getStatus())) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5546\u54c1: {} \u5728\u5e93\u5185\u4e3a\u5931\u6548\u72b6\u6001\uff0c\u67e5\u8be2\u4e09\u65b9\u6570\u636e", (Object)param.getGoodsId());
                }
                commodityInfoDTO = this.commodityInfoSourceProxyService.getThirdpartyCommodity(GetCommodityDetailParam.builder().commodityId(param.getGoodsId()).queryCouponInfo(false).build());
            }
        }
        if (Objects.isNull(commodityInfoDTO) || Objects.isNull(detailInfo = this.convert(commodityInfoDTO))) {
            return this.buildResultCode(CommodityDetailResultCode.NOT_FOUND);
        }
        return CommodityDetailResult.builder().resultCode(CommodityDetailResultCode.SUCCESS).detail(detailInfo).build();
    }

    private CommodityPrice getCommodityPrice(PlatformCommissionRateInfo commissionInfo, Double platformCommissionPrice, Double reservePrice, Double couponPrice, boolean isVip) {
        Double commissionPrice;
        Double shareCommissionPrice = commissionPrice = CommodityCalUtils.calCommissionForPlatformCommissionWithVip((PlatformCommissionRateInfo)commissionInfo, (Double)platformCommissionPrice, (boolean)false);
        Double vipCommissionPrice = CommodityCalUtils.calCommissionForPlatformCommissionWithVip((PlatformCommissionRateInfo)commissionInfo, (Double)platformCommissionPrice, (boolean)true);
        Double commodityPrice = CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)couponPrice, (Double)(isVip ? vipCommissionPrice : commissionPrice));
        Double favourablePrice = CommodityCalUtils.calFavourablePrice((Double)(isVip ? vipCommissionPrice : commissionPrice), (Double)couponPrice);
        Double extraCommissionPrice = CommodityCalUtils.calExtraCommissionPrice((Double)commissionPrice, (Double)vipCommissionPrice);
        return CommodityPrice.builder().commissionPrice(commissionPrice).commodityPrice(commodityPrice).extraCommissionPrice(extraCommissionPrice).favourablePrice(favourablePrice).shareCommissionPrice(shareCommissionPrice).vipCommissionPrice(vipCommissionPrice).build();
    }

    private boolean queryNewbie(CommodityDetailDTO detailInfo, boolean newbieRightFlag, boolean newbieRightUser) {
        if (newbieRightFlag && newbieRightUser) {
            if (this.commodityPriceInfoService.isRuleNewbiePrice(detailInfo.getDiscountPrice())) {
                detailInfo.setCommissionPrice(detailInfo.getDiscountPrice());
                detailInfo.setVipCommissionPrice(detailInfo.getDiscountPrice());
                detailInfo.setCommodityPrice(Double.valueOf(0.0));
            } else {
                this.commodityPoolService.setNewbieInvalidStatus(detailInfo.getGoodsId());
                return false;
            }
        }
        return true;
    }

    private boolean queryVipZero(CommodityDetailDTO detailInfo, boolean queryVipZeroInfo, boolean vipUser, boolean isPublicRequest) {
        if (!this.commodityPriceInfoService.isVipZeroCommodity(detailInfo.getGoodsId())) {
            return true;
        }
        if (queryVipZeroInfo && (isPublicRequest || vipUser)) {
            if (this.commodityPriceInfoService.isRuleVipZeroPrice(detailInfo.getPlatformCommissionPrice(), detailInfo.getDiscountPrice())) {
                detailInfo.setCommissionPrice(detailInfo.getDiscountPrice());
                detailInfo.setVipCommissionPrice(detailInfo.getDiscountPrice());
                detailInfo.setCommodityPrice(Double.valueOf(0.0));
                detailInfo.setVipZero(Boolean.TRUE);
                return true;
            }
            log.info("vip 0\u5143\u8d2d\u5546\u54c1: {} \u91d1\u989d\u6821\u9a8c\u5931\u8d25\uff0c\u4ece\u5546\u54c1\u6c60\u4e2d\u79fb\u9664", (Object)detailInfo.getGoodsId());
            this.commodityPoolService.setPoolCommodityInvalidStatus(23L, detailInfo.getGoodsId());
        }
        return false;
    }

    private CommodityDetailResultCode setCommodityPriceInfo(CommodityDetailQueryParam param, CommodityDetailDTO detailInfo, Double platformCommissionPrice) {
        PlatformCommissionRateInfo commissionInfo = this.commodityPriceInfoService.getPlatformCommissionRateInfo(param.getGoodsId());
        if (Objects.isNull(commissionInfo)) {
            return CommodityDetailResultCode.PRICE_ERROR;
        }
        if (Objects.isNull(param.getVipUser())) {
            param.setVipUser(Boolean.valueOf(this.vipFacadeService.isVip(param.getUserId())));
        }
        if (Objects.isNull(platformCommissionPrice)) {
            platformCommissionPrice = 0.0;
        }
        CommodityPrice commodityPriceInfo = this.getCommodityPrice(commissionInfo, platformCommissionPrice, detailInfo.getReservePrice(), detailInfo.getCouponPrice(), param.getVipUser());
        detailInfo.setNormalCommissionPrice(commodityPriceInfo.getCommissionPrice());
        detailInfo.setCommissionPrice(param.getVipUser() != false ? commodityPriceInfo.getVipCommissionPrice() : commodityPriceInfo.getCommissionPrice());
        detailInfo.setSpecialCommissionFlag(commissionInfo.isSpecialCommissionFlag());
        detailInfo.setVipCommissionPrice(commodityPriceInfo.getVipCommissionPrice());
        detailInfo.setFavourablePrice(commodityPriceInfo.getFavourablePrice());
        detailInfo.setExtraCommissionPrice(commodityPriceInfo.getExtraCommissionPrice());
        detailInfo.setShareMoney(commodityPriceInfo.getShareCommissionPrice());
        detailInfo.setCommodityPrice(commodityPriceInfo.getCommodityPrice());
        if (param.isQueryNewbie()) {
            boolean newbieRightCommodity;
            if (Objects.isNull(param.getNewbieRightUser())) {
                param.setNewbieRightUser(Boolean.valueOf(this.commodityPriceInfoService.isNewbieRightForUser(param.getUserId())));
            }
            detailInfo.setNewbieRight(Boolean.valueOf((newbieRightCommodity = this.commodityPriceInfoService.isNewbieRightCommodity(detailInfo.getGoodsId())) && param.getNewbieRightUser() != false));
            if (!this.queryNewbie(detailInfo, newbieRightCommodity, param.getNewbieRightUser())) {
                return CommodityDetailResultCode.NOVICE_PRICE_NOT_VALIDATE;
            }
        } else {
            detailInfo.setNewbieRight(Boolean.valueOf(false));
        }
        if (!this.queryVipZero(detailInfo, Objects.equals(param.getDetailType(), 1), param.getVipUser(), param.isPublicRequest())) {
            return CommodityDetailResultCode.VIP_ZERO_CHECK_FAILED;
        }
        return CommodityDetailResultCode.SUCCESS;
    }

    @Override
    public CommodityDetailResult getCommodityDetailWithResultCode(CommodityDetailQueryParam param) {
        CommodityGoldInfoDTO commodityGoldInfoDTO;
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f: query param: {}", (Object)param);
        }
        if (this.blackCommodityService.isBlackCommodity(param.getGoodsId())) {
            return this.buildResultCode(CommodityDetailResultCode.IN_BLACK);
        }
        CommodityDetailResult result = this.getCommodityBaseDetail(param);
        if (!Objects.equals(result.getResultCode(), CommodityDetailResultCode.SUCCESS) || Objects.isNull(result.getDetail())) {
            return result;
        }
        CommodityDetailDTO detailInfo = result.getDetail();
        CommodityDetailResultCode resultCode = this.setCommodityPriceInfo(param, detailInfo, detailInfo.getPlatformCommissionPrice());
        if (!Objects.equals(resultCode, CommodityDetailResultCode.SUCCESS)) {
            return this.buildResultCode(resultCode, detailInfo);
        }
        if (!param.isH5Flag()) {
            detailInfo.setCouponUrl(this.commodityCouponInfoService.assembleCouponUrlByType(detailInfo.getCouponUrl()));
        }
        if (param.isQueryDetail()) {
            detailInfo.setHeadImg(this.getDefaultHeadImg());
        }
        if (param.isQueryBrowerAward() && null != (commodityGoldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(param.getGoodsId(), param.getUserId()))) {
            detailInfo.setGoldStatus(commodityGoldInfoDTO.getDrawFlag());
            detailInfo.setGoldNum(commodityGoldInfoDTO.getBrowseGold());
        }
        if (param.isQueryCollect()) {
            Integer collectStatus = this.commodityCollectService.getCollectStatus(param.getGoodsId(), param.getUserId());
            detailInfo.setCollectStatus(Integer.valueOf(Objects.isNull(collectStatus) ? 0 : collectStatus));
        }
        if (param.isQueryRemind()) {
            detailInfo.setRemindStatus(Integer.valueOf(this.secKillCommodityService.getRemindCommodityStatus(param.getGoodsId(), param.getUserId())));
        }
        if (param.isSetLable()) {
            if (null != detailInfo.getNewbieRight() && detailInfo.getNewbieRight().booleanValue()) {
                detailInfo.setLabelUrl(new ArrayList());
            } else {
                detailInfo.setLabelUrl(this.commodityLabelService.labelTypeFromRedis(detailInfo.getGoodsId()));
            }
        } else {
            detailInfo.setLabelUrl((List)Lists.newArrayList());
        }
        if (param.isSaveHistory()) {
            this.historyBrowsingService.insertFootprint(param.getUserId(), param.getGoodsId());
        }
        if (param.isValidateCommissionPriceInfo() && !this.validateCommissionAndCommodityPrice(detailInfo.getCommissionPrice(), detailInfo.getCommodityPrice())) {
            return this.buildResultCode(CommodityDetailResultCode.PRICE_NOTE_VALIDATE, detailInfo);
        }
        if (param.isValidateCouponPriceInfo() && !this.validateCoupon(detailInfo.getCouponPrice())) {
            return this.buildResultCode(CommodityDetailResultCode.COUPON_PRICE_NOTE_VALIDATE, detailInfo);
        }
        return CommodityDetailResult.builder().detail(detailInfo).resultCode(CommodityDetailResultCode.SUCCESS).build();
    }

    private CommodityDetailResult buildResultCode(CommodityDetailResultCode resultCode) {
        return CommodityDetailResult.builder().resultCode(resultCode).build();
    }

    private CommodityDetailResult buildResultCode(CommodityDetailResultCode resultCode, CommodityDetailDTO detail) {
        if (Objects.nonNull(detail) && !Objects.equals(resultCode, CommodityDetailResultCode.SUCCESS)) {
            detail.setValidStatus(Integer.valueOf(0));
        }
        return CommodityDetailResult.builder().resultCode(resultCode).detail(detail).build();
    }

    @Override
    public CommodityListItemResult getCommodityListItemBaseInfo(CommodityDetailQueryParam queryParam) {
        CommodityDetailResult result = this.getCommodityDetailWithResultCode(queryParam);
        if (Objects.equals(result.getResultCode(), CommodityDetailResultCode.SUCCESS) && Objects.nonNull(result.getDetail())) {
            return CommodityListItemResult.builder().listItem(this.covert(result.getDetail())).resultCode(CommodityDetailResultCode.SUCCESS).build();
        }
        if (!queryParam.isDoNotPrintWarnLog()) {
            log.warn("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u9519\u8bef: {}, \u67e5\u8be2\u53c2\u6570: {}", (Object)result.getResultCode().getDesc(), (Object)JSON.toJSONString((Object)queryParam));
        }
        if (queryParam.isIfNotValidThenReturnBaseInfo() && Objects.nonNull(result.getDetail())) {
            return CommodityListItemResult.builder().listItem(this.covert(result.getDetail())).resultCode(result.getResultCode()).build();
        }
        return CommodityListItemResult.builder().resultCode(result.getResultCode()).build();
    }

    private BaseCommodityListItem covert(CommodityDetailDTO detail) {
        BaseCommodityListItem commodity = new BaseCommodityListItem();
        commodity.setGoodsId(detail.getGoodsId());
        commodity.setCommodityTitle(detail.getCommodityTitle());
        commodity.setImgUrl(detail.getMainPic());
        commodity.setCommodityPrice(detail.getCommodityPrice());
        commodity.setShopType(detail.getShopType());
        commodity.setShopName(detail.getShopName());
        commodity.setCouponPrice(detail.getCouponPrice());
        commodity.setCommissionPrice(detail.getCommissionPrice());
        commodity.setNewbieRight(detail.getNewbieRight());
        commodity.setMonthSales(Long.valueOf(Objects.isNull(detail.getSalesNum()) ? 0L : detail.getSalesNum().longValue()));
        commodity.setReservePrice(detail.getReservePrice());
        commodity.setVipCommissionPrice(detail.getVipCommissionPrice());
        commodity.setDiscountPrice(detail.getDiscountPrice());
        commodity.setSpecialCommissionFlag(detail.isSpecialCommissionFlag());
        commodity.setSource(detail.getSource());
        return commodity;
    }

    private String assembleHttps(String picUrl) {
        if (StringUtils.isBlank((String)picUrl)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("https:");
        return stringBuilder.append(picUrl).toString();
    }

    private boolean validateCommissionAndCommodityPrice(Double commissionPrice, Double commodityPrice) {
        if (Objects.isNull(commissionPrice) || Objects.isNull(commodityPrice)) {
            return false;
        }
        return !Objects.equals(commissionPrice, 0.0);
    }

    private boolean validateCoupon(Double couponPrice) {
        if (Objects.isNull(couponPrice)) {
            return false;
        }
        return !Objects.equals(couponPrice, 0.0);
    }

    @Override
    public Boolean getRewardByBrowse(BrowseCommodityParam browseCommodityParam) {
        return this.commodityGoldService.getRewardByBrowse(browseCommodityParam);
    }

    @Override
    public Boolean getRewardByBrowseForH5(H5BrowseCommodityParam browseCommodityParam) {
        Long browseUserId = browseCommodityParam.getBrowseUserId();
        Long shareUserId = browseCommodityParam.getShareUserId();
        Long goodsId = browseCommodityParam.getGoodsId();
        if (null == browseUserId) {
            log.info("\u975e\u5e73\u53f0\u8001\u7528\u6237,\u4e0d\u7ed9\u4e88\u589e\u52a0\u91d1\u5e01");
            return true;
        }
        if (!this.commodityGoldService.isAvailableGold(goodsId, browseUserId).booleanValue()) {
            log.info("\u8be5\u7528\u6237\u4eca\u65e5\u4e0d\u53ef\u9886\u6d4f\u89c8\u91d1\u5e01,\u7528\u6237id:{}", (Object)browseUserId);
            return true;
        }
        this.browseFlowService.addBrowseShareCommodityRecord(browseUserId, shareUserId, goodsId);
        this.saveBrowseCommodityRecordToRedis(browseUserId.toString(), goodsId.toString());
        this.taskFacadeService.complete(browseUserId, ActivityFacadeEnum.FINISH_VIEW);
        if (!browseUserId.equals(shareUserId)) {
            KeyGenerator limitKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_GOLD_LIMIT.copy().appendKey((Object)shareUserId.toString()).appendKey((Object)DateUtils.getCurrentDate());
            this.redisStringAdapter.increment(limitKey, 172800L);
            return this.taskFacadeService.complete(browseCommodityParam.getShareUserId(), ActivityFacadeEnum.SHARE_VIEW);
        }
        return true;
    }

    @Override
    public List<CommodityDetailInfoDTO> getCommodityDetailPic(Long commodityId) {
        return this.commodityInfoSourceProxyService.getCommodityDetailInfo(commodityId);
    }

    @Override
    public String createTaoWord(String url, String imgUrl, String commodityTitle) {
        return this.tbCommodityService.createTaoWord(url, imgUrl, commodityTitle);
    }

    @Override
    public H5CommodityDetailDTO getH5CommodityDetailDTO(Long commodityId, Long shareUserId, String relationId) {
        CommodityDetailParam param = new CommodityDetailParam();
        param.setGoodsId(commodityId);
        param.setUserId(shareUserId);
        param.setH5Flag(true);
        CommodityDetailDTO commodityDetailDTO = this.getCommodityDetail(param);
        if (Objects.isNull(commodityDetailDTO)) {
            log.warn("\u7ad9\u5916\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u4e3a\u7a7a, \u5546\u54c1id\u4e3a:{}", (Object)commodityId);
            return null;
        }
        if (StringUtils.isBlank((String)commodityDetailDTO.getCouponUrl())) {
            log.warn("\u7ad9\u5916\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u7684\u4f18\u60e0\u5238\u4e3a\u7a7a, commodityId: {}", (Object)commodityId);
            return null;
        }
        H5CommodityDetailDTO resultDTO = new H5CommodityDetailDTO();
        BeanUtils.copyProperties((Object)commodityDetailDTO, (Object)resultDTO);
        if (0 == resultDTO.getValidStatus()) {
            return resultDTO;
        }
        String imgUrl = CollectionUtils.isEmpty((Collection)commodityDetailDTO.getImgUrlList()) ? null : (String)commodityDetailDTO.getImgUrlList().get(0);
        String taoWord = this.createTaoWord(this.assembleCouponUrl(commodityDetailDTO.getCouponUrl(), relationId), imgUrl, commodityDetailDTO.getCommodityTitle());
        resultDTO.setTaoWord(taoWord);
        return resultDTO;
    }

    @Override
    public H5CommodityDetailDTO getH5CommodityDetailDTOForAdvert(Long commodityId, String bxmId) {
        CommodityDetailDTO commodityDetailDTO = this.getCommodityDetailForAdvert(commodityId);
        if (null == commodityDetailDTO) {
            log.error("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u4e3a\u7a7a,\u5546\u54c1id\u4e3a:{}", (Object)commodityId);
            return null;
        }
        H5CommodityDetailDTO resultDTO = new H5CommodityDetailDTO();
        BeanUtils.copyProperties((Object)commodityDetailDTO, (Object)resultDTO);
        String url = this.setAdvertPid(commodityDetailDTO, bxmId);
        String imgUrl = CollectionUtils.isEmpty((Collection)commodityDetailDTO.getImgUrlList()) ? null : (String)commodityDetailDTO.getImgUrlList().get(0);
        String taoWord = this.createTaoWord(url == null ? commodityDetailDTO.getCouponUrl() : url, imgUrl, commodityDetailDTO.getCommodityTitle());
        resultDTO.setTaoWord(taoWord);
        return resultDTO;
    }

    private String setAdvertPid(CommodityDetailDTO commodityDetailDTO, String bxmId) {
        AdvertPlaceDTO advertPlaceDTO = this.getBxmAdvertPlaceInfo(bxmId);
        if (Objects.isNull(advertPlaceDTO)) {
            HdkCommissionDataDTO hdkCommissionDataDTO = this.hdkCommodityService.getCommissionAndCoupon(commodityDetailDTO.getGoodsId(), "mm_456760114_597650089_109744800352");
            if (!Objects.isNull(hdkCommissionDataDTO)) {
                return hdkCommissionDataDTO.getCoupon_click_url();
            }
            return null;
        }
        KeyGenerator advertPidKey = CommodityRedisKeyConstants.COMMODITY_ADVERT_PID_MAP.copy();
        String pid = (String)this.redisHashMapAdapter.get(advertPidKey, advertPlaceDTO.getPlaceId(), String.class);
        if (StringUtils.isEmpty((String)pid)) {
            log.error("\u672a\u914d\u7f6e\u53d8\u73b0\u732b\u5e7f\u544a\u4f4d\u6216\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u6839\u636eappKey-business:pid\u914d\u7f6e\u3002appKey:{}, business:{}", (Object)advertPlaceDTO.getAppKey(), (Object)advertPlaceDTO.getBusiness());
            HdkCommissionDataDTO hdkCommissionDataDTO = this.hdkCommodityService.getCommissionAndCoupon(commodityDetailDTO.getGoodsId(), "mm_456760114_597650089_109744800352");
            if (!Objects.isNull(hdkCommissionDataDTO)) {
                return hdkCommissionDataDTO.getCoupon_click_url();
            }
            return null;
        }
        KeyGenerator bxmIdKey = CommodityRedisKeyConstants.COMMODITY_ADVERT_PID_BXMID_MAP.copy();
        this.redisHashMapAdapter.put(bxmIdKey, pid, (Object)bxmId);
        try {
            HdkCommissionDataDTO hdkCommissionDataDTO = this.hdkCommodityService.getCommissionAndCoupon(commodityDetailDTO.getGoodsId(), pid);
            if (!Objects.isNull(hdkCommissionDataDTO)) {
                return hdkCommissionDataDTO.getCoupon_click_url();
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u7f6e\u4f18\u60e0\u5377\u94fe\u63a5\u5931\u8d25\uff0ccouponUrl:{}", (Object)commodityDetailDTO.getCouponUrl());
            e.printStackTrace();
        }
        return null;
    }

    private AdvertPlaceDTO getBxmAdvertPlaceInfo(String bxmId) {
        String url = this.advertTicketProperties.getParseBxmIdUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bxm_id", bxmId);
        AdvertPlaceDTO advertPlaceDTO = new AdvertPlaceDTO();
        try {
            String result = OkHttpUtils.get((String)url, params);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            if (Objects.isNull(resultJson.getBoolean("success")) || !resultJson.getBoolean("success").booleanValue()) {
                log.error("\u89e3\u6790bxmId\u5931\u8d25\uff0curl:{}\uff0cbxmId:{}, \u8fd4\u56de\u53c2\u6570:{}", new Object[]{url, bxmId, result});
            }
            advertPlaceDTO = (AdvertPlaceDTO)JSON.toJavaObject((JSON)resultJson.getJSONObject("data"), AdvertPlaceDTO.class);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790bxmId\u5931\u8d25,url:{}\uff0cbxmId:{}", (Object)url, (Object)bxmId);
            e.printStackTrace();
        }
        return advertPlaceDTO;
    }

    public void checkAndsendOrderToBxmAdvert(Long orderId, String pid) {
        KeyGenerator pidKey = CommodityRedisKeyConstants.COMMODITY_ADVERT_PID_BXMID_MAP.copy();
        String bxmId = (String)this.redisHashMapAdapter.get(pidKey, pid, String.class);
        KeyGenerator sendOrderKey = CommodityRedisKeyConstants.COMMODITY_SEND_ADVERT.copy().appendKey((Object)String.valueOf(orderId));
        if (!StringUtils.isEmpty((String)bxmId) && !this.redisStringAdapter.hasKey(sendOrderKey).booleanValue()) {
            String url = this.advertTicketProperties.getSendOrderUrl();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bxmId", bxmId);
            params.put("type", 5);
            try {
                String result = OkHttpUtils.get((String)url, params);
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (Objects.isNull(resultJson.getBoolean("successed")) || !resultJson.getBoolean("successed").booleanValue()) {
                    log.error("\u63a8\u9001\u7ed9\u5e7f\u544a\u90e8\u5230\u6548\u679c\u76d1\u63a7\u8ba2\u5355\u5931\u8d25\uff1a\u8ba2\u5355id:{}, \u8fd4\u56de\u53c2\u6570:{}", (Object)orderId, (Object)result);
                    return;
                }
                this.redisStringAdapter.set(sendOrderKey, (Object)"true", 2592000L);
            }
            catch (IOException e) {
                log.error("\u63a8\u9001\u7ed9\u5e7f\u544a\u90e8\u5230\u6548\u679c\u76d1\u63a7\u8ba2\u5355\u5931\u8d25\uff1a\u8ba2\u5355id:{}", (Object)orderId);
                e.printStackTrace();
            }
        }
    }

    private CommodityDetailDTO convert(CommodityInfoDTO commodityInfoDTO) {
        return CommodityDetailDTO.builder().commodityPrice(commodityInfoDTO.getCommodityPrice()).commodityScore(commodityInfoDTO.getCommodityScore()).commodityTitle(commodityInfoDTO.getCommodityTitle()).couponPrice(commodityInfoDTO.getCouponPrice()).couponUrl(commodityInfoDTO.getCouponUrl()).discountPrice(commodityInfoDTO.getDiscountPrice()).goodsId(commodityInfoDTO.getGoodsId()).imgUrlList(commodityInfoDTO.getImgUrlList()).logisticsScore(commodityInfoDTO.getLogisticsScore()).mainPic(commodityInfoDTO.getMainPic()).recommendContent(commodityInfoDTO.getRecommendContent()).reservePrice(commodityInfoDTO.getReservePrice()).salesNum(commodityInfoDTO.getSalesNum()).sellerScore(commodityInfoDTO.getSellerScore()).shopIcon(commodityInfoDTO.getShopIcon()).shopName(commodityInfoDTO.getShopName()).shopType(Integer.valueOf(Objects.isNull(commodityInfoDTO.getShopType()) ? 0 : commodityInfoDTO.getShopType())).shopUrl(commodityInfoDTO.getShopUrl()).commodityDetailInfos(commodityInfoDTO.getDetailInfo()).platformCommissionPrice(commodityInfoDTO.getPlatformCommissionPrice()).validStatus(Integer.valueOf(1)).source(commodityInfoDTO.getSoruce()).build();
    }

    private void saveBrowseCommodityRecordToRedis(String userId, String goodsId) {
        KeyGenerator browseCommodityKey = CommodityRedisKeyConstants.COMMODITY_BROWSE_RECORD.copy().appendKey((Object)userId).appendKey((Object)goodsId);
        this.redisStringAdapter.set(browseCommodityKey, (Object)"record", (long)DateUtils.getCurSeconds());
    }

    private String assembleCouponUrl(String url, String relationId) {
        if (StringUtils.isNotBlank((String)url)) {
            StringBuilder sb = new StringBuilder(url);
            return sb.append("&relationId=").append(relationId).toString();
        }
        log.warn("\u7ec4\u88c5\u4f18\u60e0\u5238url\u5931\u8d25, relationId: {}", (Object)relationId);
        return null;
    }

    private String getDefaultHeadImg() {
        int min = 0;
        int max = 12;
        int randomNum = new Random().nextInt(max - min) + min;
        List headImgList = JSON.parseArray((String)this.commodityInfoProperties.getHeadImgList(), DefaultHeadImgDTO.class);
        return ((DefaultHeadImgDTO)headImgList.get(randomNum)).getHeadImg();
    }

    private CommodityDetailDTO getCommodityDetailForAdvert(Long commodityId) {
        CommodityDetailDTO detailInfo;
        CommodityInfoDTO commodityInfoDTO = this.commodityInfoSourceProxyService.getCommodityDetail(commodityId);
        if (Objects.isNull(commodityInfoDTO) || Objects.isNull(detailInfo = this.convert(commodityInfoDTO))) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u5931\u8d25,\u65e0\u6b64\u5546\u54c1\u4fe1\u606f");
            return null;
        }
        detailInfo.setCouponUrl(this.commodityCouponInfoService.assembleCouponUrlByType(detailInfo.getCouponUrl()));
        detailInfo.setHeadImg(this.getDefaultHeadImg());
        return detailInfo;
    }
}

