/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.config.ClientConfigProperties;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.constant.CommodityRedisKey;
import com.bxm.fossicker.commodity.model.param.LabelTypeContent;
import com.bxm.fossicker.commodity.model.param.LabelTypeInfo;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityLabelServiceImpl
implements CommodityLabelService {
    private static final Logger log = LoggerFactory.getLogger(CommodityLabelServiceImpl.class);
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Override
    public List<String> goodsLabel(boolean newbieRight, double handsel, Long goodsId) {
        ArrayList<String> labelTypeList = new ArrayList();
        if (newbieRight) {
            return new ArrayList<String>();
        }
        Date now = new Date();
        if (now.after(this.strToDate(this.commodityInfoProperties.getEndTimeForDouble11()))) {
            return new ArrayList<String>();
        }
        if (now.before(this.strToDate(this.commodityInfoProperties.getStartTimeForDouble11()))) {
            if (handsel > 0.0) {
                labelTypeList = this.getLabelUrl(Arrays.asList(1));
                this.saveLabelTypeToRedis(goodsId, 1, labelTypeList);
                return labelTypeList;
            }
            return new ArrayList<String>();
        }
        if (now.after(this.strToDate(this.commodityInfoProperties.getStartTimeForDouble11())) && now.before(this.strToDate(this.commodityInfoProperties.getEndTimeForDouble11()))) {
            labelTypeList = this.getLabelUrl(Arrays.asList(2));
            return labelTypeList;
        }
        return new ArrayList<String>();
    }

    private void saveLabelTypeToRedis(Long goodsId, int labelType, List<String> arrays) {
        if (labelType > 0) {
            LabelTypeInfo labelTypeInfo = new LabelTypeInfo();
            labelTypeInfo.setLabelType(arrays);
            this.redisHashMapAdapter.put(CommodityRedisKey.GOODS_LABEL_TYPE, goodsId.toString(), (Object)JSONObject.toJSONString((Object)labelTypeInfo));
        }
    }

    @Override
    public List<String> labelTypeFromRedis(Long goodsId) {
        Date now = new Date();
        if (now.after(this.strToDate(this.commodityInfoProperties.getEndTimeForDouble11()))) {
            return new ArrayList<String>();
        }
        if (now.after(this.strToDate(this.commodityInfoProperties.getStartTimeForDouble11())) && now.before(this.strToDate(this.commodityInfoProperties.getEndTimeForDouble11()))) {
            return this.getLabelUrl(Arrays.asList(2));
        }
        String redisStr = (String)this.redisHashMapAdapter.get(CommodityRedisKey.GOODS_LABEL_TYPE, goodsId.toString(), String.class);
        if (Objects.isNull(redisStr)) {
            return new ArrayList<String>();
        }
        LabelTypeInfo labelTypeInfo = (LabelTypeInfo)JSONObject.parseObject((String)redisStr, LabelTypeInfo.class);
        if (Objects.isNull(labelTypeInfo)) {
            Objects.isNull(labelTypeInfo);
            return new ArrayList<String>();
        }
        return labelTypeInfo.getLabelType();
    }

    private Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date reslut = null;
        try {
            reslut = formatter.parse(strDate);
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u5316 error : {}", (Throwable)e);
        }
        return reslut;
    }

    public List<String> getLabelUrl(List<Integer> labelType) {
        List list;
        String labelTypeContentStr = (String)this.clientConfigProperties.getCommonKeys().get("labelContent");
        ArrayList<String> urlList = new ArrayList<String>();
        if (!Objects.isNull(labelTypeContentStr) && (list = JSON.parseArray((String)labelTypeContentStr, LabelTypeContent.class)).size() > 0) {
            block0: for (Integer label : labelType) {
                for (LabelTypeContent labelTypeContent : list) {
                    if (labelTypeContent.getLabelType() != label.intValue()) continue;
                    urlList.add(labelTypeContent.getUrl());
                    continue block0;
                }
            }
        }
        return urlList;
    }
}

