/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.enums.CommodityCidWithPositionEnum;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.CategoryCommodityListParam;
import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.model.param.ExtendGoodsListParam;
import com.bxm.fossicker.commodity.model.param.GoodsListByPositionParam;
import com.bxm.fossicker.commodity.model.param.GoodsListRequestParam;
import com.bxm.fossicker.commodity.model.param.GoodsSearchParam;
import com.bxm.fossicker.commodity.model.param.GuessCommodityQueryParam;
import com.bxm.fossicker.commodity.model.param.GuessLikeListParam;
import com.bxm.fossicker.commodity.model.param.HomePageWellChoseCommodityListParam;
import com.bxm.fossicker.commodity.model.param.PoolCommodityListParam;
import com.bxm.fossicker.commodity.model.param.RecommendCommodityParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.commodity.service.CommodityListService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.fossicker.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityListServiceImpl
implements CommodityListService {
    private static final Logger log = LogManager.getLogger(CommodityListServiceImpl.class);
    @Autowired
    private CommodityListServiceProxy commodityListServiceProxy;

    @Override
    public List<CategoryCommodityListItem> goodsListByLabel(GoodsListRequestParam param) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u4fe1\u606f\u5217\u8868 input param :{}", (Object)JSON.toJSONString((Object)param));
        }
        switch (param.getType()) {
            case "LIKE": {
                return Lists.newArrayList();
            }
            case "WELLCHOSE": {
                HomePageWellChoseCommodityListParam homePageWellParam = new HomePageWellChoseCommodityListParam();
                BeanUtils.copyProperties((Object)param, (Object)homePageWellParam);
                homePageWellParam.setPublicRequest(true);
                return this.commodityListServiceProxy.getCommodityList((CommodityListParam)homePageWellParam);
            }
            case "NOMAL": {
                CategoryCommodityListParam param1 = new CategoryCommodityListParam();
                BeanUtils.copyProperties((Object)param, (Object)param1);
                param1.setCids(param.getCid());
                param1.setQueryGoldInfo(true);
                param1.setQueryLabel(true);
                param1.setPublicRequest(true);
                return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param1);
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public List<CategoryCommodityListItem> goodsListSearchForSubCid(GoodsSearchParam param) {
        CategoryCommodityListParam param1 = new CategoryCommodityListParam();
        BeanUtils.copyProperties((Object)param, (Object)param1);
        param1.setQueryGoldInfo(true);
        param1.setQueryLabel(true);
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param1);
    }

    @Override
    public List<CategoryCommodityListItem> noviceZeroCommodityList(Long userId) {
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(Long.valueOf(1L));
        poolParam.setUserId(userId);
        poolParam.setQueryLabel(true);
        poolParam.setQueryGoldInfo(true);
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)poolParam);
    }

    @Override
    public List<PoolCommodityListItem> extendGoodsList(ExtendGoodsListParam param) {
        if (Objects.isNull(param.getPoolId())) {
            return new ArrayList<PoolCommodityListItem>();
        }
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(param.getPoolId());
        poolParam.setUserId(param.getUserId());
        poolParam.setQueryLabel(true);
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)poolParam);
    }

    @Override
    public List<CategoryCommodityListItem> categoryCommodityList(GoodsListRequestParam param) {
        CategoryCommodityListParam param1 = new CategoryCommodityListParam();
        param1.setUserId(param.getUserId());
        param1.setQueryLabel(true);
        param1.setQueryGoldInfo(true);
        param1.setPageSize(param.getPageSize());
        param1.setPageOn(param.getPageOn());
        if (StringUtils.isNotBlank((String)param.getCid())) {
            param1.setCids(param.getCid());
            return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param1);
        }
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param1);
    }

    @Override
    public List<CategoryCommodityListItem> categoryCommodityListByPosition(GoodsListByPositionParam param) {
        return this.categoryCommodityList((GoodsListRequestParam)this.assembleParamByPosition(param));
    }

    @Override
    public List<PoolCommodityListItem> poolCommodityList(Long poolId, Long userId, boolean isVip) {
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(poolId);
        poolParam.setUserId(userId);
        poolParam.setQueryLabel(true);
        poolParam.setVip(Boolean.valueOf(isVip));
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)poolParam);
    }

    @Override
    public List<BaseCommodityListItem> getRecommendCommodity(Long commodityId, Long userId) {
        RecommendCommodityParam param = new RecommendCommodityParam();
        param.setCommodityId(commodityId);
        param.setUserId(userId);
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param);
    }

    @Override
    public PageWarper<CommoditySearchDTO> getGuessLike(GuessCommodityQueryParam guessCommodityQueryParam) {
        PageWarper resultPage = new PageWarper();
        resultPage.setPageNum(guessCommodityQueryParam.getPageNum().intValue());
        resultPage.setPageSize(guessCommodityQueryParam.getPageSize().intValue());
        GuessLikeListParam param = new GuessLikeListParam();
        param.setGuessCommodityQueryParam(guessCommodityQueryParam);
        param.setUserId(guessCommodityQueryParam.getUserId());
        resultPage.setList(this.commodityListServiceProxy.getCommodityList((CommodityListParam)param));
        return resultPage;
    }

    private GoodsListByPositionParam assembleParamByPosition(GoodsListByPositionParam goodsListByPositionParam) {
        if (CommodityCidWithPositionEnum.FOOD.getPosition().equals(goodsListByPositionParam.getPosition())) {
            goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.FOOD.getCid());
            return goodsListByPositionParam;
        }
        if (CommodityCidWithPositionEnum.HOME_DAILY.getPosition().equals(goodsListByPositionParam.getPosition())) {
            goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.HOME_DAILY.getCid());
            return goodsListByPositionParam;
        }
        goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.FOOD.getCid());
        return goodsListByPositionParam;
    }
}

