/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.domain.CommodityPoolMapper;
import com.bxm.fossicker.commodity.model.constant.LowershelfSignEnum;
import com.bxm.fossicker.commodity.model.vo.CommodityPoolStatusVO;
import com.bxm.fossicker.commodity.service.CommodityPoolService;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityPoolServiceImpl
implements CommodityPoolService {
    private static final Logger log = LoggerFactory.getLogger(CommodityPoolServiceImpl.class);
    private final CommodityPoolMapper commodityPoolMapper;
    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public CommodityPoolServiceImpl(CommodityPoolMapper commodityPoolMapper, RedisSetAdapter redisSetAdapter) {
        this.commodityPoolMapper = commodityPoolMapper;
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public Boolean setNewbieInvalidStatus(Long goodsId) {
        if (null == goodsId) {
            log.warn("\u65b0\u4eba\u4e13\u4eab\u5546\u54c1\uff0c\u4ef7\u683c\u53d8\u52a8\u4e0b\u67b6\u5931\u8d25\uff0c\u5546\u54c1id\u4e3a[{}]", (Object)goodsId);
            return false;
        }
        CommodityPoolStatusVO statusVO = new CommodityPoolStatusVO();
        statusVO.setGoodsId(String.valueOf(goodsId));
        statusVO.setPoolsId(Long.valueOf(1L));
        statusVO.setStatusType(Byte.valueOf((byte)2));
        statusVO.setLowershelfSign(LowershelfSignEnum.COMMODITY_PRICE_CHANGE.getDes());
        this.redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET, new Object[]{Objects.toString(goodsId)});
        return this.commodityPoolMapper.updateCommodityStatus(statusVO) > 0;
    }

    @Override
    public void setPoolCommodityInvalidStatus(Long poolId, Long goodsId) {
        if (Objects.nonNull(poolId) && Objects.nonNull(goodsId)) {
            if (poolId.equals(1L)) {
                this.redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET, new Object[]{Objects.toString(goodsId)});
            }
            if (poolId.equals(23L)) {
                this.redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_VIP_ZERO_SET, new Object[]{Objects.toString(goodsId)});
            }
            CommodityPoolStatusVO poolStatusVO = new CommodityPoolStatusVO();
            poolStatusVO.setPoolsId(poolId);
            poolStatusVO.setGoodsId(String.valueOf(goodsId));
            poolStatusVO.setStatusType(Byte.valueOf((byte)2));
            poolStatusVO.setLowershelfSign(LowershelfSignEnum.COMMODITY_INVALID_LOWERSHELF.getDes());
            this.commodityPoolMapper.updateCommodityStatus(poolStatusVO);
        }
    }
}

