/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.CommodityCommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.utils.CommodityNumberUtils;
import com.bxm.fossicker.commodity.config.CommissionProperties;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.facade.CommodityCommissionFacadeService;
import com.bxm.fossicker.commodity.facade.dto.CommissionEleFacadeDTO;
import com.bxm.fossicker.commodity.facade.dto.CommissionPlatformFacadeDTO;
import com.bxm.fossicker.commodity.facade.param.GetEleCommissionParam;
import com.bxm.fossicker.commodity.facade.param.GetPlatformCommissionParam;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.model.vo.CustomRebateBean;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.strategy.PriceByThirdStrategyService;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CommodityPriceInfoServiceImpl
implements CommodityPriceInfoService,
CommodityCommissionFacadeService {
    private static final Logger log = LoggerFactory.getLogger(CommodityPriceInfoServiceImpl.class);
    @Autowired
    @Qualifier(value="priceStrategyByTbService")
    private PriceByThirdStrategyService reservePriceByTbService;
    @Autowired
    @Qualifier(value="commissionStrategyByWyService")
    private PriceByThirdStrategyService commissionStrategyByWyService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private CommissionProperties commissionProperties;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceProxyService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private CommodityInfoMapper commodityInfoMapper;
    @Autowired
    private CommodityInfoService commodityInfoService;

    @Override
    public CommodityCommissionAndCoupon getCommodityCommissionAndCoupon(Long goodsId, Long userId) {
        return this.getCommodityCommissionAndCoupon(goodsId, userId, false);
    }

    @Override
    public CommodityCommissionAndCoupon getCommodityCommissionAndCoupon(Long goodsId, Long userId, Boolean newbieNotShowFlag) {
        PriceByThirdStrategyService priceByThirdStrategyService = this.commissionServiceFactory();
        if (null == priceByThirdStrategyService) {
            log.error("\u521b\u5efa\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4ee3\u7801");
            return null;
        }
        CommissionAndCoupon commissionAndCoupon = priceByThirdStrategyService.getCommissionAndCoupon(goodsId);
        if (Objects.isNull(commissionAndCoupon)) {
            return null;
        }
        CommodityCommissionAndCoupon commissionInfoDTO = new CommodityCommissionAndCoupon();
        BeanUtils.copyProperties((Object)commissionAndCoupon, (Object)commissionInfoDTO);
        PlatformCommissionRateInfo platformCommissionRateInfo = this.getPlatformCommissionRateInfo(goodsId);
        if (Objects.nonNull(platformCommissionRateInfo)) {
            BeanUtils.copyProperties((Object)platformCommissionRateInfo, (Object)commissionInfoDTO);
        }
        return commissionInfoDTO;
    }

    @Override
    public CommissionAndCoupon getCommodityCommissionAndCoupon(Long goodsId) {
        PriceByThirdStrategyService priceByThirdStrategyService = this.commissionServiceFactory();
        if (null == priceByThirdStrategyService) {
            log.error("\u521b\u5efa\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4ee3\u7801");
            return null;
        }
        return priceByThirdStrategyService.getCommissionAndCoupon(goodsId);
    }

    public CommissionEleFacadeDTO getEleCommission(GetEleCommissionParam param) {
        CommissionEleFacadeDTO facadeDTO = new CommissionEleFacadeDTO();
        if (Objects.isNull(param) || Objects.isNull(param.getPayPrice())) {
            log.warn("\u8ba1\u7b97\u997f\u4e86\u4e48\u8ba2\u5355\u8fd4\u4f63\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param));
            return facadeDTO;
        }
        BigDecimal payPrice = param.getPayPrice();
        facadeDTO.setVipPurchasePrice(payPrice.multiply(this.commissionProperties.getEle().getVipPurchaseRateForPayPrice()));
        facadeDTO.setPurchasePrice(payPrice.multiply(this.commissionProperties.getEle().getCommonCommissionPurchaseRateForPayPrice()));
        facadeDTO.setParentPrice(payPrice.multiply(this.commissionProperties.getEle().getCommonCommissionRateParentForPayPrice()));
        facadeDTO.setGrandParentPrice(payPrice.multiply(this.commissionProperties.getEle().getCommonCommissionRateGrandParentForPayPrice()));
        facadeDTO.setCommissionType(Byte.valueOf((byte)4));
        return facadeDTO;
    }

    public CommissionPlatformFacadeDTO getPlatformCommission(GetPlatformCommissionParam param) {
        CommissionPlatformFacadeDTO platformFacadeDTO;
        SuperiorDto superiorDtoBySpecialId = this.userInfoFacadeService.getSuperiorBySpecialId(param.getSpecialId());
        SuperiorDto superiorDtoByRelationId = this.userInfoFacadeService.getSuperiorByRelationId(param.getRelationId());
        boolean isPurchaseBySelf = this.isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId);
        boolean isVip = this.vipFacadeService.isVip(superiorDtoByRelationId.getUserId());
        BigDecimal unitPrice = param.getPayPrice().divide(BigDecimal.valueOf(Objects.isNull(param.getGoodsNum()) ? 1L : param.getGoodsNum()), 2, RoundingMode.DOWN);
        log.info("\u83b7\u53d6\u8fd4\u4f63\u4fe1\u606f\uff0cisPurchaseBySelf: {} isVip: {}, \u8ba2\u5355\u652f\u4ed8\u91d1\u989d: {}, \u5546\u54c1\u6570\u91cf: {}, \u8ba1\u7b97\u5546\u54c1\u5355\u4ef7: {} ", new Object[]{isPurchaseBySelf, isVip, param.getPayPrice(), param.getGoodsNum(), unitPrice});
        if (isPurchaseBySelf) {
            platformFacadeDTO = this.getCustomCommission(param.getGoodsId(), param.getCommissionPrice());
            if (Objects.nonNull(platformFacadeDTO)) {
                log.info("\u6839\u636e\u8bf7\u6c42\u53c2\u6570: {} \u83b7\u53d6\u5230\u7279\u6b8a\u8fd4\u4f63\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)platformFacadeDTO));
                return platformFacadeDTO;
            }
            platformFacadeDTO = this.getNoviceCommission(param.getGoodsId(), unitPrice, superiorDtoByRelationId.getUserId());
            if (Objects.nonNull(platformFacadeDTO)) {
                log.info("\u6839\u636e\u8bf7\u6c42\u53c2\u6570: {} \u83b7\u53d6\u5230\u65b0\u4eba\u8fd4\u4f63\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)platformFacadeDTO));
                return platformFacadeDTO;
            }
            platformFacadeDTO = this.getVipZeroCommission(param.getGoodsId(), unitPrice, isVip, superiorDtoByRelationId.getUserId());
            if (Objects.nonNull(platformFacadeDTO)) {
                log.info("\u6839\u636e\u8bf7\u6c42\u53c2\u6570: {} \u83b7\u53d6\u5230vip 0\u5143\u8d2d\u8fd4\u4f63\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)platformFacadeDTO));
                return platformFacadeDTO;
            }
        }
        String vipPurchaseCommission = this.vipFacadeService.vipPurchase();
        String purchaseCommission = this.commodityInfoProperties.getCommonCommissionPurchase();
        String parentCommission = this.commodityInfoProperties.getCommonCommissionParent();
        String grandparentCommission = this.commodityInfoProperties.getCommonCommissionGrandParent();
        platformFacadeDTO = CommissionPlatformFacadeDTO.builder().goodsId(param.getGoodsId()).vipPurchasePrice(this.calCommonCommissionPrice(vipPurchaseCommission, param.getCommissionPrice())).purchasePrice(this.calCommonCommissionPrice(purchaseCommission, param.getCommissionPrice())).commissionType(Byte.valueOf((byte)0)).build();
        if (isVip) {
            platformFacadeDTO.setParentPrice(this.calCommonCommissionPrice(parentCommission, platformFacadeDTO.getVipPurchasePrice()));
            platformFacadeDTO.setGrandParentPrice(this.calCommonCommissionPrice(grandparentCommission, platformFacadeDTO.getVipPurchasePrice()));
        } else {
            platformFacadeDTO.setParentPrice(this.calCommonCommissionPrice(parentCommission, platformFacadeDTO.getPurchasePrice()));
            platformFacadeDTO.setGrandParentPrice(this.calCommonCommissionPrice(grandparentCommission, platformFacadeDTO.getPurchasePrice()));
        }
        log.info("\u6839\u636e\u8bf7\u6c42\u53c2\u6570: {} \u83b7\u53d6\u5230\u666e\u901a\u8fd4\u4f63\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param), (Object)JSON.toJSONString((Object)platformFacadeDTO));
        return platformFacadeDTO;
    }

    public CommissionPlatformFacadeDTO getPlatformCommission(Long goodsId, BigDecimal commissionPrice, String specialId, String relationId, BigDecimal payPrice, Long goodsNum) {
        return this.getPlatformCommission(GetPlatformCommissionParam.builder().goodsId(goodsId).relationId(relationId).specialId(specialId).commissionPrice(commissionPrice).payPrice(payPrice).goodsNum(goodsNum).build());
    }

    private CommissionPlatformFacadeDTO getCustomCommission(Long goodsId, BigDecimal commissionPrice) {
        KeyGenerator platformCommissionKey = CommodityRedisKeyConstants.COMMODITY_PLATFORM_COMMISSION;
        CustomRebateBean customRebateBean = (CustomRebateBean)this.redisHashMapAdapter.get(platformCommissionKey, goodsId.toString(), CustomRebateBean.class);
        if (Objects.nonNull(customRebateBean)) {
            CommissionPlatformFacadeDTO commissionPlatformDTO = CommissionPlatformFacadeDTO.builder().goodsId(goodsId).build();
            commissionPlatformDTO.setPurchasePrice(this.calCommissionPrice(customRebateBean.getPurchasePrice(), customRebateBean.getPurchaseRate(), commissionPrice));
            commissionPlatformDTO.setParentPrice(this.calCommissionPrice(customRebateBean.getParentPrice(), customRebateBean.getParentRate(), commissionPlatformDTO.getPurchasePrice()));
            commissionPlatformDTO.setGrandParentPrice(this.calCommissionPrice(customRebateBean.getGrandParentPrice(), customRebateBean.getGrandParentRate(), commissionPrice));
            commissionPlatformDTO.setCommissionType(Byte.valueOf((byte)3));
            return commissionPlatformDTO;
        }
        return null;
    }

    private CommissionPlatformFacadeDTO getNoviceCommission(Long goodsId, BigDecimal unitPrice, Long purchaseUserId) {
        if (this.isNewbieRight(purchaseUserId, goodsId).booleanValue()) {
            CommissionPlatformFacadeDTO platformFacadeDTO = new CommissionPlatformFacadeDTO();
            platformFacadeDTO.setGoodsId(goodsId);
            platformFacadeDTO.setVipPurchasePrice(unitPrice);
            platformFacadeDTO.setPurchasePrice(unitPrice);
            platformFacadeDTO.setParentPrice(BigDecimal.ZERO);
            platformFacadeDTO.setGrandParentPrice(BigDecimal.ZERO);
            platformFacadeDTO.setCommissionType(Byte.valueOf((byte)2));
            return platformFacadeDTO;
        }
        return null;
    }

    private CommissionPlatformFacadeDTO getVipZeroCommission(Long goodsId, BigDecimal unitPrice, boolean isVip, Long userId) {
        if (isVip && this.isVipZeroCommodity(goodsId)) {
            CommodityDetailDTO commodityDetailDTO = this.commodityInfoService.getCommodityDetail(CommodityDetailQueryParam.builder().goodsId(goodsId).vipUser(Boolean.valueOf(true)).userId(userId).detailType(Integer.valueOf(1)).build());
            if (Objects.isNull(commodityDetailDTO)) {
                log.warn("\u67e5\u8be2vip 0\u5143\u8d2d\u5546\u54c1: {} \u5931\u8d25\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8fd4\u4f63\u4fe1\u606f", (Object)goodsId);
                return null;
            }
            Double maxCommodityPrice = commodityDetailDTO.getDiscountPrice();
            if (Objects.isNull(maxCommodityPrice)) {
                log.warn("\u67e5\u8be2vip 0\u5143\u8d2d\u5546\u54c1: {} \u8d2d\u4e70\u4ef7\u683c\u5931\u8d25\uff0c\u65e0\u6cd5\u8ba1\u7b97\u8fd4\u4f63\u4fe1\u606f\uff0c\u67e5\u8be2\u5230\u7684\u5546\u54c1\u4fe1\u606f: {}", (Object)goodsId, (Object)JSON.toJSONString((Object)commodityDetailDTO));
                return null;
            }
            BigDecimal maxCommodityPriceD = BigDecimal.valueOf(maxCommodityPrice);
            BigDecimal rebate = maxCommodityPriceD.compareTo(unitPrice) < 0 ? maxCommodityPriceD : unitPrice;
            log.info("\u8ba1\u7b97vip 0\u5143\u8d2d\u5546\u54c1\u6700\u7ec8\u8fd4\u4f63\u91d1\u989d: {} \u8ba2\u5355\u7684\u8d2d\u4e70\u5355\u4ef7: {}, \u5546\u54c1\u7684\u5238\u540e\u4ef7: {} ", new Object[]{rebate, unitPrice, maxCommodityPriceD});
            CommissionPlatformFacadeDTO platformFacadeDTO = new CommissionPlatformFacadeDTO();
            platformFacadeDTO.setGoodsId(goodsId);
            platformFacadeDTO.setVipPurchasePrice(rebate);
            platformFacadeDTO.setPurchasePrice(rebate);
            platformFacadeDTO.setParentPrice(this.calCommonCommissionPrice(this.commodityInfoProperties.getCommonCommissionParent(), platformFacadeDTO.getVipPurchasePrice()));
            platformFacadeDTO.setGrandParentPrice(this.calCommonCommissionPrice(this.commodityInfoProperties.getCommonCommissionGrandParent(), platformFacadeDTO.getVipPurchasePrice()));
            platformFacadeDTO.setCommissionType(Byte.valueOf((byte)1));
            return platformFacadeDTO;
        }
        return null;
    }

    @Override
    public Double getReservePrice(Long goodsId) {
        PriceByThirdStrategyService priceByThirdStrategyService = this.reservePriceServiceFactory();
        if (null == priceByThirdStrategyService) {
            log.error("\u521b\u5efa\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4ee3\u7801");
            return null;
        }
        return priceByThirdStrategyService.getPriceInfo(goodsId);
    }

    @Override
    public Boolean isNewbieRight(Long userId, Long goodsId) {
        if (!this.isNewbieRightCommodity(goodsId)) {
            return false;
        }
        return this.isNewbieRightForUser(userId);
    }

    @Override
    public CommissionAndCoupon getCommissionAndCouponByThird(Long goodsId) {
        PriceByThirdStrategyService priceByThirdStrategyService = this.commissionServiceFactory();
        if (null == priceByThirdStrategyService) {
            log.error("\u521b\u5efa\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4ee3\u7801");
            return null;
        }
        return priceByThirdStrategyService.getCommissionAndCoupon(goodsId);
    }

    @Override
    public boolean isNewbieRightForUser(Long userId) {
        if (Objects.isNull(userId)) {
            return false;
        }
        return this.redisSetAdapter.exists(CommonCommodityRedisKey.COMMODITY_NEWBIE_USER_SET, (Object)userId) == false;
    }

    @Override
    public boolean isNewbieRightCommodity(Long goodsId) {
        KeyGenerator newbieCommoditySetKey = CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET;
        return this.redisSetAdapter.exists(newbieCommoditySetKey, (Object)String.valueOf(goodsId));
    }

    @Override
    public boolean isVipZeroCommodity(Long goodsId) {
        KeyGenerator newbieCommoditySetKey = CommodityRedisKeyConstants.COMMODITY_VIP_ZERO_SET;
        return this.redisSetAdapter.exists(newbieCommoditySetKey, (Object)String.valueOf(goodsId));
    }

    @Override
    public PlatformCommissionRateInfo getPlatformCommissionRateInfo(Long goodsId) {
        PlatformCommissionRateInfo platformCommissionRateInfo = new PlatformCommissionRateInfo();
        platformCommissionRateInfo.setVipCommissionRate(Double.valueOf(this.vipFacadeService.vipPurchase()));
        platformCommissionRateInfo.setGoodsId(goodsId);
        KeyGenerator platformCommissionKey = CommodityRedisKeyConstants.COMMODITY_PLATFORM_COMMISSION;
        CustomRebateBean customRebateBean = (CustomRebateBean)this.redisHashMapAdapter.get(platformCommissionKey, goodsId.toString(), CustomRebateBean.class);
        if (Objects.nonNull(customRebateBean)) {
            platformCommissionRateInfo.setSpecialCommissionFlag(true);
            if (!CommodityNumberUtils.isNullOrZero((BigDecimal)customRebateBean.getPurchasePrice())) {
                platformCommissionRateInfo.setCommissionRegularPrice(Double.valueOf(customRebateBean.getPurchasePrice().doubleValue()));
            }
            if (!CommodityNumberUtils.isNullOrZero((BigDecimal)customRebateBean.getPurchaseRate())) {
                platformCommissionRateInfo.setCommissionRate(Double.valueOf(customRebateBean.getPurchaseRate().divide(new BigDecimal("100"), 2, 1).doubleValue()));
            }
            return platformCommissionRateInfo;
        }
        platformCommissionRateInfo.setSpecialCommissionFlag(false);
        platformCommissionRateInfo.setCommissionRate(Double.valueOf(this.commodityInfoProperties.getCommonCommissionPurchase()));
        return platformCommissionRateInfo;
    }

    @Override
    public String getCommonPurchaseRate() {
        return this.commodityInfoProperties.getCommonCommissionPurchase();
    }

    @Override
    public boolean isRuleNewbiePrice(Double commissionPrice) {
        return (double)this.commodityInfoProperties.getNewbieMaxPrice() >= commissionPrice;
    }

    @Override
    public boolean isRuleVipZeroPrice(Double platformCommissionPrice, Double discountPrice) {
        if (Objects.isNull(platformCommissionPrice) || Objects.isNull(discountPrice)) {
            log.warn("\u4f63\u91d1: {} \u5238\u540e\u4ef7: {}\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u8ba1\u7b97vip\u4ef7\u683c\u662f\u5426\u8d85\u8fc7\u9608\u503c", (Object)platformCommissionPrice, (Object)discountPrice);
            return false;
        }
        BigDecimal discountPriceD = BigDecimal.valueOf(discountPrice);
        BigDecimal platformCommissionPriceD = BigDecimal.valueOf(platformCommissionPrice);
        BigDecimal subsidyForPurchase = discountPriceD.subtract(platformCommissionPriceD);
        BigDecimal subsidyForPurchaseParent = discountPriceD.multiply(new BigDecimal(this.commodityInfoProperties.getCommonCommissionParent())).setScale(2, 1);
        BigDecimal totalSubsidy = subsidyForPurchaseParent.add(subsidyForPurchase);
        return totalSubsidy.compareTo(BigDecimal.valueOf(this.commodityInfoProperties.getVipZeroMaxPrice().intValue())) <= 0;
    }

    private PriceByThirdStrategyService commissionServiceFactory() {
        return this.commissionStrategyByWyService;
    }

    private PriceByThirdStrategyService reservePriceServiceFactory() {
        return this.reservePriceByTbService;
    }

    private BigDecimal calCommissionPrice(BigDecimal platformCommissionPrice, BigDecimal platformCommissionRate, BigDecimal commissionPrice) {
        if (null == commissionPrice) {
            log.warn("\u4e09\u65b9\u63d0\u4f9b\u7684\u4f63\u91d1\u503c\u4e3a\u7a7a");
            return new BigDecimal("0.00");
        }
        BigDecimal finalCommissionPrice = null != platformCommissionPrice && BigDecimal.ZERO.compareTo(platformCommissionPrice) != 0 ? platformCommissionPrice.setScale(2, 1) : commissionPrice.multiply(platformCommissionRate.divide(new BigDecimal("100"), 2, 1));
        return finalCommissionPrice;
    }

    private BigDecimal calCommonCommissionPrice(String platformCommissionRate, BigDecimal commissionPrice) {
        if (null == commissionPrice) {
            log.error("\u4e09\u65b9\u63d0\u4f9b\u7684\u4f63\u91d1\u503c\u4e3a\u7a7a");
            return new BigDecimal("0.00");
        }
        if (StringUtils.isBlank((String)platformCommissionRate)) {
            return new BigDecimal("0.00");
        }
        return commissionPrice.multiply(new BigDecimal(platformCommissionRate)).setScale(2, 1);
    }

    private boolean isPurchaseBySelf(SuperiorDto superiorDtoBySpecialId, SuperiorDto superiorDtoByRelationId) {
        return null != superiorDtoBySpecialId && null != superiorDtoByRelationId && null != superiorDtoBySpecialId.getUserId() && superiorDtoBySpecialId.getUserId().equals(superiorDtoByRelationId.getUserId());
    }

    public Double getCouponPrice(Long goodsId) {
        if (Objects.isNull(goodsId)) {
            log.warn("\u83b7\u53d6\u5546\u54c1\u4f18\u60e0\u5238\uff0c\u5546\u54c1ID\u9519\u8bef\uff0cID\u4e3a[{}]", (Object)goodsId);
            return 0.0;
        }
        GetCommodityDetailParam param = new GetCommodityDetailParam();
        param.setCommodityId(goodsId);
        param.setQueryCouponInfo(false);
        CommodityInfoDTO commodityDetail = this.commodityInfoSourceProxyService.getCommodityDetail(param);
        if (Objects.isNull(commodityDetail)) {
            log.warn("\u83b7\u53d6\u4f18\u60e0\u5238\u91d1\u989d\u4e3a\u7a7a, \u5546\u54c1id\u4e3a[{}]", (Object)goodsId);
            return 0.0;
        }
        return Objects.isNull(commodityDetail.getCouponPrice()) ? 0.0 : commodityDetail.getCouponPrice();
    }
}

