/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.model.param.HotSearchBeanParam;
import com.bxm.fossicker.commodity.model.param.HotSearchParam;
import com.bxm.fossicker.commodity.model.vo.SearchLog;
import com.bxm.fossicker.commodity.service.CommoditySearchLogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommoditySearchLogServiceImpl
implements CommoditySearchLogService {
    private static final Logger log = LogManager.getLogger(CommoditySearchLogServiceImpl.class);
    @Resource
    CommoditySearchLogMapper commoditySearchLogMapper;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public boolean saveSearchLog(SearchLog searchLog) {
        this.commoditySearchLogMapper.deleteForRepeat(searchLog);
        int saveFlag = this.commoditySearchLogMapper.save(searchLog);
        return saveFlag > 0;
    }

    @Override
    public boolean deleteSearchLog(Long userId) {
        return this.commoditySearchLogMapper.updateStatus(userId);
    }

    @Override
    public List<String> getSearchLogByUserId(Long userId) {
        return this.commoditySearchLogMapper.getSearchLogByUserId(userId);
    }

    @Override
    public List<String> getHotSearchLog() {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("app_key", this.commodityInfoProperties.getQtkAppKey());
        paramMap.put("v", this.commodityInfoProperties.getQtkVersion());
        String resultStr = null;
        try {
            resultStr = OkHttpUtils.get((String)this.commodityInfoProperties.getQtkHotSearchUrl(), paramMap);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u70ed\u95e8\u641c\u7d22\u5f02\u5e38\uff1a", (Throwable)e);
        }
        HotSearchParam hotSearchLog = (HotSearchParam)JSONObject.parseObject((String)resultStr, HotSearchParam.class);
        assert (hotSearchLog != null);
        List list = hotSearchLog.getData();
        ArrayList<String> listStr = new ArrayList<String>();
        for (HotSearchBeanParam hotSearchBeanParam : list) {
            listStr.add(hotSearchBeanParam.getWord());
        }
        return listStr;
    }
}

