/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.vo.SearchLog;
import com.bxm.fossicker.commodity.service.CommoditySearchLogService;
import com.bxm.fossicker.commodity.service.CommoditySearchService;
import com.bxm.fossicker.commodity.service.strategy.CommodityQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommoditySearchServiceImpl
implements CommoditySearchService {
    private static final Logger log = LoggerFactory.getLogger(CommoditySearchServiceImpl.class);
    @Autowired
    private CommodityQueryService commodityQueryByWyImpl;
    @Autowired
    private CommodityQueryService commodityQueryByTbImpl;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private CommoditySearchLogService commoditySearchLogService;

    @Override
    public CommodityPageInfo<CommoditySearchDTO> getCommodityListByName(CommoditySearchParam commoditySearchParam) {
        CommodityPageInfo<CommoditySearchDTO> resultPageInfo = new CommodityPageInfo<CommoditySearchDTO>();
        this.saveSearchLog(commoditySearchParam);
        CommodityQueryService commodityQueryService = this.commodityQueryServiceFactory();
        if (null == commodityQueryService) {
            log.error("\u521b\u5efa\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u5b9e\u73b0\u65b9\u5f0f");
            return resultPageInfo;
        }
        resultPageInfo = commodityQueryService.queryCommodityByName(commoditySearchParam);
        return resultPageInfo;
    }

    @Override
    public CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam) {
        log.debug("\u901a\u8fc7\u7c98\u8d34\u677f\u4fe1\u606f\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)clipboardQueryParam);
        CommodityQueryService commodityQueryService = this.commodityQueryServiceFactory();
        if (null == commodityQueryService) {
            log.error("\u521b\u5efa\u670d\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u5b9e\u73b0\u65b9\u5f0f");
            return null;
        }
        CommoditySearchDTO result = commodityQueryService.getClipboardCommodity(clipboardQueryParam);
        log.debug("\u7c98\u8d34\u677f\u4fe1\u606f\u91c7\u7528\u7684\u670d\u52a1\uff1a{},\u67e5\u8be2\u53c2\u6570\uff1a{},\u5546\u54c1\u7ed3\u679c\uff1a{}", new Object[]{commodityQueryService.getClass(), clipboardQueryParam, result});
        return result;
    }

    private void saveSearchLog(CommoditySearchParam commoditySearchParam) {
        SearchLog searchLog = new SearchLog();
        searchLog.setWords(commoditySearchParam.getCommodityName());
        searchLog.setUserId(commoditySearchParam.getUserId());
        this.commoditySearchLogService.saveSearchLog(searchLog);
    }

    private CommodityQueryService commodityQueryServiceFactory() {
        CommodityQueryService matchService;
        switch (this.commodityInfoProperties.getSearchSource()) {
            case "weiyi": {
                matchService = this.commodityQueryByWyImpl;
                break;
            }
            default: {
                matchService = this.commodityQueryByTbImpl;
            }
        }
        return matchService;
    }
}

