/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.convert.CommodityDetailToSearchConvert;
import com.bxm.fossicker.commodity.domain.HistoryBrowsingMapper;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.dto.HistoryBrowsingDTO;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.HistoryBrowsingParam;
import com.bxm.fossicker.commodity.model.vo.HistoryBrowsingVO;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.HistoryBrowsingService;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HistoryBrowsingServiceImpl
implements HistoryBrowsingService {
    private static final Logger log = LogManager.getLogger(HistoryBrowsingServiceImpl.class);
    @Autowired
    private HistoryBrowsingMapper historyBrowsingMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private CommodityInfoService commodityInfoService;

    @Override
    public List<HistoryBrowsingDTO> getFootprint(HistoryBrowsingParam param) {
        List<HistoryBrowsingDTO> dtoList;
        if (Objects.isNull(param.getUserId())) {
            log.warn("\u83b7\u53d6\u5386\u53f2\u6d4f\u89c8\u8bb0\u5f55\uff0c\u7528\u6237ID[{}]\u4e3a\u7a7a", (Object)param.getUserId());
            return Lists.newArrayList();
        }
        if (Objects.isNull(param.getPageSize())) {
            param.setPageSize(Integer.valueOf(10));
        }
        if (Objects.isNull(param.getPageOn())) {
            param.setPageOn(Integer.valueOf(1));
        }
        while (true) {
            Page histories;
            if (CollectionUtils.isEmpty((Collection)(histories = PageHelper.startPage((int)param.getPageOn(), (int)param.getPageSize()).doSelectPage(() -> this.historyBrowsingMapper.getFootprint(param.getUserId()))))) {
                return Lists.newArrayList();
            }
            boolean vipFlag = this.vipFacadeService.isVip(param.getUserId());
            dtoList = histories.stream().collect(Collectors.groupingBy(p -> DateUtils.getClearDate((Date)p.getCreateTime()), Collectors.mapping(HistoryBrowsingVO::getGoodsId, Collectors.toList()))).entrySet().stream().sorted((a, b) -> ((Date)a.getKey()).compareTo((Date)b.getKey()) * -1).map(goodsIdList -> {
                List historyCommodities = ((List)goodsIdList.getValue()).stream().map(goodsId -> this.build((Long)goodsId, param.getUserId(), vipFlag)).filter(Objects::nonNull).collect(Collectors.toList());
                String day = ((DateFormat)DateUtils.DATE_FORMAT_MONTH_DAY_FORMAT_THREAD_LOCAL.get()).format((Date)goodsIdList.getKey());
                day = day.replace("\u6708", ".");
                day = day.replace("\u65e5", "");
                HistoryBrowsingDTO browsingDTO = new HistoryBrowsingDTO();
                browsingDTO.setDate(day);
                browsingDTO.setCommoditySearchDTO(historyCommodities);
                return browsingDTO;
            }).filter(p -> !CollectionUtils.isEmpty((Collection)p.getCommoditySearchDTO())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dtoList)) break;
            param.setPageOn(Integer.valueOf(param.getPageOn() + 1));
        }
        return dtoList;
    }

    private KeyGenerator buildKey(Long userId) {
        return CommodityRedisKeyConstants.BROWSE_HISTORY_SET.copy().appendKey((Object)userId).appendKey((Object)DateUtils.formatDate((Date)new Date()));
    }

    @Override
    public Boolean insertFootprint(Long userId, Long goodsId) {
        int recordCount;
        if (null == userId || null == goodsId) {
            log.warn("\u6dfb\u52a0\u5546\u54c1\u6d4f\u89c8\u8bb0\u5f55\uff0cuserID\u6216goodsID\u9519\u8bef\u3002userID\u4e3a[{}]\uff0cgoodsID\u4e3a[{}]", (Object)userId, (Object)goodsId);
            return false;
        }
        KeyGenerator key = this.buildKey(userId);
        boolean existsHistory = this.redisSetAdapter.exists(key, (Object)goodsId);
        if (existsHistory) {
            Date now = new Date();
            now = DateUtils.clearTimePart((Date)now);
            recordCount = this.historyBrowsingMapper.updateFootprintByUserId(userId, goodsId, now);
        } else {
            recordCount = this.insertHistory(userId, goodsId);
            this.redisSetAdapter.add(key, new Object[]{goodsId});
            this.redisSetAdapter.expire(key, (long)DateUtils.getCurSeconds());
        }
        return recordCount > 0;
    }

    private int insertHistory(Long userId, Long goodsId) {
        HistoryBrowsingVO addHistoryBrowsingVO = new HistoryBrowsingVO();
        addHistoryBrowsingVO.setId(this.sequenceCreater.nextLongId());
        addHistoryBrowsingVO.setUserId(userId);
        addHistoryBrowsingVO.setGoodsId(goodsId);
        addHistoryBrowsingVO.setCreateTime(new Date());
        return this.historyBrowsingMapper.insertFootprint(addHistoryBrowsingVO);
    }

    private CommoditySearchDTO build(Long goodsId, Long userId, boolean vipFlag) {
        CommodityDetailQueryParam param = CommodityDetailQueryParam.builder().userId(userId).vipUser(Boolean.valueOf(vipFlag)).goodsId(goodsId).queryBrowerAward(true).setLable(true).build();
        CommodityDetailDTO commodityDetail = this.commodityInfoService.getCommodityDetail(param);
        return CommodityDetailToSearchConvert.convert(commodityDetail);
    }

    public List<HistoryBrowsingDTO> build(HashMap<String, List<Long>> sameDayHistory, Long userId) {
        ArrayList<HistoryBrowsingDTO> histories = new ArrayList<HistoryBrowsingDTO>();
        for (Map.Entry<String, List<Long>> entry : sameDayHistory.entrySet()) {
            ArrayList commoditySearchDTOList = Lists.newArrayList();
            try {
                HistoryBrowsingDTO historyBrowsingDTO = new HistoryBrowsingDTO();
                historyBrowsingDTO.setDate(entry.getKey());
                historyBrowsingDTO.setCommoditySearchDTO((List)commoditySearchDTOList);
                histories.add(historyBrowsingDTO);
            }
            catch (Exception e) {
                log.warn("\u5546\u54c1\u8be6\u60c5\u5386\u53f2\u6d4f\u89c8\u8bb0\u5f55\uff0c\u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef");
            }
        }
        return histories;
    }
}

