/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.enums.SecKillTimeEnum;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.SecCommodityPage;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityDTO;
import com.bxm.fossicker.commodity.model.entry.CommodityInfo;
import com.bxm.fossicker.commodity.model.param.QuerySecKillCommodityParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.LocalTqgCommodityInfoService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalTqgCommodityServiceImpl
implements LocalTqgCommodityInfoService {
    private static final Logger log = LoggerFactory.getLogger(LocalTqgCommodityServiceImpl.class);
    @Autowired
    private CommodityInfoMapper commodityInfoMapper;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private BlackCommodityService blackCommodityService;
    private static final Long JU_COMMODITY_EXPIRES_SEC = 3600L;

    @Override
    public SecCommodityPage<SecKillCommodityDTO> getTqgCommodityList(QuerySecKillCommodityParam secKillCommodityParam, SecKillTimeEnum secKillTimeEnum) {
        SecCommodityPage resultPage = new SecCommodityPage();
        resultPage.setPageNum(secKillCommodityParam.getPageNum().intValue());
        resultPage.setPageSize(secKillCommodityParam.getPageSize().intValue());
        KeyGenerator secKillKey = CommodityRedisKeyConstants.COMMODITY_SEC_KILL_TAO.copy().appendKey((Object)secKillTimeEnum.getStartTimeHour()).appendKey((Object)secKillCommodityParam.getPageNum());
        Long userId = secKillCommodityParam.getUserId();
        String commodityListFromRedisStr = this.redisStringAdapter.getString(secKillKey);
        if (StringUtils.isNotBlank((CharSequence)commodityListFromRedisStr)) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6dd8\u62a2\u8d2d\u4fe1\u606f,redisKey:{}", (Object)secKillKey);
            List redisInfoList = JSONArray.parseArray((String)commodityListFromRedisStr, SecKillCommodityDTO.class);
            redisInfoList.forEach(secKillCommodityDTO -> this.getOtherInfo((SecKillCommodityDTO)secKillCommodityDTO, userId));
            redisInfoList.removeIf(secKillCommodityDTO -> this.blackCommodityService.isBlackCommodity(secKillCommodityDTO.getGoodsId()));
            resultPage.setList(redisInfoList);
            return resultPage;
        }
        Page page = PageHelper.startPage((Object)secKillCommodityParam).doSelectPage(() -> this.commodityInfoMapper.getTqgCommodityListByNow(secKillCommodityParam));
        Integer secKillType = secKillCommodityParam.getType();
        List queryList = page.getResult();
        if (null == queryList) {
            return resultPage;
        }
        List secKillCommodityDTOList = queryList.stream().map(commodityInfo -> this.convert((CommodityInfo)commodityInfo, userId, secKillType)).collect(Collectors.toList());
        secKillCommodityDTOList.removeIf(Objects::isNull);
        this.redisStringAdapter.set(secKillKey, (Object)JSON.toJSONString(secKillCommodityDTOList), JU_COMMODITY_EXPIRES_SEC.longValue());
        resultPage.setList(secKillCommodityDTOList);
        return resultPage;
    }

    private SecKillCommodityDTO convert(CommodityInfo commodityInfo, Long userId, Integer secKillType) {
        PlatformCommissionRateInfo platformCommission;
        SecKillCommodityDTO secKillCommodityDTO = SecKillCommodityDTO.builder().commodityTitle(commodityInfo.getCommodityTitle()).goodsId(Long.valueOf(commodityInfo.getGoodId())).imgUrl(commodityInfo.getMainPic()).totalAmount(commodityInfo.getTotalAmount()).soldNum(commodityInfo.getSoldNum()).startTime(DateUtils.formatDateTime((Date)commodityInfo.getStartTime())).endTime(DateUtils.formatDateTime((Date)commodityInfo.getEndTime())).soldStatus(Integer.valueOf(commodityInfo.getSoldNum() < commodityInfo.getTotalAmount() ? 1 : 0)).reservePrice(Double.valueOf(commodityInfo.getReservePrice().doubleValue())).couponPrice(Double.valueOf(commodityInfo.getCouponPrice().doubleValue())).build();
        secKillCommodityDTO.setSoldPercent(this.getSoldPercent(commodityInfo.getSoldNum(), commodityInfo.getTotalAmount()));
        if (3 == secKillType) {
            secKillCommodityDTO.setSoldStatus(Integer.valueOf(1));
            secKillCommodityDTO.setSoldNum(Long.valueOf(0L));
            secKillCommodityDTO.setSoldPercent(Double.valueOf(0.0));
        }
        if (null == (platformCommission = this.commodityPriceInfoService.getPlatformCommissionRateInfo(secKillCommodityDTO.getGoodsId()))) {
            return null;
        }
        Double couponPrice = commodityInfo.getCouponPrice().doubleValue();
        Double reservePrice = commodityInfo.getReservePrice().doubleValue();
        Double commissionPrice = CommodityCalUtils.calCommissionForPlatformCommission((PlatformCommissionRateInfo)platformCommission, (Double)commodityInfo.getCommissionPrice().doubleValue());
        Double commodityPrice = CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)couponPrice, (Double)commissionPrice);
        secKillCommodityDTO.setCouponPrice(couponPrice);
        secKillCommodityDTO.setCommissionPrice(commissionPrice);
        secKillCommodityDTO.setCommodityPrice(commodityPrice);
        this.getOtherInfo(secKillCommodityDTO, userId);
        return secKillCommodityDTO;
    }

    private Double getSoldPercent(Long soldNum, Long totalNum) {
        BigDecimal totalDecimal;
        if (null == soldNum || null == totalNum) {
            return 0.0;
        }
        BigDecimal soldDecimal = new BigDecimal(soldNum.toString());
        BigDecimal result = soldDecimal.divide(totalDecimal = new BigDecimal(totalNum.toString()), 3, 4);
        if (-1 == result.compareTo(new BigDecimal("0.01")) && 0 != result.compareTo(new BigDecimal("0"))) {
            return 1.0;
        }
        if (0 == result.compareTo(new BigDecimal(1)) || 1 == result.compareTo(new BigDecimal(1))) {
            return 100.0;
        }
        return result.multiply(new BigDecimal("100")).doubleValue();
    }

    public SecKillCommodityDTO getOtherInfo(SecKillCommodityDTO secKillCommodityDTO, Long userId) {
        CommodityGoldInfoDTO commodityGoldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(secKillCommodityDTO.getGoodsId(), userId);
        if (null != commodityGoldInfoDTO) {
            secKillCommodityDTO.setGoldNum(commodityGoldInfoDTO.getBrowseGold());
            secKillCommodityDTO.setGoldStatus(commodityGoldInfoDTO.getDrawFlag());
        }
        KeyGenerator remindCommodityKey = CommodityRedisKeyConstants.COMMODITY_REMIND.copy().appendKey((Object)userId).appendKey((Object)secKillCommodityDTO.getGoodsId());
        secKillCommodityDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, secKillCommodityDTO.getGoodsId()));
        secKillCommodityDTO.setRemindStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(remindCommodityKey)) ? 1 : 0));
        return secKillCommodityDTO;
    }
}

