/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommodityCommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.enums.SecKillTimeEnum;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.DtkPageInfo;
import com.bxm.fossicker.commodity.model.dto.InexpensiveCommodityDTO;
import com.bxm.fossicker.commodity.model.dto.JuCommoditySearchDataDTO;
import com.bxm.fossicker.commodity.model.dto.SecCommodityPage;
import com.bxm.fossicker.commodity.model.dto.SecCommodityTimeDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillByJuInfoDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityIndexDTO;
import com.bxm.fossicker.commodity.model.dto.SecKillCommodityIndexListDTO;
import com.bxm.fossicker.commodity.model.entry.CommodityInfo;
import com.bxm.fossicker.commodity.model.param.InexpensiveCommodityParam;
import com.bxm.fossicker.commodity.model.param.QuerySecKillCommodityParam;
import com.bxm.fossicker.commodity.model.param.RemindCommodityParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.LocalTqgCommodityInfoService;
import com.bxm.fossicker.commodity.service.SecKillCommodityService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.fossicker.commodity.service.impl.LocalCommodityInfoService;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.taobao.api.request.TbkJuTqgGetRequest;
import com.taobao.api.response.TbkJuTqgGetResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SecKillCommodityServiceImpl
implements SecKillCommodityService {
    private static final Logger log = LoggerFactory.getLogger(SecKillCommodityServiceImpl.class);
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private TbCommodityService tbCommodityService;
    @Autowired
    private BlackCommodityService blackCommodityService;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private LocalCommodityInfoService localCommodityInfoService;
    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceProxyService;
    @Autowired
    private LocalTqgCommodityInfoService localTqgCommodityInfoService;
    @Autowired
    private CommodityLabelService commodityLabelService;
    private static final Long SEC_KILL_COMMODITY_EXPIRES_SEC = 1200L;
    private static final Long JU_COMMODITY_EXPIRES_SEC = 3600L;
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);

    @Override
    public SecKillCommodityIndexListDTO getSecKillCommodityForIndex(Long userId) {
        LocalTime nowTime = LocalTime.now();
        SecKillTimeEnum secKillTimeEnum = SecKillTimeEnum.isWhichInTime((LocalTime)nowTime);
        LocalTime startTime = LocalTime.of(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin(), secKillTimeEnum.getStartTimeSec());
        LocalTime endTime = LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec());
        LocalDateTime endTimeDateTime = secKillTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? LocalDate.now().plusDays(1L).atTime(endTime) : LocalDate.now().atTime(endTime);
        ZoneId zone = ZoneId.systemDefault();
        Date startTimeDate = Date.from(LocalDate.now().atTime(startTime).atZone(zone).toInstant());
        Date endTimeDate = Date.from(endTimeDateTime.atZone(zone).toInstant());
        QuerySecKillCommodityParam secKillCommodityParam = new QuerySecKillCommodityParam();
        secKillCommodityParam.setStartTime(DateUtils.formatDateTime((Date)startTimeDate));
        secKillCommodityParam.setEndTime(DateUtils.formatDateTime((Date)endTimeDate));
        secKillCommodityParam.setType(Integer.valueOf(1));
        secKillCommodityParam.setUserId(userId);
        SecCommodityPage<SecKillCommodityDTO> secCommodityPage = this.getSecKillCommodityList(secKillCommodityParam);
        if (Objects.isNull(secCommodityPage) && CollectionUtils.isEmpty((Collection)secCommodityPage.getList())) {
            List<SecCommodityTimeDTO> commodityTimeDTOS = this.getSecTimeList();
            for (SecCommodityTimeDTO commodityTimeDTO : commodityTimeDTOS) {
                secKillCommodityParam = new QuerySecKillCommodityParam();
                secKillCommodityParam.setStartTime(commodityTimeDTO.getStartTime());
                secKillCommodityParam.setEndTime(commodityTimeDTO.getEndTime());
                secKillCommodityParam.setType(commodityTimeDTO.getType());
                secKillCommodityParam.setUserId(userId);
                secCommodityPage = this.getSecKillCommodityList(secKillCommodityParam);
                if (CollectionUtils.isEmpty((Collection)secCommodityPage.getList())) continue;
                break;
            }
        }
        SecKillCommodityIndexListDTO secKillCommodityIndexListDTO = new SecKillCommodityIndexListDTO();
        if (Objects.nonNull(secCommodityPage) && !CollectionUtils.isEmpty((Collection)secCommodityPage.getList())) {
            List<SecKillCommodityIndexDTO> taoResultList = secCommodityPage.getList().stream().limit(3L).map(this::convert).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(taoResultList)) {
                taoResultList.forEach(secKillCommodityIndexDTO -> this.getGoldInfo((SecKillCommodityIndexDTO)secKillCommodityIndexDTO, userId));
            }
            secKillCommodityIndexListDTO.setTaoCommodityList(taoResultList);
        }
        InexpensiveCommodityParam inexpensiveCommodityParam = new InexpensiveCommodityParam();
        inexpensiveCommodityParam.setPageId("1");
        inexpensiveCommodityParam.setPageSize(Integer.valueOf(200));
        inexpensiveCommodityParam.setSortType(Integer.valueOf(0));
        inexpensiveCommodityParam.setUserId(userId);
        DtkPageInfo<InexpensiveCommodityDTO> dtoDtkPageInfo = this.getJuCommodity(inexpensiveCommodityParam);
        List<SecKillCommodityIndexDTO> juSecKillCommodityList = dtoDtkPageInfo.getList().stream().limit(3L).map(this::convert).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(juSecKillCommodityList)) {
            juSecKillCommodityList.forEach(secKillCommodityIndexDTO -> this.getGoldInfo((SecKillCommodityIndexDTO)secKillCommodityIndexDTO, userId));
        }
        secKillCommodityIndexListDTO.setJuCommodityList(juSecKillCommodityList);
        secKillCommodityIndexListDTO.setCountDownTime(this.calCountDownTime(secKillTimeEnum));
        return secKillCommodityIndexListDTO;
    }

    @Override
    public List<SecCommodityTimeDTO> getSecTimeList() {
        LocalTime nowTime = LocalTime.now();
        SecKillTimeEnum nowTimeEnum = SecKillTimeEnum.isWhichInTime((LocalTime)nowTime);
        return this.sortListByEnum(nowTimeEnum);
    }

    @Override
    public SecCommodityPage<SecKillCommodityDTO> getSecKillCommodityList(QuerySecKillCommodityParam secKillCommodityParam) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = LocalDateTime.parse(secKillCommodityParam.getStartTime(), df);
        SecKillTimeEnum secKillTimeEnum = SecKillTimeEnum.isWhichInTime((LocalTime)startTime.toLocalTime());
        SecCommodityPage<SecKillCommodityDTO> resultPage = this.localTqgCommodityInfoService.getTqgCommodityList(secKillCommodityParam, secKillTimeEnum);
        resultPage.getList().forEach(p -> p.setLabelType(this.commodityLabelService.goodsLabel(p.getNewbieRight(), 0.0, p.getGoodsId())));
        resultPage.setCountDownTime(this.calCountDownTimeByType(secKillCommodityParam));
        return resultPage;
    }

    @Override
    public DtkPageInfo<InexpensiveCommodityDTO> getJuCommodity(InexpensiveCommodityParam inexpensiveCommodityParam) {
        DtkPageInfo<InexpensiveCommodityDTO> resultPage = this.queryJuCommodityByDtk(inexpensiveCommodityParam);
        resultPage.getList().forEach(p -> p.setLabelType(this.commodityLabelService.goodsLabel(p.getNewbieRight(), 0.0, p.getGoodsId())));
        return resultPage;
    }

    @Override
    public Boolean remindCommodity(RemindCommodityParam remindCommodityParam) {
        KeyGenerator remindCommodityKey = CommodityRedisKeyConstants.COMMODITY_REMIND.copy().appendKey((Object)remindCommodityParam.getUserId()).appendKey((Object)remindCommodityParam.getGoodsId());
        this.redisStringAdapter.set(remindCommodityKey, (Object)remindCommodityParam.getStartTime(), 86400L);
        return true;
    }

    @Override
    public int getRemindCommodityStatus(Long goodsId, Long userId) {
        KeyGenerator remindCommodityKey = CommodityRedisKeyConstants.COMMODITY_REMIND.copy().appendKey((Object)userId).appendKey((Object)goodsId);
        String remindCommodityRecord = this.redisStringAdapter.getString(remindCommodityKey);
        return StringUtils.isBlank((CharSequence)remindCommodityRecord) ? 0 : 1;
    }

    private List<SecKillCommodityIndexDTO> queryIndexSecKillCommodityByTao(SecKillTimeEnum secKillTimeEnum, Long userId) {
        KeyGenerator secKillKey = CommodityRedisKeyConstants.COMMODITY_SEC_KILL_INDEX_TAO.copy().appendKey((Object)secKillTimeEnum.getStartTimeHour());
        String commodityListFromRedisStr = this.redisStringAdapter.getString(secKillKey);
        if (StringUtils.isNotBlank((CharSequence)commodityListFromRedisStr)) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u7684\u9996\u9875\u6dd8\u62a2\u8d2d\u4fe1\u606f,redisKey:{}", (Object)secKillKey);
            List commodityList = JSONArray.parseArray((String)commodityListFromRedisStr, SecKillCommodityIndexDTO.class);
            return commodityList.stream().limit(3L).collect(Collectors.toList());
        }
        TbkJuTqgGetRequest req = this.assembleTqgParamForIndex(secKillTimeEnum);
        TbkJuTqgGetResponse rsp = this.tbCommodityService.getTqgCommodity(req);
        List<SecKillCommodityIndexDTO> resultList = new ArrayList<SecKillCommodityIndexDTO>();
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getResults())) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
            return resultList;
        }
        resultList = this.convertSecKillIndexCommodityInfoList(rsp.getResults(), userId);
        if (!CollectionUtils.isEmpty(resultList)) {
            this.redisStringAdapter.set(secKillKey, (Object)JSON.toJSONString(resultList), SEC_KILL_COMMODITY_EXPIRES_SEC.longValue());
        }
        return resultList;
    }

    private DtkPageInfo<InexpensiveCommodityDTO> queryJuCommodityByDtk(InexpensiveCommodityParam inexpensiveCommodityParam) {
        List<InexpensiveCommodityDTO> resultList;
        Long userId = inexpensiveCommodityParam.getUserId();
        DtkPageInfo resultPage = new DtkPageInfo();
        KeyGenerator juCommodityRedisKey = this.createJuCommodityRedisKey(inexpensiveCommodityParam);
        String commodityListFromRedisStr = this.redisStringAdapter.getString(juCommodityRedisKey);
        if (StringUtils.isNotBlank((CharSequence)commodityListFromRedisStr)) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u805a\u5212\u7b97\u4fe1\u606f,redisKey:{}", (Object)juCommodityRedisKey);
            resultList = JSONArray.parseArray((String)commodityListFromRedisStr, InexpensiveCommodityDTO.class);
        } else {
            List<CommodityInfo> commodityInfos = this.localCommodityInfoService.queryJuhuasuanCommodity();
            resultList = commodityInfos.stream().map(p -> this.convert((CommodityInfo)p, userId)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(resultList)) {
                this.redisStringAdapter.set(juCommodityRedisKey, (Object)JSON.toJSONString(resultList), JU_COMMODITY_EXPIRES_SEC.longValue());
                this.commodityInfoSourceProxyService.preheatCommodityInfo(resultList.stream().map(InexpensiveCommodityDTO::getGoodsId).collect(Collectors.toList()));
            }
            resultPage.setList(resultList);
            resultPage.setPageId("");
            resultPage.setPageSize(Integer.valueOf(200));
        }
        resultList.removeIf(inexpensiveCommodityDTO -> this.blackCommodityService.isBlackCommodity(inexpensiveCommodityDTO.getGoodsId()));
        resultList.forEach(inexpensiveCommodityDTO -> this.getGoldInfo((InexpensiveCommodityDTO)inexpensiveCommodityDTO, userId));
        resultPage.setList(resultList);
        resultPage.setPageId("");
        resultPage.setPageSize(Integer.valueOf(200));
        return resultPage;
    }

    private InexpensiveCommodityDTO convert(CommodityInfo info, Long userId) {
        long goodsId = Long.valueOf(info.getGoodId());
        InexpensiveCommodityDTO inexpensiveCommodityDTO = InexpensiveCommodityDTO.builder().commodityTitle(info.getCommodityTitle()).goodsId(Long.valueOf(info.getGoodId())).imgUrl(info.getMainPic()).shopType(Integer.valueOf(Objects.isNull(info.getShopType()) ? 0 : info.getShopType().intValue())).soldNum(Objects.toString(info.getSoldNum())).build();
        BigDecimal soldPercent = BigDecimal.ZERO;
        if (Objects.nonNull(info.getTotalAmount()) && info.getTotalAmount() != 0L) {
            soldPercent = BigDecimal.valueOf(info.getSoldNum()).divide(BigDecimal.valueOf(info.getTotalAmount()), 2, RoundingMode.HALF_DOWN).multiply(ONE_HUNDRED).setScale(0, RoundingMode.HALF_DOWN);
        }
        Double soldPercentd = 1.0;
        if (soldPercent.intValue() == 0 && info.getSoldNum() > 0L) {
            soldPercentd = (double)soldPercentd;
        }
        if (soldPercent.intValue() > 100) {
            soldPercentd = 100.0;
        }
        inexpensiveCommodityDTO.setSoldPercent(soldPercentd);
        inexpensiveCommodityDTO.setReservePrice(Double.valueOf(Objects.isNull(info.getReservePrice()) ? 0.0 : info.getReservePrice().doubleValue()));
        PlatformCommissionRateInfo commissionInfoDTO = this.commodityPriceInfoService.getPlatformCommissionRateInfo(goodsId);
        inexpensiveCommodityDTO.setCouponPrice(Double.valueOf(Objects.isNull(info.getCouponPrice()) ? 0.0 : info.getCouponPrice().doubleValue()));
        inexpensiveCommodityDTO.setCommissionPrice(CommodityCalUtils.calCommissionForPlatformCommission((Double)commissionInfoDTO.getCommissionRegularPrice(), (Double)info.getCommissionPrice().doubleValue(), (Double)commissionInfoDTO.getCommissionRate()));
        inexpensiveCommodityDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)info.getDiscountPrice().doubleValue(), (Double)inexpensiveCommodityDTO.getCommissionPrice()));
        this.getGoldInfo(inexpensiveCommodityDTO, userId);
        return inexpensiveCommodityDTO;
    }

    private List<SecKillCommodityDTO> querySecKillCommodityByTqg(QuerySecKillCommodityParam secKillCommodityParam, SecKillTimeEnum secKillTimeEnum) {
        KeyGenerator secKillKey = CommodityRedisKeyConstants.COMMODITY_SEC_KILL_TAO.copy().appendKey((Object)secKillTimeEnum.getStartTimeHour()).appendKey((Object)secKillCommodityParam.getPageNum());
        Long userId = secKillCommodityParam.getUserId();
        String commodityListFromRedisStr = this.redisStringAdapter.getString(secKillKey);
        if (StringUtils.isNotBlank((CharSequence)commodityListFromRedisStr)) {
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6dd8\u62a2\u8d2d\u4fe1\u606f,redisKey:{}", (Object)secKillKey);
            List redisInfoList = JSONArray.parseArray((String)commodityListFromRedisStr, SecKillCommodityDTO.class);
            redisInfoList.forEach(secKillCommodityDTO -> this.getOtherInfo((SecKillCommodityDTO)secKillCommodityDTO, userId));
            redisInfoList.removeIf(secKillCommodityDTO -> this.blackCommodityService.isBlackCommodity(secKillCommodityDTO.getGoodsId()));
            return redisInfoList;
        }
        TbkJuTqgGetRequest req = this.assembleTqgParam(secKillCommodityParam, secKillTimeEnum);
        TbkJuTqgGetResponse rsp = this.tbCommodityService.getTqgCommodity(req);
        List<SecKillCommodityDTO> resultList = new ArrayList<SecKillCommodityDTO>();
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getResults())) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
            return resultList;
        }
        resultList = this.convertSecKillCommodityInfoList(rsp.getResults(), secKillCommodityParam);
        if (!CollectionUtils.isEmpty(resultList)) {
            this.redisStringAdapter.set(secKillKey, (Object)JSON.toJSONString(resultList), SEC_KILL_COMMODITY_EXPIRES_SEC.longValue());
        }
        return resultList;
    }

    private InexpensiveCommodityDTO getGoldInfo(InexpensiveCommodityDTO inexpensiveCommodityDTO, Long userId) {
        CommodityGoldInfoDTO commodityGoldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(inexpensiveCommodityDTO.getGoodsId(), userId);
        if (null != commodityGoldInfoDTO) {
            inexpensiveCommodityDTO.setGoldNum(commodityGoldInfoDTO.getBrowseGold());
            inexpensiveCommodityDTO.setGoldStatus(commodityGoldInfoDTO.getDrawFlag());
        }
        inexpensiveCommodityDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, inexpensiveCommodityDTO.getGoodsId()));
        return inexpensiveCommodityDTO;
    }

    private SecKillCommodityIndexDTO getGoldInfo(SecKillCommodityIndexDTO secKillCommodityIndexDTO, Long userId) {
        CommodityGoldInfoDTO commodityGoldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(secKillCommodityIndexDTO.getGoodsId(), userId);
        if (null != commodityGoldInfoDTO) {
            secKillCommodityIndexDTO.setGoldNum(commodityGoldInfoDTO.getBrowseGold());
            secKillCommodityIndexDTO.setGoldStatus(commodityGoldInfoDTO.getDrawFlag());
        }
        return secKillCommodityIndexDTO;
    }

    public SecKillCommodityDTO getOtherInfo(SecKillCommodityDTO secKillCommodityDTO, Long userId) {
        KeyGenerator remindCommodityKey;
        CommodityGoldInfoDTO commodityGoldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(secKillCommodityDTO.getGoodsId(), userId);
        if (null != commodityGoldInfoDTO) {
            secKillCommodityDTO.setGoldNum(commodityGoldInfoDTO.getBrowseGold());
            secKillCommodityDTO.setGoldStatus(commodityGoldInfoDTO.getDrawFlag());
        }
        secKillCommodityDTO.setRemindStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(remindCommodityKey = CommodityRedisKeyConstants.COMMODITY_REMIND.copy().appendKey((Object)userId).appendKey((Object)secKillCommodityDTO.getGoodsId()))) ? 1 : 0));
        secKillCommodityDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, secKillCommodityDTO.getGoodsId()));
        return secKillCommodityDTO;
    }

    private void assembleTimeByEnum(TbkJuTqgGetRequest req, SecKillTimeEnum secKillTimeEnum) {
        LocalTime startTime = LocalTime.of(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin(), secKillTimeEnum.getStartTimeSec());
        LocalTime endTime = LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec());
        LocalDateTime endTimeDateTime = secKillTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? LocalDate.now().plusDays(1L).atTime(endTime) : LocalDate.now().atTime(endTime);
        ZoneId zone = ZoneId.systemDefault();
        Date startTimeDate = Date.from(LocalDate.now().atTime(startTime).atZone(zone).toInstant());
        Date endTimeDate = Date.from(endTimeDateTime.atZone(zone).toInstant());
        req.setStartTime(startTimeDate);
        req.setEndTime(endTimeDate);
    }

    private Map<String, Object> assembleJuCommodityQueryParamIndex() {
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put("version", this.commodityInfoProperties.getDtkCommodityVersion());
        paramMap.put("appKey", this.commodityInfoProperties.getDtkCommodityAppKey());
        paramMap.put("pageSize", "6");
        paramMap.put("pageId", "1");
        paramMap.put("juHuaSuan", 1);
        paramMap.put("sign", SignMD5Util.getSignStr(paramMap, (String)this.commodityInfoProperties.getDtkCommodityAppSecret()));
        return paramMap;
    }

    private Map<String, Object> assembleJuCommodityQueryParam(InexpensiveCommodityParam inexpensiveCommodityParam) {
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put("version", this.commodityInfoProperties.getDtkCommodityVersion());
        paramMap.put("appKey", this.commodityInfoProperties.getDtkCommodityAppKey());
        paramMap.put("pageSize", inexpensiveCommodityParam.getPageSize());
        paramMap.put("pageId", inexpensiveCommodityParam.getPageId());
        paramMap.put("juHuaSuan", 1);
        paramMap.put("sort", inexpensiveCommodityParam.getSortType());
        if (null != inexpensiveCommodityParam.getPriceLowerLimit()) {
            paramMap.put("priceLowerLimit", inexpensiveCommodityParam.getPriceLowerLimit());
        }
        if (null != inexpensiveCommodityParam.getPriceUpperLimit()) {
            paramMap.put("priceUpperLimit", inexpensiveCommodityParam.getPriceUpperLimit());
        }
        paramMap.put("sign", SignMD5Util.getSignStr(paramMap, (String)this.commodityInfoProperties.getDtkCommodityAppSecret()));
        return paramMap;
    }

    private List<SecKillCommodityIndexDTO> convertIndexJuCommodityInfoList(JuCommoditySearchDataDTO juCommoditySearchDataDTO, Long userId) {
        ArrayList<SecKillCommodityIndexDTO> resultList = new ArrayList();
        List juCommoditySearchDataDTOList = juCommoditySearchDataDTO.getList();
        for (SecKillByJuInfoDTO secKillByJuInfoDTO : juCommoditySearchDataDTOList) {
            SecKillCommodityIndexDTO secKillCommodityIndexDTO = SecKillCommodityIndexDTO.builder().commodityPrice(secKillByJuInfoDTO.getOriginalPrice()).commodityTitle(secKillByJuInfoDTO.getDtitle()).goodsId(Long.valueOf(secKillByJuInfoDTO.getGoodsId())).imgUrl(secKillByJuInfoDTO.getMainPic()).build();
            Long goodsId = secKillCommodityIndexDTO.getGoodsId();
            Double reservePrice = this.commodityPriceInfoService.getReservePrice(goodsId);
            if (null == reservePrice) {
                log.error("\u9996\u9875\u805a\u5212\u7b97\u83b7\u53d6\u539f\u4ef7\u4e3a\u7a7a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
                continue;
            }
            CommodityCommissionAndCoupon commissionInfo = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(goodsId, userId);
            if (null != commissionInfo) {
                Double commissionPrice = CommodityCalUtils.calCommission((CommodityCommissionAndCoupon)commissionInfo, (Double)reservePrice);
                if (this.isZero(commissionPrice)) continue;
                secKillCommodityIndexDTO.setCommodityPrice(CommodityCalUtils.calCommodityPriceWithSubtractingCoupon((Double)reservePrice, (Double)commissionInfo.getCouponPrice()));
            }
            resultList.add(secKillCommodityIndexDTO);
        }
        resultList = resultList.stream().limit(3L).collect(Collectors.toList());
        return resultList;
    }

    private List<InexpensiveCommodityDTO> convertJuCommodityInfoList(JuCommoditySearchDataDTO juCommoditySearchDataDTO, Long userId) {
        ArrayList<InexpensiveCommodityDTO> resultList = new ArrayList<InexpensiveCommodityDTO>();
        List juCommoditySearchDataDTOList = juCommoditySearchDataDTO.getList();
        for (SecKillByJuInfoDTO secKillByJuInfoDTO : juCommoditySearchDataDTOList) {
            if (this.blackCommodityService.isBlackCommodity(Long.valueOf(secKillByJuInfoDTO.getGoodsId()))) continue;
            InexpensiveCommodityDTO inexpensiveCommodityDTO = InexpensiveCommodityDTO.builder().commodityTitle(secKillByJuInfoDTO.getDtitle()).goodsId(Long.valueOf(secKillByJuInfoDTO.getGoodsId())).imgUrl(secKillByJuInfoDTO.getMainPic()).shopType(secKillByJuInfoDTO.getShopType()).soldNum(null == secKillByJuInfoDTO.getMonthSales() ? "0" : secKillByJuInfoDTO.getMonthSales().toString()).build();
            Double soldPercent = secKillByJuInfoDTO.getDiscounts() * 100.0;
            inexpensiveCommodityDTO.setSoldPercent(soldPercent);
            Long goodsId = inexpensiveCommodityDTO.getGoodsId();
            Double reservePrice = this.commodityPriceInfoService.getReservePrice(goodsId);
            if (null == reservePrice) {
                log.error("\u805a\u5212\u7b97\u5217\u8868\u83b7\u53d6\u5546\u54c1\u539f\u4ef7\u4e3a\u7a7a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
                continue;
            }
            inexpensiveCommodityDTO.setReservePrice(reservePrice);
            CommodityCommissionAndCoupon commissionInfoDTO = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(goodsId, userId);
            if (null != commissionInfoDTO) {
                Double commissionPrice = CommodityCalUtils.calCommission((CommodityCommissionAndCoupon)commissionInfoDTO, (Double)reservePrice);
                Double couponPrice = commissionInfoDTO.getCouponPrice();
                if (this.isZero(commissionPrice) || this.isZero(couponPrice)) continue;
                inexpensiveCommodityDTO.setCouponPrice(couponPrice);
                inexpensiveCommodityDTO.setCommissionPrice(commissionPrice);
                inexpensiveCommodityDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)commissionInfoDTO.getCouponPrice(), (Double)commissionPrice));
            }
            this.getGoldInfo(inexpensiveCommodityDTO, userId);
            resultList.add(inexpensiveCommodityDTO);
        }
        return resultList;
    }

    private SecKillCommodityIndexDTO convert(SecKillCommodityDTO secKillCommodityDTO) {
        SecKillCommodityIndexDTO secKillCommodityIndexDTO = SecKillCommodityIndexDTO.builder().reservePrice(secKillCommodityDTO.getReservePrice()).commodityPrice(secKillCommodityDTO.getCommodityPrice()).commodityTitle(secKillCommodityDTO.getCommodityTitle()).goodsId(secKillCommodityDTO.getGoodsId()).imgUrl(secKillCommodityDTO.getImgUrl()).build();
        return secKillCommodityIndexDTO;
    }

    private SecKillCommodityIndexDTO convert(InexpensiveCommodityDTO inexpensiveCommodityDTO) {
        return SecKillCommodityIndexDTO.builder().commodityPrice(inexpensiveCommodityDTO.getCommodityPrice()).commodityTitle(inexpensiveCommodityDTO.getCommodityTitle()).goodsId(inexpensiveCommodityDTO.getGoodsId()).imgUrl(inexpensiveCommodityDTO.getImgUrl()).build();
    }

    private List<SecKillCommodityIndexDTO> convertSecKillIndexCommodityInfoList(List<TbkJuTqgGetResponse.Results> secKillByTaoInfoList, Long userId) {
        ArrayList<SecKillCommodityIndexDTO> resultList = new ArrayList();
        for (TbkJuTqgGetResponse.Results secKillByTaoInfoDTO : secKillByTaoInfoList) {
            SecKillCommodityIndexDTO secKillCommodityIndexDTO = SecKillCommodityIndexDTO.builder().reservePrice(Double.valueOf(secKillByTaoInfoDTO.getZkFinalPrice())).commodityPrice(Double.valueOf(secKillByTaoInfoDTO.getZkFinalPrice())).commodityTitle(secKillByTaoInfoDTO.getTitle()).goodsId(secKillByTaoInfoDTO.getNumIid()).imgUrl(secKillByTaoInfoDTO.getPicUrl()).build();
            Long goodsId = secKillCommodityIndexDTO.getGoodsId();
            Double reservePrice = this.commodityPriceInfoService.getReservePrice(goodsId);
            if (null == reservePrice) continue;
            CommodityCommissionAndCoupon commissionInfoDTO = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(goodsId, userId);
            if (null != commissionInfoDTO) {
                Double commissionPrice = CommodityCalUtils.calCommission((CommodityCommissionAndCoupon)commissionInfoDTO, (Double)reservePrice);
                if (this.isZero(commissionPrice)) continue;
                secKillCommodityIndexDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)commissionInfoDTO.getCouponPrice(), (Double)commissionPrice));
            }
            resultList.add(secKillCommodityIndexDTO);
        }
        resultList = resultList.stream().limit(3L).collect(Collectors.toList());
        return resultList;
    }

    private List<SecKillCommodityDTO> convertSecKillCommodityInfoList(List<TbkJuTqgGetResponse.Results> secKillByTaoInfoList, QuerySecKillCommodityParam secKillCommodityParam) {
        Long userId = secKillCommodityParam.getUserId();
        ArrayList<SecKillCommodityDTO> resultList = new ArrayList<SecKillCommodityDTO>();
        for (TbkJuTqgGetResponse.Results taoInfo : secKillByTaoInfoList) {
            if (this.blackCommodityService.isBlackCommodity(taoInfo.getNumIid())) continue;
            SecKillCommodityDTO secKillCommodityDTO = SecKillCommodityDTO.builder().commodityTitle(taoInfo.getTitle()).goodsId(taoInfo.getNumIid()).imgUrl(taoInfo.getPicUrl()).totalAmount(taoInfo.getTotalAmount()).soldNum(taoInfo.getSoldNum()).startTime(taoInfo.getStartTime()).endTime(taoInfo.getEndTime()).soldStatus(Integer.valueOf(taoInfo.getSoldNum() < taoInfo.getTotalAmount() ? 1 : 0)).build();
            secKillCommodityDTO.setSoldPercent(this.getSoldPercent(taoInfo.getSoldNum(), taoInfo.getTotalAmount()));
            Long goodsId = secKillCommodityDTO.getGoodsId();
            Double reservePrice = this.commodityPriceInfoService.getReservePrice(goodsId);
            if (null == reservePrice) {
                log.error("\u6dd8\u62a2\u8d2d\u5217\u8868\u83b7\u53d6\u5546\u54c1\u539f\u4ef7\u4e3a\u7a7a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
                continue;
            }
            secKillCommodityDTO.setReservePrice(reservePrice);
            CommodityCommissionAndCoupon commissionInfoDTO = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(goodsId, secKillCommodityParam.getUserId());
            if (null != commissionInfoDTO) {
                Double commissionPrice = CommodityCalUtils.calCommission((CommodityCommissionAndCoupon)commissionInfoDTO, (Double)reservePrice);
                Double couponPrice = commissionInfoDTO.getCouponPrice();
                if (this.isZero(commissionPrice) || this.isZero(couponPrice)) continue;
                secKillCommodityDTO.setCommissionPrice(commissionPrice);
                secKillCommodityDTO.setCouponPrice(couponPrice);
                secKillCommodityDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)commissionInfoDTO.getCouponPrice(), (Double)commissionPrice));
            }
            this.getOtherInfo(secKillCommodityDTO, userId);
            resultList.add(secKillCommodityDTO);
        }
        return resultList;
    }

    private Long calCountDownTime(SecKillTimeEnum secKillTimeEnum) {
        LocalDateTime nowDateTime = LocalDateTime.now();
        if (SecKillTimeEnum.SEC_KILL_22 == secKillTimeEnum) {
            LocalDateTime endTimeDateTime = LocalDate.now().plusDays(1L).atTime(LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec()));
            return Duration.between(nowDateTime, endTimeDateTime).toMillis();
        }
        LocalDateTime endTimeDateTime = LocalDate.now().atTime(LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec()));
        return Duration.between(nowDateTime, endTimeDateTime).toMillis();
    }

    private Long calCountDownTimeByType(QuerySecKillCommodityParam secKillCommodityParam) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = LocalDateTime.parse(secKillCommodityParam.getStartTime(), df);
        LocalDateTime endTime = LocalDateTime.parse(secKillCommodityParam.getEndTime(), df);
        Long countDownTime = 0L;
        Integer type = secKillCommodityParam.getType();
        LocalDateTime nowTime = LocalDateTime.now();
        if (1 == type) {
            return countDownTime;
        }
        if (2 == type) {
            return Duration.between(nowTime, endTime).toMillis();
        }
        if (3 == type) {
            return Duration.between(nowTime, startTime).toMillis();
        }
        return countDownTime;
    }

    public List<SecCommodityTimeDTO> sortListByEnum(SecKillTimeEnum nowTimeEnum) {
        ArrayList<SecCommodityTimeDTO> secKillTimeList = new ArrayList<SecCommodityTimeDTO>();
        SecKillTimeEnum.buildEnumRelation();
        SecCommodityTimeDTO preByPreTimeDTO = this.assembleSecKillTimeByPre(nowTimeEnum, nowTimeEnum.getPreEnum().getPreEnum());
        secKillTimeList.add(preByPreTimeDTO);
        SecCommodityTimeDTO preTimeDTO = this.assembleSecKillTimeByPre(nowTimeEnum, nowTimeEnum.getPreEnum());
        secKillTimeList.add(preTimeDTO);
        SecCommodityTimeDTO nowTimeDTO = this.assembleSecKillTimeByNow(nowTimeEnum);
        secKillTimeList.add(nowTimeDTO);
        SecCommodityTimeDTO afterTimeDTO = this.assembleSecKillTimeByAfter(nowTimeEnum, nowTimeEnum.getNextEnum());
        secKillTimeList.add(afterTimeDTO);
        SecCommodityTimeDTO afterByAfterTimeDTO = this.assembleSecKillTimeByAfter(nowTimeEnum, nowTimeEnum.getNextEnum().getNextEnum());
        secKillTimeList.add(afterByAfterTimeDTO);
        return secKillTimeList;
    }

    private SecCommodityTimeDTO assembleSecKillTimeByPre(SecKillTimeEnum nowTimeEnum, SecKillTimeEnum preTimeEnum) {
        LocalDateTime endDateTime;
        LocalDateTime startDateTime;
        LocalDate nowDay = LocalDate.now();
        LocalDate preDay = LocalDate.now().plusDays(-1L);
        if (preTimeEnum.getStartTimeHour() < nowTimeEnum.getStartTimeHour()) {
            LocalDate startDay = nowDay;
            startDateTime = SecKillTimeEnum.getDateStartTimeByEnum((LocalDate)startDay, (SecKillTimeEnum)preTimeEnum);
            LocalDate endTimeDay = preTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? startDay.plusDays(1L) : startDay;
            endDateTime = SecKillTimeEnum.getDateEndTimeByEnum((LocalDate)endTimeDay, (SecKillTimeEnum)preTimeEnum);
        } else {
            LocalDate startDay = preDay;
            startDateTime = SecKillTimeEnum.getDateStartTimeByEnum((LocalDate)startDay, (SecKillTimeEnum)preTimeEnum);
            LocalDate endTimeDay = preTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? startDay.plusDays(1L) : startDay;
            endDateTime = SecKillTimeEnum.getDateEndTimeByEnum((LocalDate)endTimeDay, (SecKillTimeEnum)preTimeEnum);
        }
        DateTimeFormatter dataFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        SecCommodityTimeDTO secCommodityTimeDTO = SecCommodityTimeDTO.builder().startTime(dataFormatter.format(startDateTime)).endTime(dataFormatter.format(endDateTime)).showContent("\u5df2\u5f00\u62a2").type(Integer.valueOf(1)).showTime(timeFormatter.format(LocalTime.of(startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond()))).build();
        return secCommodityTimeDTO;
    }

    private SecCommodityTimeDTO assembleSecKillTimeByAfter(SecKillTimeEnum nowTimeEnum, SecKillTimeEnum afterTimeEnum) {
        LocalDateTime endDateTime;
        LocalDateTime startDateTime;
        LocalDate nowDay = LocalDate.now();
        if (afterTimeEnum.getStartTimeHour() < nowTimeEnum.getStartTimeHour()) {
            LocalDate startDay = nowDay.plusDays(1L);
            startDateTime = SecKillTimeEnum.getDateStartTimeByEnum((LocalDate)startDay, (SecKillTimeEnum)afterTimeEnum);
            LocalDate endTimeDay = afterTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? startDay.plusDays(1L) : startDay;
            endDateTime = SecKillTimeEnum.getDateEndTimeByEnum((LocalDate)endTimeDay, (SecKillTimeEnum)afterTimeEnum);
        } else {
            LocalDate startDay = nowDay;
            startDateTime = SecKillTimeEnum.getDateStartTimeByEnum((LocalDate)startDay, (SecKillTimeEnum)afterTimeEnum);
            LocalDate endTimeDay = afterTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? startDay.plusDays(1L) : startDay;
            endDateTime = SecKillTimeEnum.getDateEndTimeByEnum((LocalDate)endTimeDay, (SecKillTimeEnum)afterTimeEnum);
        }
        DateTimeFormatter dataFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        SecCommodityTimeDTO secCommodityTimeDTO = SecCommodityTimeDTO.builder().startTime(dataFormatter.format(startDateTime)).endTime(dataFormatter.format(endDateTime)).showContent("\u5373\u5c06\u5f00\u62a2").type(Integer.valueOf(3)).showTime(timeFormatter.format(LocalTime.of(startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond()))).build();
        return secCommodityTimeDTO;
    }

    private SecCommodityTimeDTO assembleSecKillTimeByNow(SecKillTimeEnum nowTimeEnum) {
        LocalDate startDay = LocalDate.now();
        LocalDateTime startDateTime = SecKillTimeEnum.getDateStartTimeByEnum((LocalDate)startDay, (SecKillTimeEnum)nowTimeEnum);
        LocalDate endTimeDay = nowTimeEnum == SecKillTimeEnum.SEC_KILL_22 ? startDay.plusDays(1L) : startDay;
        LocalDateTime endDateTime = SecKillTimeEnum.getDateEndTimeByEnum((LocalDate)endTimeDay, (SecKillTimeEnum)nowTimeEnum);
        DateTimeFormatter dataFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        SecCommodityTimeDTO secCommodityTimeDTO = SecCommodityTimeDTO.builder().startTime(dataFormatter.format(startDateTime)).endTime(dataFormatter.format(endDateTime)).showContent("\u62a2\u8d2d\u8fdb\u884c\u4e2d").type(Integer.valueOf(2)).showTime(timeFormatter.format(LocalTime.of(startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond()))).build();
        return secCommodityTimeDTO;
    }

    private TbkJuTqgGetRequest assembleTqgParam(QuerySecKillCommodityParam secKillCommodityParam, SecKillTimeEnum secKillTimeEnum) {
        TbkJuTqgGetRequest req = new TbkJuTqgGetRequest();
        req.setAdzoneId(Long.valueOf(this.commodityInfoProperties.getTbCommodityZoneId()));
        req.setFields("click_url,pic_url,reserve_price,zk_final_price,total_amount,sold_num,title,category_name,start_time,end_time");
        req.setPageNo(Long.valueOf(secKillCommodityParam.getPageNum().intValue()));
        req.setPageSize(Long.valueOf(secKillCommodityParam.getPageSize().intValue()));
        this.assembleTimeByEnum(req, secKillTimeEnum);
        return req;
    }

    private TbkJuTqgGetRequest assembleTqgParamForIndex(SecKillTimeEnum secKillTimeEnum) {
        TbkJuTqgGetRequest req = new TbkJuTqgGetRequest();
        req.setAdzoneId(Long.valueOf(this.commodityInfoProperties.getTbCommodityZoneId()));
        req.setFields("click_url,pic_url,reserve_price,zk_final_price,total_amount,sold_num,title,category_name,start_time,end_time");
        req.setPageNo(Long.valueOf(1L));
        req.setPageSize(Long.valueOf(6L));
        this.assembleTimeByEnum(req, secKillTimeEnum);
        return req;
    }

    private KeyGenerator createJuCommodityRedisKey(InexpensiveCommodityParam inexpensiveCommodityParam) {
        KeyGenerator redisKey = CommodityRedisKeyConstants.COMMODITY_SEC_KILL_JU.copy();
        if (null != inexpensiveCommodityParam.getSortType()) {
            redisKey.appendKey((Object)("type_" + inexpensiveCommodityParam.getSortType()));
        }
        if (null != inexpensiveCommodityParam.getPriceLowerLimit()) {
            redisKey.appendKey((Object)("lower_" + inexpensiveCommodityParam.getPriceLowerLimit()));
        }
        if (null != inexpensiveCommodityParam.getPriceUpperLimit()) {
            redisKey.appendKey((Object)("upper_" + inexpensiveCommodityParam.getPriceUpperLimit()));
        }
        if (StringUtils.isNotBlank((CharSequence)inexpensiveCommodityParam.getPageId())) {
            redisKey.appendKey((Object)("page_" + inexpensiveCommodityParam.getPageId()));
        }
        return redisKey;
    }

    private boolean isZero(Double price) {
        return new Double("0").equals(price);
    }

    private Double getSoldPercent(Long soldNum, Long totalNum) {
        BigDecimal totalDecimal;
        if (null == soldNum || null == totalNum) {
            return 0.0;
        }
        BigDecimal soldDecimal = new BigDecimal(soldNum.toString());
        BigDecimal result = soldDecimal.divide(totalDecimal = new BigDecimal(totalNum.toString()), 3, 4);
        if (-1 == result.compareTo(new BigDecimal("0.01")) && 0 != result.compareTo(new BigDecimal("0"))) {
            return 1.0;
        }
        return result.multiply(new BigDecimal("100")).doubleValue();
    }

    public static void main(String[] args) {
        SecKillCommodityServiceImpl secKillCommodityService = new SecKillCommodityServiceImpl();
        System.out.println(secKillCommodityService.getSoldPercent(0L, 1000L));
    }
}

