/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.facade.service.ShortLinkFacadeService;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.AdvertTicketProperties;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.facade.TicketFacadeService;
import com.bxm.fossicker.commodity.model.dto.AdvertTicketResultDto;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.model.param.TicketInfo;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.util.PictureMerge;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketFacadeServiceImpl
implements TicketFacadeService {
    private static final Logger log = LogManager.getLogger(TicketFacadeServiceImpl.class);
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceService;
    @Autowired
    private AdvertTicketProperties advertTicketProperties;
    @Autowired
    private ShortLinkFacadeService shortLinkFacadeService;
    @Autowired
    private AliyunOSSService aliyunOSSService;
    @Resource
    private CommoditySearchLogMapper commoditySearchLogMapper;
    String pathStr = "qtj/gif/ticket/";
    String suffix = ".gif";

    public Message adAdvertTicket(Long goodsId) throws Exception {
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);
        CommodityInfoDTO localCommodity = this.commodityInfoSourceService.getLocalCommodity(detailParam);
        if (Objects.isNull(localCommodity)) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u5546\u54c1\u6570\u636e\u5f02\u5e38");
        }
        String linkUrl = this.shortLinkFacadeService.getGoodsShortLink(goodsId);
        if (Objects.isNull(linkUrl)) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u8df3\u94fe\u5f02\u5e38");
        }
        String imgUrl = this.genImg(String.valueOf(localCommodity.getCouponPrice().intValue()), goodsId.toString());
        if (Objects.isNull(imgUrl)) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u7d20\u6750\u56fe\u7247\u751f\u6210\u5f02\u5e38");
        }
        log.info("\u5e7f\u544a\u5377\u7d20\u6750\u56fe\u7247\u5730\u5740 imgUrl : {}", (Object)imgUrl);
        boolean adTicketOk = this.addTicket(localCommodity, linkUrl, imgUrl);
        if (!adTicketOk) {
            return Message.build().setSuccess(Boolean.FALSE.booleanValue()).setMessage("\u751f\u6210\u5e7f\u544a\u5377\u4fe1\u606f\u5f02\u5e38");
        }
        return Message.build();
    }

    private String genImg(String markContent, String goodsId) throws Exception {
        String bgImgURL = this.advertTicketProperties.getBgImgUrl();
        int size = 90;
        int x = 160;
        int y = 190;
        if (markContent.length() >= 4) {
            size = 70;
        }
        log.info("marContent : " + markContent);
        log.info("bgImgURL : " + bgImgURL);
        byte[] rb = PictureMerge.getGifSticker((String)markContent, (String)bgImgURL, (int)size, (int)x, (int)y);
        String imageUrl = this.aliyunOSSService.upload(rb, this.pathStr + goodsId + this.suffix);
        return imageUrl;
    }

    private boolean addTicket(CommodityInfoDTO localCommodity, String url, String imgUrl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", String.valueOf(localCommodity.getCouponPrice().intValue()) + "\u5143\u9650\u91cf\u4f18\u60e0\u5238");
        map.put("vars", "0");
        map.put("intro", "\u5929\u732b\u65d7\u8230\u5e97\uff01\u8840\u4e8f\u51b2\u9500\u91cf\uff5e");
        map.put("buttonTxt", "\u7acb\u5373\u9886\u53d6");
        map.put("image", imgUrl);
        map.put("status", "1");
        map.put("clickThreshold", "100");
        map.put("isPopup", "0");
        String httpResult = this.queryHttpPostWithToken(this.advertTicketProperties.getAdAssetUrl(), map, this.advertTicketProperties.getToken());
        if (Objects.isNull(httpResult)) {
            return false;
        }
        AdvertTicketResultDto result = (AdvertTicketResultDto)JSON.parseObject((String)httpResult, AdvertTicketResultDto.class);
        log.info("\u7d20\u6750ID : {}", (Object)result.getReturnValue());
        HashMap<String, Object> mapTicket = new HashMap<String, Object>();
        mapTicket.put("assetsids", result.getReturnValue());
        mapTicket.put("url", url);
        mapTicket.put("name", "QTJ" + localCommodity.getGoodsId());
        mapTicket.put("advertiser", this.advertTicketProperties.getAdvertiser());
        mapTicket.put("settleType", 1);
        mapTicket.put("type", 1);
        mapTicket.put("price", localCommodity.getPlatformCommissionPrice() * 0.4);
        mapTicket.put("budgetDaily", 10000);
        mapTicket.put("validStartDate", "2019-10-24");
        mapTicket.put("validEndDate", "2099-12-30");
        mapTicket.put("tags", this.advertTicketProperties.getTags());
        mapTicket.put("domainCode", this.advertTicketProperties.getDomainCode());
        mapTicket.put("booleanCitys", false);
        mapTicket.put("apps", "5,1,2");
        mapTicket.put("oss", "1,2,4");
        mapTicket.put("standaloneCost", 0);
        mapTicket.put("weight", 100);
        mapTicket.put("controlDto.booleanTimes", false);
        mapTicket.put("controlDto.noimei", 0);
        mapTicket.put("controlDto.imeinomatching", 0);
        mapTicket.put("ocpcConf.isSupportOcpc", 1);
        mapTicket.put("ocpcConf.cpaExpectPrice", 4);
        mapTicket.put("ocpcConf.closeThreshold", 280);
        mapTicket.put("flowPackageArray", "[]");
        mapTicket.put("flowPackageArrayConfs", "[]");
        mapTicket.put("isGroup", false);
        mapTicket.put("isEffectMonitor", 1);
        mapTicket.put("ae", this.advertTicketProperties.getAe());
        mapTicket.put("status", 3);
        String httpResultTicket = this.queryHttpPostWithToken(this.advertTicketProperties.getAdTicketUrl(), mapTicket, this.advertTicketProperties.getToken());
        AdvertTicketResultDto resultTicket = null;
        if (Objects.isNull(httpResultTicket)) {
            return false;
        }
        resultTicket = (AdvertTicketResultDto)JSON.parseObject((String)httpResultTicket, AdvertTicketResultDto.class);
        log.info("\u5e7f\u544a\u5377ID : {}", (Object)resultTicket.getReturnValue());
        TicketInfo info = new TicketInfo();
        info.setAssetId(result.getReturnValue());
        info.setTicketId(resultTicket.getReturnValue());
        info.setCouponPrice(localCommodity.getCouponPrice());
        info.setPlatformCommissionPrice(localCommodity.getPlatformCommissionPrice());
        info.setUrl(imgUrl);
        this.redisHashMapAdapter.put(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO, localCommodity.getGoodsId().toString(), (Object)JSONObject.toJSONString((Object)info));
        return Boolean.TRUE;
    }

    public boolean updateAdvertTicket(Long goodsId) throws Exception {
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);
        CommodityInfoDTO localCommodity = this.commodityInfoSourceService.getLocalCommodity(detailParam);
        if (Objects.isNull(localCommodity)) {
            return false;
        }
        String redisStr = (String)this.redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO, localCommodity.getGoodsId().toString(), String.class);
        TicketInfo info = null;
        if (!Objects.isNull(redisStr)) {
            info = (TicketInfo)JSONObject.parseObject((String)redisStr, TicketInfo.class);
        }
        if (Objects.isNull(info)) {
            return false;
        }
        if (localCommodity.getStatus() == 0) {
            this.deleteAdvertTicket(goodsId);
            return true;
        }
        if (localCommodity.getCouponPrice().equals(info.getCouponPrice()) && localCommodity.getPlatformCommissionPrice().equals(info.getPlatformCommissionPrice())) {
            return false;
        }
        String imgUrl = this.genImg(String.valueOf(localCommodity.getCouponPrice().intValue()), goodsId.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", info.getAssetId());
        map.put("name", String.valueOf(localCommodity.getCouponPrice().intValue()) + "\u5143\u9650\u91cf\u4f18\u60e0\u5238");
        map.put("vars", "0");
        map.put("intro", "\u5929\u732b\u65d7\u8230\u5e97\uff01\u8840\u4e8f\u51b2\u9500\u91cf\uff5e");
        map.put("buttonTxt", "\u7acb\u5373\u9886\u53d6");
        map.put("image", imgUrl);
        map.put("status", "1");
        map.put("clickThreshold", "100");
        map.put("isPopup", "0");
        String httpResult = this.queryHttpPostWithToken(this.advertTicketProperties.getUpdateAssetUrl(), map, this.advertTicketProperties.getToken());
        AdvertTicketResultDto result = null;
        if (!Objects.isNull(httpResult)) {
            result = (AdvertTicketResultDto)JSON.parseObject((String)httpResult, AdvertTicketResultDto.class);
        }
        if (!Objects.isNull(result)) {
            info.setUrl(imgUrl);
            this.redisHashMapAdapter.put(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO, localCommodity.getGoodsId().toString(), (Object)JSONObject.toJSONString((Object)info));
        }
        return true;
    }

    public int deleteAdvertTicket(Long goodsId) {
        String ticketInfoStr = (String)this.redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO, goodsId.toString(), String.class);
        if (StringUtils.isNotBlank((String)ticketInfoStr)) {
            TicketInfo info = (TicketInfo)JSONObject.parseObject((String)ticketInfoStr, TicketInfo.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", info.getTicketId());
            map.put("status", 2);
            this.queryHttpPostWithToken(this.advertTicketProperties.getUpStatusTicketUrl(), map, this.advertTicketProperties.getToken());
        }
        return 1;
    }

    public int updateAdvertTicket() {
        List goodsIds = this.commoditySearchLogMapper.getPoolInfo(5);
        int updateNum = 0;
        int needUpdateNum = 0;
        for (String goodsId : goodsIds) {
            try {
                if (!this.needToUpdate(Long.valueOf(goodsId))) continue;
                ++needUpdateNum;
                this.updateAdvertTicket(Long.valueOf(goodsId));
                ++updateNum;
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5e7f\u544a\u5377\u5185\u5bb9\u51fa\u95ee\u9898\u4e86\uff1agoodsId:{}", (Object)goodsId);
                e.printStackTrace();
            }
        }
        log.info("\u66f4\u65b0\u4f18\u60e0\u5377\u4ef7\u683c\u548c\u4f63\u91d1\u503c\u4e0d\u4e00\u6837\u7684\u5377\uff0c\u6c60\u5185\u5377\u5171{}\u6761\uff0c\u6709{}\u6761\u9700\u8981\u66f4\u65b0\uff0c\u6210\u529f\u66f4\u65b0{}\u6761", (Object)goodsIds.size(), (Object)needUpdateNum, (Object)updateNum);
        return updateNum;
    }

    private boolean needToUpdate(Long goodsId) {
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);
        CommodityInfoDTO localCommodity = this.commodityInfoSourceService.getLocalCommodity(detailParam);
        if (Objects.isNull(localCommodity)) {
            return false;
        }
        String redisStr = (String)this.redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO, localCommodity.getGoodsId().toString(), String.class);
        TicketInfo info = null;
        if (!Objects.isNull(redisStr)) {
            info = (TicketInfo)JSONObject.parseObject((String)redisStr, TicketInfo.class);
        }
        if (Objects.isNull(info)) {
            return false;
        }
        if (localCommodity.getStatus() == 0) {
            return true;
        }
        return !localCommodity.getCouponPrice().equals(info.getCouponPrice()) || !localCommodity.getPlatformCommissionPrice().equals(info.getPlatformCommissionPrice());
    }

    private String queryHttpPostWithToken(String queryUrl, Map<String, Object> queryParamMap, String token) {
        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; ++tryTimes) {
            try {
                resultStr = OkHttpUtils.postFormWithToken((String)queryUrl, queryParamMap, (String)token);
            }
            catch (IOException e) {
                log.error("\u6839\u636e\u53c2\u6570\u8bf7\u6c42http\u63a5\u53e3\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570:{},\u5f02\u5e38:{}", (Object)JSON.toJSONString(queryParamMap), (Object)e);
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resultStr)) continue;
            return resultStr;
        }
        return resultStr;
    }
}

