/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.config.VipZeroCommodityProperties;
import com.bxm.fossicker.commodity.model.constant.CommodityRedisKey;
import com.bxm.fossicker.commodity.model.param.ChoicenessListParam;
import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.model.param.PoolCommodityListParam;
import com.bxm.fossicker.commodity.model.param.UserIdParam;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.VipChoicenessCommodityListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroCommodityBriefListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroCommodityListVO;
import com.bxm.fossicker.commodity.model.vo.VipZeroPurchaseInfo;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.VipCommodityService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.fossicker.user.facade.VirtualUserFacadeService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VipCommodityServiceImpl
implements VipCommodityService {
    @Resource
    private VirtualUserFacadeService virtualUserFacadeService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private CommodityInfoService commodityInfoService;
    @Resource
    private VipZeroCommodityProperties vipZeroCommodityProperties;
    @Resource
    private CommodityListServiceProxy commodityListServiceProxy;
    private static final String CONGRATULATIONS = "\u606d\u559c";
    private static final String ZERO_PURCHASE = "0\u5143\u8d2d\u5f97";

    @Override
    public List<VipZeroCommodityBriefListVO> zeroBriefList(UserIdParam param, boolean isPublicRequest) {
        int end;
        List<VipZeroCommodityListVO> vipZeroCommodityListVOS = this.zeroList(param, isPublicRequest);
        int n = end = vipZeroCommodityListVOS.size() < this.vipZeroCommodityProperties.getBriefNum() ? vipZeroCommodityListVOS.size() : this.vipZeroCommodityProperties.getBriefNum().intValue();
        if (end > 0) {
            vipZeroCommodityListVOS = vipZeroCommodityListVOS.subList(0, end);
            return vipZeroCommodityListVOS.stream().filter(Objects::nonNull).map(this::convert).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private VipZeroCommodityBriefListVO convert(VipZeroCommodityListVO item) {
        return VipZeroCommodityBriefListVO.builder().commodityTitle(item.getCommodityTitle()).goodsId(item.getGoodsId()).reservePrice(item.getReservePrice()).commodityPrice(item.getCommodityPrice()).imgUrl(item.getImgUrl()).build();
    }

    @Override
    public List<VipZeroCommodityListVO> zeroList(UserIdParam param, boolean isPublicRequest) {
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(Long.valueOf(23L));
        poolParam.setUserId(param.getUserId());
        poolParam.setPublicRequest(isPublicRequest);
        List poolCommodityListItems = this.commodityListServiceProxy.getCommodityList((CommodityListParam)poolParam);
        return poolCommodityListItems.stream().filter(Objects::nonNull).map(this::convert).collect(Collectors.toList());
    }

    private VipZeroCommodityListVO convert(PoolCommodityListItem item) {
        return VipZeroCommodityListVO.builder().commodityTitle(item.getCommodityTitle()).goodsId(item.getGoodsId()).reservePrice(item.getReservePrice()).commodityPrice(item.getCommodityPrice()).imgUrl(item.getImgUrl()).shopName(item.getShopName()).shopType(item.getShopType()).monthSales(item.getMonthSales()).build();
    }

    @Override
    public List<VipZeroPurchaseInfo> vipZeroPurchaseInfos() {
        List result;
        String infosStr = (String)this.redisStringAdapter.get(CommodityRedisKey.VIP_ZERO_COMMODITY_PURCHASE_INFOS, String.class);
        if (StringUtils.isBlank((CharSequence)infosStr) || CollectionUtils.isEmpty((Collection)(result = JSON.parseArray((String)infosStr, VipZeroPurchaseInfo.class)))) {
            List virtualUsers = this.virtualUserFacadeService.listVirtualUser(this.vipZeroCommodityProperties.getPurchaseInfosNum());
            if (!CollectionUtils.isEmpty((Collection)virtualUsers)) {
                List<VipZeroCommodityListVO> vipZeroCommodities = this.zeroList(new UserIdParam(), true);
                result = virtualUsers.stream().map(p -> {
                    VipZeroCommodityListVO vipZeroCommodityBriefListVO = (VipZeroCommodityListVO)vipZeroCommodities.get(RandomUtils.nextInt((int)0, (int)vipZeroCommodities.size()));
                    return VipZeroPurchaseInfo.builder().content(StringUtils.join((Object[])new String[]{CONGRATULATIONS, p.getNickname(), ZERO_PURCHASE, vipZeroCommodityBriefListVO.getCommodityTitle()})).headImg(p.getHeadImg()).build();
                }).collect(Collectors.toList());
                this.redisStringAdapter.set(CommodityRedisKey.VIP_ZERO_COMMODITY_PURCHASE_INFOS, (Object)JSON.toJSONString(result), (long)this.vipZeroCommodityProperties.getPurchaseCacheExpireSecond().intValue());
            } else {
                result = Lists.newArrayList();
            }
        }
        return result;
    }

    @Override
    public List<VipChoicenessCommodityListVO> choicenessList(ChoicenessListParam param) {
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(param.getPoolId());
        poolParam.setUserId(param.getUserId());
        poolParam.setQueryGoldInfo(true);
        List poolCommodityListItems = this.commodityListServiceProxy.getCommodityList((CommodityListParam)poolParam);
        return poolCommodityListItems.stream().filter(Objects::nonNull).map(this::convertToVipChoicenessCommodity).collect(Collectors.toList());
    }

    private VipChoicenessCommodityListVO convertToVipChoicenessCommodity(PoolCommodityListItem item) {
        VipChoicenessCommodityListVO listVO = new VipChoicenessCommodityListVO();
        BeanUtils.copyProperties((Object)item, (Object)listVO);
        listVO.setMonthSalesStr(com.bxm.newidea.component.tools.StringUtils.salesNumTenThousandFormat((Long)listVO.getMonthSales()));
        return listVO;
    }
}

