/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.enums.CommoditySortTypeEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityPoolService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.fossicker.commodity.service.strategy.CommodityQueryService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCommodityQueryService
implements CommodityQueryService {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommodityQueryService.class);
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private CommodityLabelService commodityLabelService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private BlackCommodityService blackCommodityService;
    @Autowired
    private CommodityPoolService commodityPoolService;

    public void assembleGoldInfo(CommoditySearchDTO commoditySearchDTO, Long userId) {
        CommodityGoldInfoDTO goldInfo = this.commodityGoldService.getGoldInfoByCommodityId(commoditySearchDTO.getGoodsId(), userId);
        if (null != goldInfo) {
            commoditySearchDTO.setGoldNum(goldInfo.getBrowseGold());
            commoditySearchDTO.setGoldStatus(goldInfo.getDrawFlag());
        }
        commoditySearchDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, commoditySearchDTO.getGoodsId()));
        commoditySearchDTO.setLabelUrl(this.commodityLabelService.goodsLabel(commoditySearchDTO.getNewbieRight(), commoditySearchDTO.getHandsel(), commoditySearchDTO.getGoodsId()));
    }

    public CommodityPageInfo<CommoditySearchDTO> getCommodityFromRedis(KeyGenerator commodityRedisKey, CommoditySearchParam commoditySearchParam) {
        CommodityPageInfo resultFromRedis = new CommodityPageInfo();
        String commodityByRedis = this.redisStringAdapter.getString(commodityRedisKey);
        if (StringUtils.isBlank((CharSequence)commodityByRedis)) {
            return null;
        }
        List commodityList = JSONArray.parseArray((String)commodityByRedis, CommoditySearchDTO.class);
        commodityList.removeIf(commoditySearchDTO -> this.blackCommodityService.isBlackCommodity(commoditySearchDTO.getGoodsId()));
        commodityList.forEach(commoditySearchDTO -> this.assembleGoldInfo((CommoditySearchDTO)commoditySearchDTO, commoditySearchParam.getUserId()));
        resultFromRedis.setList(commodityList);
        resultFromRedis.setPageNum(commoditySearchParam.getPageNum().intValue());
        resultFromRedis.setPageSize(commoditySearchParam.getPageSize().intValue());
        resultFromRedis.setSearchType("1");
        if (!CollectionUtils.isEmpty((Collection)commodityList)) {
            resultFromRedis.setSearchType(((CommoditySearchDTO)commodityList.get(0)).getSearchType());
        }
        return resultFromRedis;
    }

    public KeyGenerator createCommodityRedisKey(CommoditySearchParam commoditySearchParam, boolean vipFlag) {
        log.info("\u6839\u636e\u5546\u54c1\u540d\u641c\u7d22\u5546\u54c1\u5217\u8868\uff08createCommodityRedisKey\uff09,\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)commoditySearchParam));
        KeyGenerator keyGenerator = CommodityRedisKeyConstants.COMMODITY_QUERY_BY_NAME.copy();
        keyGenerator.appendKey((Object)commoditySearchParam.getCommodityName());
        keyGenerator.appendKey((Object)commoditySearchParam.getPageNum());
        keyGenerator.appendKey((Object)("vip:" + vipFlag));
        if (StringUtils.isNotBlank((CharSequence)commoditySearchParam.getSortType())) {
            keyGenerator.appendKey((Object)("type:" + CommoditySortTypeEnum.getTypeByCode((String)commoditySearchParam.getSortType())));
        }
        if (null != commoditySearchParam.getPriceLowerLimit()) {
            keyGenerator.appendKey((Object)("price_lower:" + commoditySearchParam.getPriceLowerLimit()));
        }
        if (null != commoditySearchParam.getPriceUpperLimit()) {
            keyGenerator.appendKey((Object)("price_upper:" + commoditySearchParam.getPriceUpperLimit()));
        }
        if (null != commoditySearchParam.getCouponFlag()) {
            keyGenerator.appendKey((Object)("coupon_flag:" + commoditySearchParam.getCouponFlag()));
        }
        return keyGenerator;
    }

    public boolean processNewbieCommodity(boolean newbieRightFlag, Double discountPrice, Long goodsId, CommoditySearchDTO commoditySearchDTO) {
        if (!newbieRightFlag) {
            return true;
        }
        if (this.commodityPriceInfoService.isRuleNewbiePrice(discountPrice)) {
            commoditySearchDTO.setCommissionPrice(discountPrice);
            commoditySearchDTO.setCommodityPrice(Double.valueOf(0.0));
            return true;
        }
        log.error("\u8be5\u65b0\u4eba\u5546\u54c1:{}\u4ef7\u683c\u4e0d\u7b26\u5408\u5546\u54c1\u4ef7\u683c\u8981\u6c42,\u81ea\u52a8\u4e0b\u67b6", (Object)goodsId);
        this.commodityPoolService.setNewbieInvalidStatus(goodsId);
        return false;
    }
}

