/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.dto.CommodityCommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.enums.CommoditySortTypeEnum;
import com.bxm.fossicker.commodity.common.enums.LocalCommodityStatusEnum;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.fossicker.commodity.service.strategy.AbstractCommodityQueryService;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.taobao.api.request.TbkDgMaterialOptionalRequest;
import com.taobao.api.response.TbkDgMaterialOptionalResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommodityQueryByTbImpl
extends AbstractCommodityQueryService {
    private static final Logger log = LoggerFactory.getLogger(CommodityQueryByTbImpl.class);
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private TbCommodityService tbCommodityService;
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;
    @Autowired
    private BlackCommodityService blackCommodityService;
    @Autowired
    CommodityInfoSourceProxyService commodityInfoSourceService;
    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    public CommodityPageInfo<CommoditySearchDTO> queryCommodityByName(CommoditySearchParam commoditySearchParam) {
        Long userId;
        boolean vipFlag;
        KeyGenerator commodityRedisKey;
        CommodityPageInfo<CommoditySearchDTO> commodityFromRedis;
        CommodityPageInfo resultPageInfo = new CommodityPageInfo();
        String searchName = commoditySearchParam.getCommodityName();
        if (StringUtils.isNotBlank((CharSequence)searchName) && searchName.startsWith("http")) {
            resultPageInfo.setIsLastPage(true);
        }
        if (Objects.nonNull(commodityFromRedis = this.getCommodityFromRedis(commodityRedisKey = this.createCommodityRedisKey(commoditySearchParam, vipFlag = this.vipFacadeService.isVip(userId = commoditySearchParam.getUserId())), commoditySearchParam)) && !CollectionUtils.isEmpty((Collection)commodityFromRedis.getList())) {
            return commodityFromRedis;
        }
        TbkDgMaterialOptionalRequest req = this.assembleQueryParam(commoditySearchParam);
        TbkDgMaterialOptionalResponse rsp = this.tbCommodityService.getCommodityListByName(req);
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getResultList())) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
            return resultPageInfo;
        }
        List<CommoditySearchDTO> commoditySearchList = this.convertResultList(rsp.getResultList(), userId, vipFlag);
        this.saveRedis(commodityRedisKey, commoditySearchList);
        resultPageInfo.setList(commoditySearchList);
        resultPageInfo.setPageNum(commoditySearchParam.getPageNum().intValue());
        resultPageInfo.setPageSize(commoditySearchParam.getPageSize().intValue());
        return resultPageInfo;
    }

    @Override
    public CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam) {
        return null;
    }

    private void saveRedis(KeyGenerator commodityRedisKey, List<CommoditySearchDTO> commodityList) {
        this.redisStringAdapter.set(commodityRedisKey, (Object)JSON.toJSONString(commodityList), 3600L);
    }

    private TbkDgMaterialOptionalRequest assembleQueryParam(CommoditySearchParam commoditySearchParam) {
        TbkDgMaterialOptionalRequest req = new TbkDgMaterialOptionalRequest();
        req.setPageSize(Long.valueOf(commoditySearchParam.getPageSize().intValue()));
        req.setPageNo(Long.valueOf(commoditySearchParam.getPageNum().intValue()));
        req.setAdzoneId(Long.valueOf(this.commodityInfoProperties.getTbCommodityZoneId()));
        req.setQ(commoditySearchParam.getCommodityName());
        if (StringUtils.isNotBlank((CharSequence)commoditySearchParam.getSortType())) {
            req.setSort(CommoditySortTypeEnum.getTypeByCode((String)commoditySearchParam.getSortType()));
        }
        if (null != commoditySearchParam.getPriceLowerLimit()) {
            req.setStartPrice(commoditySearchParam.getPriceLowerLimit());
        }
        if (null != commoditySearchParam.getPriceUpperLimit()) {
            req.setEndPrice(commoditySearchParam.getPriceUpperLimit());
        }
        if (null != commoditySearchParam.getCouponFlag() && 1 == commoditySearchParam.getCouponFlag()) {
            req.setHasCoupon(Boolean.valueOf(true));
        }
        return req;
    }

    private List<CommoditySearchDTO> convertResultList(List<TbkDgMaterialOptionalResponse.MapData> tbkDataList, Long userId, boolean vipFlag) {
        ArrayList<CommoditySearchDTO> resultList = new ArrayList<CommoditySearchDTO>();
        tbkDataList.forEach(tbkData -> {
            Long goodsId = tbkData.getItemId();
            if (this.blackCommodityService.isBlackCommodity(goodsId)) {
                return;
            }
            float handsel = Float.parseFloat(tbkData.getPresaleDeposit() == null ? "0" : tbkData.getPresaleDeposit());
            GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
            detailParam.setQueryCouponInfo(false);
            detailParam.setCommodityId(goodsId);
            CommodityInfoDTO localCommodity = this.commodityInfoSourceService.getLocalCommodity(detailParam);
            CommoditySearchDTO commoditySearchDTO = null != localCommodity && LocalCommodityStatusEnum.Valid.getStatus() == localCommodity.getStatus().byteValue() ? this.convertLocalCommodity(localCommodity, goodsId, userId, vipFlag) : this.convertTbCommodity((TbkDgMaterialOptionalResponse.MapData)tbkData, goodsId, userId, vipFlag);
            if (null == commoditySearchDTO) {
                return;
            }
            commoditySearchDTO.setHandsel(handsel);
            this.assembleGoldInfo(commoditySearchDTO, userId);
            resultList.add(commoditySearchDTO);
        });
        return resultList;
    }

    private boolean isZeroCommission(Double commissionPrice) {
        return new Double("0").equals(commissionPrice);
    }

    private CommoditySearchDTO convertLocalCommodity(CommodityInfoDTO localCommodity, Long goodsId, Long userId, boolean vipFlag) {
        CommoditySearchDTO commoditySearchDTO = CommoditySearchDTO.builder().reservePrice(localCommodity.getReservePrice()).commodityTitle(localCommodity.getCommodityTitle()).goodsId(localCommodity.getGoodsId()).imgUrl(localCommodity.getMainPic()).monthSales(Long.valueOf(null == localCommodity.getSalesNum() ? 0L : localCommodity.getSalesNum().longValue())).shopName(localCommodity.getShopName()).shopType(localCommodity.getShopType()).sourceType(Integer.valueOf(1)).build();
        PlatformCommissionRateInfo platformCommissionDTO = this.commodityPriceInfoService.getPlatformCommissionRateInfo(goodsId);
        if (null == platformCommissionDTO) {
            log.error("\u67e5\u8be2\u5230\u7684\u4f63\u91d1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8be5\u5546\u54c1\u4e0d\u505a\u5c55\u793a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        boolean specialCommissionFlag = platformCommissionDTO.isSpecialCommissionFlag();
        commoditySearchDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, goodsId));
        Double platformCommissionPrice = localCommodity.getPlatformCommissionPrice();
        Double commissionPrice = CommodityCalUtils.calCommissionForPlatformCommissionWithVip((PlatformCommissionRateInfo)platformCommissionDTO, (Double)platformCommissionPrice, (boolean)vipFlag);
        Double vipCommissionPrice = CommodityCalUtils.calVipCommission((Double)platformCommissionPrice, (Double)platformCommissionDTO.getVipCommissionRate(), (boolean)vipFlag, (boolean)specialCommissionFlag, (Double)commissionPrice);
        if (this.isZeroCommission(commissionPrice)) {
            log.error("\u5546\u54c1\u4f63\u91d1\u4e3a0\uff0c\u8be5\u5546\u54c1\u4e0d\u505a\u5c55\u793a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        commoditySearchDTO.setCouponPrice(localCommodity.getCouponPrice());
        commoditySearchDTO.setCommissionPrice(commissionPrice);
        commoditySearchDTO.setVipCommissionPrice(vipCommissionPrice);
        commoditySearchDTO.setSpecialCommissionFlag(specialCommissionFlag);
        commoditySearchDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)localCommodity.getReservePrice(), (Double)localCommodity.getCouponPrice(), (Double)commissionPrice));
        return commoditySearchDTO;
    }

    private CommoditySearchDTO convertTbCommodity(TbkDgMaterialOptionalResponse.MapData tbkData, Long goodsId, Long userId, boolean vipFlag) {
        Double reservePrice = Double.valueOf(tbkData.getZkFinalPrice());
        CommoditySearchDTO commoditySearchDTO = CommoditySearchDTO.builder().commodityPrice(Double.valueOf(tbkData.getZkFinalPrice())).reservePrice(reservePrice).commodityTitle(tbkData.getTitle()).goodsId(goodsId).imgUrl(tbkData.getPictUrl()).monthSales(tbkData.getVolume()).shopName(tbkData.getShopTitle()).shopType(Integer.valueOf(null == tbkData.getUserType() ? 0 : tbkData.getUserType().intValue())).sourceType(Integer.valueOf(2)).build();
        CommodityCommissionAndCoupon commissionInfoDTO = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(goodsId, userId);
        if (null == commissionInfoDTO) {
            log.error("\u67e5\u8be2\u5230\u7684\u4f63\u91d1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8be5\u5546\u54c1\u4e0d\u505a\u5c55\u793a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        commoditySearchDTO.setNewbieRight(this.commodityPriceInfoService.isNewbieRight(userId, goodsId));
        Double commissionPrice = CommodityCalUtils.calCommissionWithVip((CommodityCommissionAndCoupon)commissionInfoDTO, (Double)reservePrice, (boolean)vipFlag);
        Double couponPrice = commissionInfoDTO.getCouponPrice();
        Double discountPrice = CommodityCalUtils.calDiscountPrice((Double)commoditySearchDTO.getReservePrice(), (Double)commissionInfoDTO.getCouponPrice());
        if (this.isZeroCommission(commissionPrice)) {
            log.error("\u5546\u54c1\u4f63\u91d1\u4e3a0\uff0c\u8be5\u5546\u54c1\u4e0d\u505a\u5c55\u793a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        commoditySearchDTO.setCouponPrice(couponPrice);
        commoditySearchDTO.setCommissionPrice(commissionPrice);
        commoditySearchDTO.setSpecialCommissionFlag(commissionInfoDTO.isSpecialCommissionFlag());
        commoditySearchDTO.setVipCommissionPrice(CommodityCalUtils.calVipCommission((Double)discountPrice, (Double)commissionInfoDTO.getCommissionRateByThird(), (Double)commissionInfoDTO.getVipCommissionRate()));
        commoditySearchDTO.setCommodityPrice(CommodityCalUtils.calPriceWithSubtractingCouponAndCommission((Double)reservePrice, (Double)couponPrice, (Double)commissionPrice));
        return commoditySearchDTO;
    }
}

