/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.utils.CommodityNumberUtils;
import com.bxm.fossicker.commodity.convert.CommodityDetailToSearchConvert;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchResultDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.param.WySearchCommodityInfoParam;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.fossicker.commodity.service.strategy.AbstractCommodityQueryService;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CommodityQueryByWyImpl
extends AbstractCommodityQueryService {
    private static final Logger log = LoggerFactory.getLogger(CommodityQueryByWyImpl.class);
    private final WyCommodityService wyCommodityService;
    private final VipFacadeService vipFacadeService;
    private final RedisStringAdapter redisStringAdapter;
    private final CommodityInfoService commodityInfoService;

    public CommodityQueryByWyImpl(WyCommodityService wyCommodityService, VipFacadeService vipFacadeService, RedisStringAdapter redisStringAdapter, CommodityInfoService commodityInfoService) {
        this.wyCommodityService = wyCommodityService;
        this.vipFacadeService = vipFacadeService;
        this.redisStringAdapter = redisStringAdapter;
        this.commodityInfoService = commodityInfoService;
    }

    @Override
    public CommodityPageInfo<CommoditySearchDTO> queryCommodityByName(CommoditySearchParam commoditySearchParam) {
        CommodityPageInfo<CommoditySearchDTO> commodityFromRedis;
        log.info("\u6839\u636e\u5546\u54c1\u540d\u641c\u7d22\u5546\u54c1\u5217\u8868\uff08queryCommodityByName\uff09,\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)commoditySearchParam));
        CommodityPageInfo resultPage = new CommodityPageInfo();
        resultPage.setPageSize(commoditySearchParam.getPageSize().intValue());
        resultPage.setPageNum(commoditySearchParam.getPageNum().intValue());
        Long userId = commoditySearchParam.getUserId();
        boolean vipFlag = this.vipFacadeService.isVip(userId);
        KeyGenerator commodityRedisKey = this.createCommodityRedisKey(commoditySearchParam, vipFlag);
        if (log.isDebugEnabled()) {
            log.debug("\u3010\u552f\u6613\u3011\u641c\u7d22\u5546\u54c1\uff0c\u5f97\u5230\u7f13\u5b58key\u503c:[{}]", (Object)commodityRedisKey.gen());
        }
        if (Objects.nonNull(commodityFromRedis = this.getCommodityFromRedis(commodityRedisKey, commoditySearchParam)) && !CollectionUtils.isEmpty((Collection)commodityFromRedis.getList())) {
            return commodityFromRedis;
        }
        WySearchResultDTO wySearchResultDTO = this.wyCommodityService.searchCommodity(commoditySearchParam);
        if (Objects.isNull(wySearchResultDTO) || CollectionUtils.isEmpty((Collection)wySearchResultDTO.getCommodityList())) {
            log.error("\u641c\u7d22\u5546\u54c1\u7ed3\u679c\u4e3a\u7a7a,\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)commoditySearchParam));
            return resultPage;
        }
        List resultList = wySearchResultDTO.getCommodityList().stream().map(wyInfo -> this.getDetail((WySearchCommodityInfoDTO)wyInfo, userId, wySearchResultDTO.getSearchType())).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(resultList)) {
            this.redisStringAdapter.set(commodityRedisKey, (Object)JSON.toJSONString(resultList), 1800L);
        }
        resultPage.setList(resultList);
        resultPage.setSearchType(wySearchResultDTO.getSearchType());
        return resultPage;
    }

    @Override
    public CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam) {
        CommoditySearchParam commoditySearchParam = new CommoditySearchParam();
        commoditySearchParam.setCommodityName(clipboardQueryParam.getCommodityName());
        commoditySearchParam.setPageSize(Integer.valueOf(1));
        WySearchResultDTO wySearchResultDTO = this.wyCommodityService.searchCommodity(commoditySearchParam);
        if (Objects.isNull(wySearchResultDTO)) {
            if (log.isDebugEnabled()) {
                log.debug("\u6839\u636e\u526a\u5207\u677f\uff0c\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u7684\u5546\u54c1\u4fe1\u606f,\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)commoditySearchParam));
            }
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)wySearchResultDTO.getCommodityList())) {
            return CommoditySearchDTO.builder().remark(wySearchResultDTO.getMsg()).searchType(wySearchResultDTO.getSearchType()).build();
        }
        CommoditySearchDTO searchDTO = this.getDetail((WySearchCommodityInfoDTO)wySearchResultDTO.getCommodityList().get(0), clipboardQueryParam.getUserId(), wySearchResultDTO.getSearchType());
        if (searchDTO != null && CommodityNumberUtils.isNullOrZero((Double)searchDTO.getCommissionPrice())) {
            log.warn("\u5546\u54c1\u4f63\u91d1\u4e3a0\uff0c\u8be5\u5546\u54c1\u4e0d\u505a\u5c55\u793a,\u67e5\u8be2\u53c2\u6570\uff1a{}\uff0c\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)clipboardQueryParam, (Object)searchDTO);
            return null;
        }
        return searchDTO;
    }

    private CommoditySearchDTO getDetail(WySearchCommodityInfoDTO wySearchCommodityInfoDTO, Long userId, String searchType) {
        CommoditySearchDTO searchDTO;
        if (Objects.isNull(wySearchCommodityInfoDTO)) {
            return null;
        }
        Long goodsId = Objects.isNull(wySearchCommodityInfoDTO.getItemId()) ? Long.valueOf(wySearchCommodityInfoDTO.getNumIid()) : wySearchCommodityInfoDTO.getItemId();
        CommodityDetailQueryParam detailParam = CommodityDetailQueryParam.builder().goodsId(goodsId).userId(userId).queryLocalOnly(true).doNotPrintWarnLog(true).queryBrowerAward(true).build();
        CommodityDetailDTO detail = this.commodityInfoService.getCommodityDetail(detailParam);
        if (Objects.isNull(detail) || detail.getValidStatus() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("\u5546\u54c1\u8be6\u60c5\u672c\u5730\u68c0\u7d22\u5931\u8d25\uff0c\u4f7f\u7528\u7ef4\u6613\u67e5\u8be2\u7ed3\u679c\u8fd4\u56de\u7ed3\u679c\u8fdb\u884c\u9002\u914d\uff0cwyCommodity\uff1a{}\uff0cuserId\uff1a{},searchType:{}", new Object[]{wySearchCommodityInfoDTO, userId, searchType});
            }
            detailParam.setWySearchCommodityInfoParam(WySearchCommodityInfoParam.builder().wyInfo(wySearchCommodityInfoDTO).convertType(Byte.valueOf((byte)1)).build());
            detail = this.commodityInfoService.getCommodityDetail(detailParam);
            if (Objects.isNull(detail)) {
                return null;
            }
        }
        if (Objects.nonNull(searchDTO = CommodityDetailToSearchConvert.convert(detail))) {
            searchDTO.setSearchType(StringUtils.isEmpty((Object)searchType) ? "2" : searchType);
        }
        return searchDTO;
    }
}

