/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.fossicker.commodity.service.strategy.PriceByThirdStrategyService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceStrategyByTbService")
public class PriceStrategyByTbServiceImpl
implements PriceByThirdStrategyService {
    private static final Logger log = LoggerFactory.getLogger(PriceStrategyByTbServiceImpl.class);
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private TbCommodityService tbCommodityService;

    @Override
    public CommissionAndCoupon getCommissionAndCoupon(Long goodsId) {
        return null;
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        if (null == goodsId) {
            log.warn("\u83b7\u53d6\u5546\u54c1\u4ef7\u683c,\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        KeyGenerator priceInfoKey = CommodityRedisKeyConstants.COMMODITY_PRICE.copy().setKey(goodsId.toString());
        String priceInfoByRedis = this.redisStringAdapter.getString(priceInfoKey);
        if (StringUtils.isNotBlank((String)priceInfoByRedis)) {
            return Double.valueOf(priceInfoByRedis);
        }
        CommodityDetailDTO commodityDetailDTO = this.tbCommodityService.getCommodityDetail(goodsId);
        if (null == commodityDetailDTO) {
            log.warn("\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u65e0\u6cd5\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        Double reservePriceFromTb = commodityDetailDTO.getReservePrice();
        if (null != reservePriceFromTb) {
            this.redisStringAdapter.set(priceInfoKey, (Object)reservePriceFromTb.toString(), 3600L);
        }
        return reservePriceFromTb;
    }
}

