/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.model.dto.WyCommissionDataDTO;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.fossicker.commodity.service.strategy.PriceByThirdStrategyService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commissionStrategyByWyService")
public class PriceStrategyByWyServiceImpl
implements PriceByThirdStrategyService {
    private static final Logger log = LoggerFactory.getLogger(PriceStrategyByWyServiceImpl.class);
    @Autowired
    private WyCommodityService wyCommodityService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public CommissionAndCoupon getCommissionAndCoupon(Long goodsId) {
        KeyGenerator commissionKey = CommodityRedisKeyConstants.COMMODITY_COMMISSION.copy().setKey(goodsId.toString());
        CommissionAndCoupon commissionInfoByRedis = (CommissionAndCoupon)this.redisStringAdapter.get(commissionKey, CommissionAndCoupon.class);
        if (null != commissionInfoByRedis) {
            return commissionInfoByRedis;
        }
        WyCommissionDataDTO commissionInfo = this.wyCommodityService.getCommissionInfo(goodsId);
        if (Objects.isNull(commissionInfo)) {
            return null;
        }
        CommissionAndCoupon commissionInfoDTO = this.convert(commissionInfo);
        this.redisStringAdapter.set(commissionKey, (Object)commissionInfoDTO, 3600L);
        return commissionInfoDTO;
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        return null;
    }

    private CommissionAndCoupon convert(WyCommissionDataDTO commissionInfo) {
        Long goodsId = StringUtils.isNotBlank((CharSequence)commissionInfo.getGoodsId()) ? Long.valueOf(Long.parseLong(commissionInfo.getGoodsId())) : null;
        Double commissionRate = null;
        if (StringUtils.isNotBlank((CharSequence)commissionInfo.getCommissionRate())) {
            commissionRate = new BigDecimal(commissionInfo.getCommissionRate()).divide(new BigDecimal("100")).doubleValue();
        }
        return CommissionAndCoupon.builder().goodsId(goodsId).couponPrice(CommodityCalUtils.getCouponPriceByRegex((String)commissionInfo.getCouponInfo())).commissionRateByThird(commissionRate).couponUrl(commissionInfo.getCouponUrl()).build();
    }
}

