/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.vo;

import com.bxm.fossicker.vo.PushPayloadInfo;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.http.HttpStatus;

@ApiModel(description="\u6807\u51c6\u7684Json\u54cd\u5e94\u683c\u5f0f\u6570\u636e")
public class ResponseJson<T> {
    @ApiModelProperty(required=true, value="\u64cd\u4f5c\u7ed3\u679c\u7f16\u7801", example="200/400/401/403/404/500")
    private int code;
    @ApiModelProperty(value="\u8bf7\u6c42\u7684\u8fd4\u56de\u6d88\u606f\uff0ccode\u4e3a200\u53ef\u80fd\u4e3a\u7a7a\uff0c\u5176\u4ed6code\u5747\u6709\u503c", example="\u64cd\u4f5c\u5b8c\u6210/\u64cd\u4f5c\u6210\u529f/\u4f59\u989d\u4e0d\u8db3...")
    private String errorMsg = "";
    @ApiModelProperty(value="\u8bf7\u6c42\u7684\u8fd4\u56de\u6570\u636e\uff0c\u6839\u636e\u8bf7\u6c42\u4e0d\u540c\u6709\u5177\u4f53\u7684\u8fd4\u56de\u5b9e\u4f53")
    private T result;
    @ApiModelProperty(value="\u5f53\u524d\u8bf7\u6c42\u7528\u6237\u7684\u6700\u65b0\u76f8\u5173\u4e8b\u4ef6", hidden=true)
    private Collection<PushPayloadInfo> events;

    private ResponseJson() {
        this.code = HttpStatus.OK.value();
    }

    private ResponseJson(HttpStatus code) {
        this.code = code.value();
    }

    private ResponseJson(HttpStatus code, String errorMsg) {
        this.code = code.value();
        this.errorMsg = errorMsg;
    }

    private ResponseJson(Message message) {
        this.code = message.isSuccess() ? HttpStatus.OK.value() : HttpStatus.BAD_REQUEST.value();
        this.errorMsg = message.getLashMessaage();
    }

    private ResponseJson(HttpStatus code, String errorMsg, T result) {
        this.code = code.value();
        this.errorMsg = errorMsg;
        this.result = result;
    }

    private ResponseJson(ResponseJson<T> source) {
        this.code = source.code;
        this.errorMsg = source.errorMsg;
        this.result = source.result;
    }

    public static <T> ResponseJson<T> build(Message message) {
        return new ResponseJson<T>(message);
    }

    public static <T> ResponseJson<T> ok(T result) {
        return new ResponseJson<T>().body(result);
    }

    public static <T> ResponseJson<T> ok() {
        return new ResponseJson<T>();
    }

    public static <T> ResponseJson<T> badReqeuset() {
        return new ResponseJson<T>(HttpStatus.BAD_REQUEST);
    }

    public static <T> ResponseJson<T> badReqeuset(String errorMsg) {
        return new ResponseJson<T>(HttpStatus.BAD_REQUEST, errorMsg);
    }

    public static <T> ResponseJson<T> serverError() {
        return new ResponseJson<T>(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static <T> ResponseJson<T> serverError(String errorMsg) {
        return new ResponseJson<T>(HttpStatus.INTERNAL_SERVER_ERROR, errorMsg);
    }

    public static <T> ResponseJson<T> unauthorized() {
        return new ResponseJson<T>(HttpStatus.UNAUTHORIZED);
    }

    public static <T> ResponseJson<T> unauthorized(String errorMsg) {
        return new ResponseJson<T>(HttpStatus.UNAUTHORIZED, errorMsg);
    }

    public boolean success() {
        return this.code == HttpStatus.OK.value();
    }

    public int getCode() {
        return this.code;
    }

    public ResponseJson<T> code(int code) {
        this.code = code;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public ResponseJson<T> errorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public T getResult() {
        return this.result;
    }

    public ResponseJson<T> body(T result) {
        this.result = result;
        return this;
    }

    public Collection<PushPayloadInfo> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<PushPayloadInfo> events) {
        this.events = events;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

