package com.bxm.fossicker.enums;

import com.bxm.newidea.component.tools.NumberUtils;


/**
 * 推送消息
 */
public enum PushMessageEnum {

    SYSTEM_MSG(0, "系统公告", Boolean.FALSE),
    ORDINARY_MSG(1, "提示消息", Boolean.FALSE),
    TOBE_VIP_MSG(2,"成为会员消息",Boolean.TRUE),
    INVALID_VIP_MSG(3,"会员失效消息",Boolean.TRUE),

    INDIANAPOLIS_DRAW_MSG(4,"夺宝开奖推送消息(公众号)",Boolean.TRUE);

    private int type;

    private String desc;

    //是否静默推送（无通知栏）
    private Boolean silence;

    PushMessageEnum(int type, String desc, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getDesc();
            }
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return getMessageDescByType(NumberUtils.parseToInt(type));
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getSilence();
            }
        }
        return Boolean.FALSE;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Boolean getSilence() {
        return silence;
    }

    public void setSilence(Boolean silence) {
        this.silence = silence;
    }
}
