package com.bxm.fossicker.enums;

/**
 * 任务枚举
 *
 * @Author XinZhao
 **/

public enum TaskEnum {
    /**
     * 新手任务
     */
    INPUT_INVITE("输入邀请码", 0),
    VIEW_GOODS("逛商品并切换浏览", 0),
    VIEW_VIDEO("观看省钱视频", 0),
    SEARCH_TITLE("搜索淘宝标题", 0),
    CART_COUPON("首次购物车查券", 0),
    AUTH_TAOBAO("授权淘宝", 0),
    FIRST_SHOP("完成首次购物", 0),
    BIND_WECHAT("绑定微信", 0),
    FINISH_PERSONAL_INFO("完善我的标签",0),

    /**
     * 日常任务
     */
    NEW_USER_RED_PACKET("新人礼包", 0),
    INVITE_FRIEND("邀请好友赚现金", 1),
    INVITE_KINSFOLK("邀请亲友赚现金", 1),
    WATCH_VIDEO("看视频3次", 1),
    HAMMER_GOLD_EGG("幸运砸金蛋", 1),
    CASH_RED_PACKET("现金红包免费拿", 1),
    FRIENDS_FIRST_LOGIN("好友初次登陆", 99),
    FINISH_VIEW("完成浏览商品10S", 99),
    INVITED_VIEW("被邀请人浏览商品", 99),
    SHARE_VIEW("分享商品被浏览", 99);

    private String task;

    /**
     * 任务类型 0.新手任务,1.日常任务 99 页面中任务
     */
    private Integer type;

    TaskEnum(String task, Integer type) {
        this.task = task;
        this.type = type;
    }

    public String getTask() {
        return task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
