/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.integration.service;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.integration.dto.CommodityCouponInfoDTO;
import com.bxm.fossicker.integration.facade.CommoditySyncFeignService;
import com.bxm.fossicker.integration.param.GetCouponInfoParam;
import com.bxm.fossicker.vo.ResponseJson;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommoditySyncIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(CommoditySyncIntegrationService.class);
    @Autowired
    private CommoditySyncFeignService commoditySyncFeignService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    public CommodityCouponInfoDTO loadCouponInfoFromCache(GetCouponInfoParam param) {
        CommodityCouponInfoDTO couponInfoDTO;
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u9ad8\u4f63\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param));
        }
        if (Objects.isNull(couponInfoDTO = (CommodityCouponInfoDTO)this.redisHashMapAdapter.get(CommonCommodityRedisKey.COMMODITY_COUPON_INFO, param.getGoodsId(), CommodityCouponInfoDTO.class)) || !Objects.equals(couponInfoDTO.getSource(), param.getSourceFrom()) || Objects.isNull(couponInfoDTO.getCacheExpireTime()) || couponInfoDTO.getCacheExpireTime() < System.currentTimeMillis()) {
            try {
                ResponseJson<CommodityCouponInfoDTO> couponInfo = this.commoditySyncFeignService.getCouponInfo(param.getGoodsId(), param.getSourceFrom());
                if (Objects.nonNull(couponInfo) && couponInfo.success()) {
                    return (CommodityCouponInfoDTO)couponInfo.getResult();
                }
                log.warn("\u8c03\u7528fossicker-sync\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u4fe1\u606f\u5931\u8d25\uff0cgoodsId: {}", (Object)param.getGoodsId());
                couponInfoDTO = null;
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u540c\u6b65\u6a21\u5757\u5931\u8d25", (Throwable)e);
            }
        }
        return couponInfoDTO;
    }
}

