/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.integration.service;

import com.bxm.fossicker.integration.dto.CommodityDetailIntegrationDTO;
import com.bxm.fossicker.integration.dto.CommodityImageIntegrationDTO;
import com.bxm.fossicker.integration.facade.CrawlerFeignService;
import com.bxm.fossicker.vo.ResponseJson;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrawlerIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(CrawlerIntegrationService.class);
    private final CrawlerFeignService crawlerFeignService;

    @Autowired
    public CrawlerIntegrationService(CrawlerFeignService crawlerFeignService) {
        this.crawlerFeignService = crawlerFeignService;
    }

    public CommodityDetailIntegrationDTO getCommodityDetail(Long goodsId) {
        ResponseJson<CommodityDetailIntegrationDTO> responseJson = this.crawlerFeignService.getGoodsInfo(goodsId);
        if (responseJson != null && responseJson.success() && responseJson.getResult() != null) {
            return (CommodityDetailIntegrationDTO)responseJson.getResult();
        }
        return null;
    }

    public List<CommodityImageIntegrationDTO> getDetailList(Long goodsId) {
        ResponseJson<List<CommodityImageIntegrationDTO>> result = this.crawlerFeignService.getGoodsDetail(goodsId);
        if (Objects.nonNull(result) && result.success()) {
            return (List)result.getResult();
        }
        log.error("\u67e5\u8be2\u5546\u54c1\u56fe\u6587\u8be6\u60c5\u5931\u8d25,\u5546\u54c1id:{}", (Object)goodsId);
        return null;
    }
}

