package com.bxm.fossicker.order.domain;

import com.bxm.fossicker.order.model.entity.OrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.UserOrderExtendInfoBean;
import com.bxm.fossicker.order.model.param.UserOwnOrderWithExtendInfoParam;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface OrderExtendInfoExtendMapper extends OrderExtendInfoMapper {

    /**
     * 查询用户订单信息（随拓展信息）
     * @param param userId
     * @return 用户订单信息（随拓展信息）
     */
    List<UserOrderExtendInfoBean> selectUserOwnOrderWithExtendInfo(UserOwnOrderWithExtendInfoParam param);


    /**
     * 查询用户的0元购助力中的订单数量
     * @param userId userId
     * @return 用户的0元购助力中的订单数量
     */
    Long selectUserOwnVipZeroOrderNotHelpExpiredCount(Long userId);

    /**
     * 根据订单id 获取拓展信息
     * @param orderId  订单id
     * @return 拓展信息
     */
    OrderExtendInfoBean getByOrderId(Long orderId);

}