package com.bxm.fossicker.order.domain;

import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.vo.OrderInfoForQuartz;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/7/23 11:05
 */
@Mapper
public interface OrderInfoMapper {
    /**
     * 更改订单状态
     * @return
     */
    int updateOrderStatus(@Param("orderSn") String orderSn,@Param("orderStatus") int orderStatus);

    /**
     * 更改来源订单状态
     * @param orderSn
     * @param orderStatus
     * @return
     */
    int updateSourceOrderStatus(@Param("orderSn") String orderSn,@Param("orderStatus") int orderStatus);

    /**
     * 只更改order_info 表order_status 字段
     * @param orderSn
     * @param orderStatus
     * @return
     */
    int updateStatusForOrderInfo(@Param("orderSn") String orderSn,@Param("sourceOrderStatus") int sourceOrderStatus,
                                      @Param
            ("orderStatus") int orderStatus);

    /**
     * 获取上月订单来源（淘宝）状态为“已结算”数据信息
     * @return
     */
    List<OrderInfoForQuartz> getLastMonthInfo();

    /**
     * 获取来源（淘宝）状态为“已付款”，“已成功” 订单最后一条数据信息
     * @return
     */
    OrderInfoBean getLastOrderInfo();

    /**
     * 获取来源（淘宝）状态为“已付款”，“已成功” 订单第一条条数据信息
     * @return
     */
    OrderInfoBean getStartOrderInfo();

    List<OrderInfoBean> getOrderInfoByStatus(@Param("type") int type);

    /**
     * 根据订单id获取订单信息
     * @param orderSn 订单id
     * @return 订单信息
     */
    OrderInfoBean getOrderInfoByOrderId(String orderSn);

    /**
     * 根据id 查找订单信息
     * @param id id
     * @return 订单信息
     */
    OrderInfoBean getOrderInfoByPrimaryKey(Long id);

    /**
     * 根据用户信息和商品id确认订单
     * @param relationId
     * @param goodsId
     * @return
     */
    List<OrderInfoBean> getOrderInfoByUserIdAndGoodsId(@Param("relationId") String relationId,@Param("goodsId") String[]
            goodsId);

    Integer insertOrderList(@Param("orderInfoList") List<OrderInfoBean> orderInfoList);

    /**
     * 插入单条订单信息
     * @param orderInfoBean 订单信息实体类
     * @return 插入结果
     */
    Integer insertOrderInfo(OrderInfoBean orderInfoBean);

    /**
     * 获取订单list
     * @param relationId 渠道id
     * @return 订单list
     */
    List<OrderInfoBean> getOrderSnList(String relationId);


    int updateByPrimaryKeySelective(OrderInfoBean orderInfoBean);
}
