package com.bxm.fossicker.order.domain;

import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;
import com.bxm.fossicker.order.model.param.TakeOutOrderParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface OrderInfoTakeOutExtendMapper extends OrderInfoTakeOutMapper {

    /**
     * 根据订单号查询外卖订单
     * @param orderSn
     * @return 外卖订单
     */
    OrderInfoTakeOut selectByOrderSn(String orderSn);

    /**
     * 查询指定时间之前的，指定源的指定状态的外卖订单
     * 暂时未分页
     * @param source 来源
     * @param timeLimit 截止时间
     * @param status 状态
     * @return 外卖订单列表
     */
    List<OrderInfoTakeOut> selectBySourceAndTimeLimit(@Param("source") String source,
                                                      @Param("timeLimit") Date timeLimit, @Param("status") Byte status);


    /**
     * 根据查询参数查询外卖订单
     * @param param 查询参数
     * @return 外卖订单
     */
    List<OrderInfoTakeOut> listByParam(TakeOutOrderParam param);
}
