package com.bxm.fossicker.order.domain;

import com.bxm.fossicker.order.model.entity.OrderProfitBean;
import com.bxm.fossicker.order.model.entity.UserOrderInfoBean;
import com.bxm.fossicker.order.model.param.OrderProfitParam;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.model.vo.OrderInfoForQuartz;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/7/23 11:05
 */
@Mapper
public interface OrderProfitMapper {

    /**
     * 根据用户id查询对应的订单收益记录
     * @param param
     * @return
     */
    List<UserOrderInfoBean> selectByUserId(UserOrderParam param);


    /**
     * 根据用户id查询对应的订单收益记录分页使用
     * @param param
     * @return
     */
    List<UserOrderInfoBean> selectByUserIdPageInfo(UserOrderParam param);

    /**
     * 插入记录
     * @param orderProfitBean
     * @return
     */
    Integer insertSelective(OrderProfitBean orderProfitBean);

    /**
     * 根据订单号获取返利信息
     * @param orderSn
     * @return
     */
    List<OrderInfoForQuartz> getProfitInfo(@Param("orderSn") String orderSn);

    /**
     * 获取单个用户，多笔订单的总收入信息
     * @param userId
     * @param orders
     * @return
     */
    OrderProfitParam getOneUserOrdersTotal(@Param("userId")Long userId,@Param("orders") List<String> orders);

    /**
     * 根据用户id 和 订单号查询
     * @param orderSn orderSn
     * @param userId userId
     * @return
     */
    OrderProfitBean getProfitInfoByUserIdAndOrderSn(@Param("orderSn") String orderSn, @Param("userId")Long userId);

    /**
     * 根据订单号获取对应的profits
     * @param orderId 订单id
     * @return profits
     */
    List<OrderProfitBean> listByOrderId(@Param("orderId") Long orderId);


    int updateByPrimaryKeySelective(OrderProfitBean orderProfitBean);
}
