/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.config;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.bxm.fossicker.thirdpart.facade.config.AlipayProperties;
import com.bxm.fossicker.thirdparty.service.AliAppletService;
import com.bxm.fossicker.thirdparty.service.impl.AliAppletServiceImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={AlipayProperties.class})
public class AliPayConfiguration {
    private AlipayProperties alipayProperties;

    public AliPayConfiguration(AlipayProperties alipayProperties) {
        this.alipayProperties = alipayProperties;
    }

    @Bean(value={"alipayClient"})
    @Primary
    public AlipayClient alipayClient() {
        return new DefaultAlipayClient(this.alipayProperties.getGateWayUrl(), this.alipayProperties.getAppId(), this.alipayProperties.getRsaPrivateKey(), this.alipayProperties.getFormat(), this.alipayProperties.getCharset(), this.alipayProperties.getAlipayPublicKey(), this.alipayProperties.getSigntype());
    }

    private AlipayClient alipayAppletClient() {
        return new DefaultAlipayClient(this.alipayProperties.getGateWayUrl(), this.alipayProperties.getAppletAppId(), this.alipayProperties.getAppletRsaPrivateKey(), this.alipayProperties.getFormat(), this.alipayProperties.getCharset(), this.alipayProperties.getAppletAlipayPublicKey(), this.alipayProperties.getSigntype());
    }

    @Bean
    public AliAppletService aliAppletService() {
        return new AliAppletServiceImpl(this.alipayAppletClient());
    }
}

