/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.config;

import com.bxm.fossicker.thirdparty.common.constant.RedisKey;
import com.bxm.fossicker.thirdparty.config.CustomApacheHttpClientBuilder;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.enums.TicketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpInRedisConfigStorage
extends WxMpInMemoryConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";
    private static final Logger logger = LoggerFactory.getLogger(WxMpInRedisConfigStorage.class);
    private RedisStringAdapter redisStringAdapter;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private String cardapiTicketKey;
    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;

    public WxMpInRedisConfigStorage(RedisStringAdapter redisStringAdapter, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        this.setApacheHttpClientBuilder(customApacheHttpClientBuilder);
    }

    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    private KeyGenerator getWxMpKey(String key) {
        return RedisKey.WEIXIN_KEY.copy().appendKey((Object)key);
    }

    public String getAccessToken() {
        return this.redisStringAdapter.getString(this.getWxMpKey(this.accessTokenKey));
    }

    public void expireAccessToken() {
        this.redisStringAdapter.remove(this.getWxMpKey(this.accessTokenKey));
        super.expireAccessToken();
    }

    public boolean isAccessTokenExpired() {
        return this.redisStringAdapter.hasKey(this.getWxMpKey(this.accessTokenKey)) == false;
    }

    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisStringAdapter.set(this.getWxMpKey(this.accessTokenKey), (Object)accessToken, (long)(expiresInSeconds - 200));
    }

    public String getTicket(TicketType ticketType) {
        String jsapiTicket = this.redisStringAdapter.getString(this.getWxMpKey(this.jsapiTicketKey));
        logger.debug("[\u5fae\u4fe1\u7684\u7968\u636e:{}]", (Object)jsapiTicket);
        return jsapiTicket;
    }

    public boolean isTicketExpired(TicketType ticketType) {
        logger.debug("[\u5fae\u4fe1js\u7684key:{}\u662f\u5426\u8fc7\u671f]", (Object)this.getWxMpKey(this.jsapiTicketKey));
        return this.redisStringAdapter.hasKey(this.getWxMpKey(this.jsapiTicketKey)) == false;
    }

    public synchronized void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
        logger.debug("[\u5fae\u4fe1js\u7684key:{},\u7968\u636e\uff1a{}, \u8fc7\u671f\u65f6\u95f4: {}]", new Object[]{this.getWxMpKey(this.jsapiTicketKey), ticket, expiresInSeconds - 200});
        this.redisStringAdapter.set(this.getWxMpKey(this.jsapiTicketKey), (Object)ticket, (long)(expiresInSeconds - 200));
    }
}

