/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.handler;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.thirdparty.config.WechatAccountConfig;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.WxOfficialAccountFacadeService;
import com.bxm.fossicker.user.model.entity.WxOfficialLog;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.builder.outxml.TextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxMpSubscribeHandler
implements WxMpMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(WxMpSubscribeHandler.class);
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private WxOfficialAccountFacadeService wxOfficialAccountFacadeService;
    @Autowired
    private WxMpUserService wxMpUserService;
    @Autowired
    private WechatAccountConfig wechatAccountConfig;

    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        log.info("\u5904\u7406\u5173\u6ce8\u4e8b\u4ef6:{}", (Object)JSON.toJSONString((Object)wxMessage));
        String openId = wxMessage.getFromUser();
        WxMpUser wxMpUser = this.wxMpUserService.userInfo(openId);
        if (Objects.isNull(wxMpUser)) {
            log.error("\u7528openId\u83b7\u53d6\u5fae\u4fe1uid\u5931\u8d25,oid:{}", (Object)openId);
            return null;
        }
        String unionId = wxMpUser.getUnionId();
        WxOfficialLog wxOfficialLog = new WxOfficialLog(unionId, openId, wxMessage.getEvent(), new Date());
        this.wxOfficialAccountFacadeService.saveLog(wxOfficialLog);
        Long userId = this.userInfoFacadeService.getUserIdByUid(unionId);
        if (null == userId) {
            log.error("\u7528\u5fae\u4fe1uid\u83b7\u53d6userId\u5931\u8d25,uid:{}", (Object)unionId);
            return null;
        }
        this.wxOfficialAccountFacadeService.focusOnOfficialAccount(openId, unionId, userId, Integer.valueOf(1));
        WxMpXmlOutTextMessage wxMpXmlOutMessage = ((TextBuilder)((TextBuilder)WxMpXmlOutMessage.TEXT().toUser(openId)).fromUser(wxMessage.getToUser())).content(this.wechatAccountConfig.getFocusReply()).build();
        wxMpXmlOutMessage.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        return wxMpXmlOutMessage;
    }
}

