/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.fossicker.base.facade.service.EquipmentFacadeService;
import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.thirdpart.facade.service.ThirdpartyAdvertCallbakcService;
import com.bxm.fossicker.thirdparty.config.FensitongProperties;
import com.bxm.fossicker.thirdparty.config.ThirdpartyProperties;
import com.bxm.fossicker.thirdparty.constant.ThirdpartyRedisConfig;
import com.bxm.fossicker.thirdparty.domain.AdvertClickHistoryMapper;
import com.bxm.fossicker.thirdparty.model.param.Advert360Param;
import com.bxm.fossicker.thirdparty.model.param.BxmAdvertParam;
import com.bxm.fossicker.thirdparty.model.param.BxmClickParam;
import com.bxm.fossicker.thirdparty.model.param.BxmFormParam;
import com.bxm.fossicker.thirdparty.model.param.ClickFormParam;
import com.bxm.fossicker.thirdparty.model.param.DoumengFormParam;
import com.bxm.fossicker.thirdparty.model.param.FengsitongFormParam;
import com.bxm.fossicker.thirdparty.model.param.KuaishouClickParam;
import com.bxm.fossicker.thirdparty.model.param.KuaishouFormParam;
import com.bxm.fossicker.thirdparty.model.param.QttAdvertParam;
import com.bxm.fossicker.thirdparty.model.param.QttFormAdvertParam;
import com.bxm.fossicker.thirdparty.model.param.TtAdvertParam;
import com.bxm.fossicker.thirdparty.model.param.TtClickFormParam;
import com.bxm.fossicker.thirdparty.model.param.TuiaFormAdvertParam;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.AdvertCallbackService;
import com.bxm.fossicker.thirdparty.service.impl.advert.AdvertCallback;
import com.bxm.fossicker.thirdparty.service.impl.advert.AdvertConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.CallbackEventType;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AdvertCallbackServiceImpl
extends BaseService
implements AdvertCallbackService,
ThirdpartyAdvertCallbakcService {
    private static final Logger log = LoggerFactory.getLogger(AdvertCallbackServiceImpl.class);
    @Resource
    private AdvertClickHistoryMapper advertClickHistoryMapper;
    @Resource
    private EquipmentFacadeService equipmentFacadeService;
    @Resource
    private ThirdpartyProperties thirdpartyProperties;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private AdvertConverter advertConverter;
    @Resource
    private AdvertCallback advertCallback;
    @Resource
    private OKHttpService okHttpService;
    @Resource
    private FensitongProperties fensitongProperties;

    @Override
    public void addQttClick(QttAdvertParam param) {
        this.saveClickEvent(param);
    }

    @Override
    public void addQttForm(QttFormAdvertParam param) {
        this.logger.debug("\u8da3\u5934\u6761\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param.getUserId() || StringUtils.isBlank((CharSequence)param.getCallback())) {
            this.logger.error("\u8da3\u5934\u6761\u8868\u5355\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickFormEvent((ClickFormParam)param);
    }

    @Override
    public void addTtClick(TtAdvertParam param) {
        this.logger.info("\u4eca\u65e5\u5934\u6761\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (StringUtils.isBlank((CharSequence)param.getCallback_url())) {
            this.logger.error("\u4eca\u65e5\u5934\u6761\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickEvent(param);
    }

    @Override
    public void addTtClickForm(TtClickFormParam param) {
        this.logger.debug("\u5934\u6761\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param.getUserId() || StringUtils.isBlank((CharSequence)param.getLink())) {
            this.logger.error("\u5934\u6761\u8868\u5355\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        AdvertClickHistoryBean history = this.saveClickFormEvent((ClickFormParam)param);
        this.advertCallback.active(history);
    }

    @Override
    public void addBxmClick(BxmAdvertParam param) {
        String equipmentId = this.saveClickEvent(param);
        if (null != equipmentId) {
            this.active(equipmentId, null);
        }
    }

    @Override
    public void addBxmCallback(BxmClickParam param) {
        this.logger.debug("bxm\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (StringUtils.isBlank((CharSequence)param.getCallback())) {
            this.logger.error("bxm\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickEvent(param);
    }

    @Override
    public void addKuaishouClick(KuaishouFormParam param) {
        this.logger.debug("\u5feb\u624b\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param.getUserId() || StringUtils.isBlank((CharSequence)param.getCallback())) {
            this.logger.error("\u5feb\u624b\u8868\u5355\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        AdvertClickHistoryBean history = this.saveClickFormEvent((ClickFormParam)param);
        this.advertCallback.active(history);
    }

    @Override
    public void addKuaishouCallback(KuaishouClickParam param) {
        this.logger.info("\u5feb\u624b\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (StringUtils.isBlank((CharSequence)param.getCallback())) {
            this.logger.error("\u5feb\u624b\u6548\u679c\u76d1\u63a7\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickEvent(param);
    }

    @Override
    public void addBxmFormClick(BxmFormParam param) {
        this.logger.debug("\u53d8\u73b0\u732b\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param.getUserId() || StringUtils.isBlank((CharSequence)param.getBxmId())) {
            this.logger.error("\u53d8\u73b0\u732b\u8868\u5355\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickFormEvent((ClickFormParam)param);
    }

    @Override
    public void addTuiaFormClick(TuiaFormAdvertParam param) {
        this.logger.debug("\u63a8\u554a\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (null == param.getUserId() || StringUtils.isBlank((CharSequence)param.getAoid())) {
            this.logger.error("\u63a8\u554a\u8868\u5355\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickFormEvent((ClickFormParam)param);
    }

    @Override
    public void addDoumengFormClick(DoumengFormParam param) {
        this.logger.debug("\u8c46\u76df\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        this.saveClickFormEvent((ClickFormParam)param);
    }

    @Override
    public void addFensitongFormClick(FengsitongFormParam param) {
        this.logger.debug("\u7c89\u4e1d\u901a\u8868\u5355\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        this.saveClickFormEvent((ClickFormParam)param);
    }

    @Override
    public void authFensitong(String code, String state) {
        log.debug("\u7c89\u4e1d\u901a\u6388\u6743\u56de\u8c03\u63a5\u53e3-----code:[{}],state:[{}]", (Object)code, (Object)state);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("client_id", this.fensitongProperties.getClientId());
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", this.fensitongProperties.getRedirectUrl());
        map.put("code", code);
        String result = this.okHttpService.get(this.fensitongProperties.getAccessTokenUrl(), map, (Map)Maps.newHashMap());
        log.debug("\u7c89\u4e1d\u901a\u6388\u6743\u83b7\u5f97access_token\u7ed3\u679c:[{}]", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u7c89\u4e1d\u901a\u83b7\u53d6access_token\u5931\u8d25\uff0c\u8bf7\u7acb\u5373\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u53c2\u6570:[{}]\uff0c\u8fd4\u56de:[{}]", (Object)JSONObject.toJSONString(map), (Object)result);
            return;
        }
        JSONObject json = JSONObject.parseObject((String)result);
        if (Objects.isNull(json.get((Object)"access_token"))) {
            log.error("\u7c89\u4e1d\u901a\u83b7\u53d6access_token\u5931\u8d25\uff0c\u8bf7\u7acb\u5373\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u53c2\u6570:[{}]\uff0c\u8fd4\u56de:[{}]", (Object)JSONObject.toJSONString(map), (Object)result);
            return;
        }
        this.redisStringAdapter.set(ThirdpartyRedisConfig.ADVERT_FENSTONG_ACCESS_TOKEN.copy(), json.get((Object)"access_token"), (long)json.getInteger("expires_in").intValue());
        this.redisStringAdapter.set(ThirdpartyRedisConfig.ADVERT_FENSITONG_REFRESH_TOKEN.copy(), json.get((Object)"refresh_token"), (long)json.getInteger("refresh_expires_in").intValue());
    }

    @Override
    public void addAdvert360Click(Advert360Param param) {
        this.logger.debug("360\u70b9\u51fb\u53c2\u6570\uff1a[{}]", (Object)param);
        if (StringUtils.isBlank((CharSequence)param.getUniqueID()) || StringUtils.isBlank((CharSequence)param.getCallback())) {
            this.logger.error("360\u70b9\u51fb\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return;
        }
        this.saveClickEvent(param);
    }

    private AdvertClickHistoryBean saveClickFormEvent(ClickFormParam param) {
        AdvertClickHistoryBean history = this.advertConverter.history(param);
        if (null == history) {
            this.logger.error("{}\u672a\u627e\u5230\u8f6c\u6362\u5668", param.getClass());
            return null;
        }
        history.setId(Long.valueOf(this.nextId()));
        this.advertClickHistoryMapper.insert(history);
        if (null != param.getUserId()) {
            KeyGenerator key = this.buildClickFormKey(param.getUserId());
            this.redisStringAdapter.set(key, (Object)history, 14400L);
        }
        return history;
    }

    private KeyGenerator buildClickFormKey(Long userId) {
        return ThirdpartyRedisConfig.ADVERT_FORM_CLICK_CACHE.copy().appendKey((Object)userId);
    }

    private String saveClickEvent(Object param) {
        log.info("\u5e7f\u544a\u70b9\u51fb\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)param));
        EquipmentParam equipmentParam = this.advertConverter.equipment(param);
        if (equipmentParam == null) {
            return null;
        }
        String equipmentId = this.equipmentFacadeService.createEquipment(equipmentParam);
        AdvertClickHistoryBean historyBean = this.advertConverter.history(param);
        if (this.redisSetAdapter.exists(ThirdpartyRedisConfig.ADVERT_CLICK_CACHE, (Object)equipmentId).booleanValue()) {
            log.info("\u91cd\u590d\u4e0a\u62a5\u5e7f\u544a\u70b9\u51fb\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
        } else {
            this.redisSetAdapter.add(ThirdpartyRedisConfig.ADVERT_CLICK_CACHE, new Object[]{equipmentId});
        }
        historyBean.setId(Long.valueOf(this.nextId()));
        historyBean.setEquipmentId(Long.valueOf(equipmentId));
        this.advertClickHistoryMapper.insert(historyBean);
        return equipmentId;
    }

    @Async
    public void active(String equipmentId, Long userId) {
        AdvertClickHistoryBean res = this.getMatchEquipment(equipmentId, CallbackEventType.ACTIVE);
        if (null != res) {
            res.setEffectTime(new Date());
            this.advertCallback.active(res);
        }
        if (null != equipmentId) {
            Long equipment = Long.valueOf(equipmentId);
            KeyGenerator keyGenerator = ThirdpartyRedisConfig.ADVERT_ACTIVE_CACHE.copy().appendKey((Object)(equipment % 100L));
            Date firstActiveDate = (Date)this.redisHashMapAdapter.get(keyGenerator, equipmentId, Date.class);
            if (null == firstActiveDate) {
                this.redisHashMapAdapter.put(keyGenerator, equipment.toString(), (Object)new Date());
            }
            log.debug("\u8bbe\u5907 {} \u9996\u6b21\u6d3b\u8dc3\u65e5\u671f\uff1a{}", (Object)equipment, (Object)DateUtils.formatDateTime((Date)firstActiveDate));
            if (null != firstActiveDate && DateUtils.isSameDay((Date)DateUtils.addField((Date)firstActiveDate, (int)6, (int)1), (Date)new Date())) {
                log.info("\u7b26\u5408\u6761\u4ef6\uff0c\u4e0a\u62a5\u6b21\u7559\u6570\u636e\uff1a{}", (Object)equipmentId);
                KeyGenerator key = ThirdpartyRedisConfig.ADVERT_NEXT_DAY_LEFT_CACHE.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
                if (this.redisSetAdapter.exists(key, (Object)equipmentId).booleanValue()) {
                    log.info("{} \u4eca\u65e5\u5df2\u4e0a\u62a5\u6b21\u65e5\u7559\u5b58\uff0c\u4e0d\u505a\u5904\u7406", (Object)equipment);
                } else {
                    AdvertClickHistoryBean matchRes = this.advertClickHistoryMapper.selectByEquipment(equipment);
                    log.info("\u5904\u7406\u6b21\u65e5\u7559\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)matchRes));
                    this.advertCallback.nextDayLeft(matchRes);
                    this.redisSetAdapter.add(key, new Object[]{equipmentId});
                    this.redisSetAdapter.expire(key, (long)DateUtils.getCurSeconds());
                }
            }
        }
    }

    @Async
    public void login(Long userId, String equipmentId) {
        KeyGenerator key;
        AdvertClickHistoryBean formClick;
        AdvertClickHistoryBean res = this.getMatchEquipment(equipmentId, CallbackEventType.LOGIN);
        if (null != res) {
            res.setUserId(userId);
            this.advertCallback.login(res);
        }
        if (null != userId && null != (formClick = (AdvertClickHistoryBean)this.redisStringAdapter.get(key = this.buildClickFormKey(userId), AdvertClickHistoryBean.class))) {
            formClick.setUserId(userId);
            this.advertCallback.login(formClick);
        }
    }

    public void payment(Long userId, String equipmentId) {
        KeyGenerator key;
        AdvertClickHistoryBean formClick;
        AdvertClickHistoryBean res = this.getMatchEquipment(equipmentId, CallbackEventType.PAYMENT);
        if (null != res) {
            res.setUserId(userId);
            this.advertCallback.payment(res);
        }
        if (null != userId && null != (formClick = (AdvertClickHistoryBean)this.redisStringAdapter.get(key = this.buildClickFormKey(userId), AdvertClickHistoryBean.class))) {
            this.advertCallback.payment(formClick);
        }
    }

    private Map<String, Boolean> getEventMap(String equipmentId) {
        KeyGenerator key = ThirdpartyRedisConfig.ADVERT_EVENT_CALLBACK_CACHE.copy().appendKey((Object)equipmentId);
        Map entries = this.redisHashMapAdapter.entries(key, Boolean.class);
        if (null == entries || entries.size() == 0) {
            entries = Maps.newHashMap();
            entries.put(CallbackEventType.ACTIVE.name(), false);
            entries.put(CallbackEventType.LOGIN.name(), false);
            entries.put(CallbackEventType.PAYMENT.name(), false);
            this.redisHashMapAdapter.putAll(key, entries);
        }
        return entries;
    }

    private AdvertClickHistoryBean getMatchEquipment(String equipmentId, CallbackEventType eventType) {
        if (this.thirdpartyProperties.isEnableAdvert()) {
            if (!this.redisSetAdapter.exists(ThirdpartyRedisConfig.ADVERT_CLICK_CACHE, (Object)equipmentId).booleanValue()) {
                log.debug("{} \u4e0d\u662f\u5e7f\u544a\u70b9\u51fb\u8bbe\u5907\uff0c\u4e0d\u505a\u5904\u7406", (Object)equipmentId);
                return null;
            }
            Map<String, Boolean> entries = this.getEventMap(equipmentId);
            if (entries.get(eventType.name()).booleanValue()) {
                log.debug("\u8bbe\u5907[{}]\u5df2\u7ecf\u4e0a\u62a5\u8fc7{}\u4e8b\u4ef6", (Object)equipmentId, (Object)eventType.name());
                return null;
            }
            AdvertClickHistoryBean matchRes = this.advertClickHistoryMapper.selectByEquipment(Long.valueOf(equipmentId));
            log.debug("\u5339\u914d\u8bbe\u5907\u4fe1\u606f\uff0c\u56de\u8c03\u5e7f\u544a\u5e73\u53f0\uff0c\u8bbe\u5907ID\uff1a{}", (Object)equipmentId);
            if (null != matchRes) {
                matchRes.setMatchMap(entries);
                return matchRes;
            }
        }
        return null;
    }
}

