/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.bxm.fossicker.thirdparty.service.AliAppletService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliAppletServiceImpl
implements AliAppletService {
    private static final Logger log = LoggerFactory.getLogger(AliAppletServiceImpl.class);
    private final AlipayClient alipayClient;

    public AliAppletServiceImpl(AlipayClient alipayClient) {
        this.alipayClient = alipayClient;
    }

    @Override
    public String muteAuth(String authCode) {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(authCode);
        try {
            AlipaySystemOauthTokenResponse response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u9759\u9ed8\u6388\u6743\u6210\u529f\uff0c\u6388\u6743\u7801\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)authCode, (Object)JSON.toJSONString((Object)response));
                }
                return response.getUserId();
            }
            log.error("\u652f\u4ed8\u5b9d\u7533\u8bf7\u6388\u6743\u5931\u8d25\uff0c\u6388\u6743\u7801\uff1a{}\uff0c\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)authCode, (Object)JSON.toJSONString((Object)response));
        }
        catch (AlipayApiException e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u83b7\u53d6\u6388\u6743\u7801\u5931\u8d25\uff0cauthCode:{}", (Object)authCode);
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

