/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.bxm.fossicker.thirdparty.config.PointMallConfigProperties;
import com.bxm.fossicker.thirdparty.constant.ThirdpartyRedisConfig;
import com.bxm.fossicker.thirdparty.domain.PointMallMapper;
import com.bxm.fossicker.thirdparty.enums.PointsMallStatusEnum;
import com.bxm.fossicker.thirdparty.enums.PointsMallTypeEnum;
import com.bxm.fossicker.thirdparty.model.dto.DeductPointParam;
import com.bxm.fossicker.thirdparty.model.dto.OperateUserPointDTO;
import com.bxm.fossicker.thirdparty.model.dto.PointStoreBaseDTO;
import com.bxm.fossicker.thirdparty.model.dto.StoreNeceParam;
import com.bxm.fossicker.thirdparty.model.dto.UserPointDTO;
import com.bxm.fossicker.thirdparty.model.vo.PointMall;
import com.bxm.fossicker.thirdparty.service.PointMallService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.model.dto.AccountDetailDto;
import com.bxm.fossicker.util.MD5Sign;
import com.bxm.fossicker.util.NidGeneratorUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pointMallSerivce")
public class PointMallServiceImpl
extends BaseService
implements PointMallService {
    private PointMallConfigProperties pointMallConfigProperties;
    private AccountFacadeService accountFacadeService;
    private RedisStringAdapter redisStringAdapter;
    private PointMallMapper pointMallMapper;

    @Autowired
    public PointMallServiceImpl(PointMallConfigProperties pointMallConfigProperties, AccountFacadeService accountFacadeService, RedisStringAdapter redisStringAdapter, PointMallMapper pointMallMapper) {
        this.pointMallConfigProperties = pointMallConfigProperties;
        this.accountFacadeService = accountFacadeService;
        this.redisStringAdapter = redisStringAdapter;
        this.pointMallMapper = pointMallMapper;
    }

    @Override
    public UserPointDTO selectJbBalanceByUserId(StoreNeceParam storeNeceParam) {
        HashMap<String, String> map = this.addCommonParams(storeNeceParam);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(storeNeceParam.getSign())) {
            return UserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        AccountDetailDto account = this.accountFacadeService.loadAccountDetail(Long.valueOf(storeNeceParam.getAppUid()));
        String point = account.getUsableGold() == null ? "0" : account.getUsableGold().longValue() + "";
        return UserPointDTO.success((String)point);
    }

    @Override
    public OperateUserPointDTO deductUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());
        String description = this.decode(deductPointParam.getDescription());
        map.put("description", description);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        String appOrderNum = this.generateOrderNo();
        deductPointParam.setDescription(description);
        deductPointParam.setAppOrderNum(appOrderNum);
        return OperateUserPointDTO.success((String)appOrderNum);
    }

    @Override
    public PointStoreBaseDTO deductConfirmUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("orderNum", deductPointParam.getOrderNum());
        map.put("status", deductPointParam.getStatus());
        String description = this.decode(deductPointParam.getDescription());
        map.put("description", description);
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return PointStoreBaseDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        deductPointParam.setDescription(description);
        return PointStoreBaseDTO.success();
    }

    @Override
    public OperateUserPointDTO addUserBalance(DeductPointParam deductPointParam) {
        HashMap<String, String> map = this.addCommonParams((StoreNeceParam)deductPointParam);
        map.put("point", deductPointParam.getPoint().toString());
        map.put("orderNum", deductPointParam.getOrderNum());
        String md5Str = MD5Sign.sign(map, (String)this.pointMallConfigProperties.getAppSecret());
        if (!md5Str.equals(deductPointParam.getSign())) {
            return OperateUserPointDTO.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        String appOrderNum = this.generateOrderNo();
        String description = "\u6dfb\u52a0\u91d1\u5e01";
        String status = "ok";
        deductPointParam.setAppOrderNum(appOrderNum);
        deductPointParam.setDescription(description);
        deductPointParam.setStatus(status);
        return OperateUserPointDTO.success((String)appOrderNum);
    }

    @Override
    public String getPointMallById(Long id, Long userId) {
        List<PointMall> pointMalls = this.getAllPointMall();
        Optional<PointMall> optional = pointMalls.stream().filter(p -> p.getId().equals(id)).findFirst();
        if (PointsMallTypeEnum.STORE.getType().equals(optional.get().getType())) {
            return this.generateJumpUrl(userId, "");
        }
        return this.generateJumpUrl(userId, optional.get().getUrl());
    }

    private List<PointMall> getAllPointMall() {
        TypeReference<List<PointMall>> typeReference = new TypeReference<List<PointMall>>(){};
        List pointMalls = (List)this.redisStringAdapter.get(this.getPointsMallListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)pointMalls) && CollectionUtils.isNotEmpty((Collection)(pointMalls = this.pointMallMapper.selectAllByStatus(PointsMallStatusEnum.ON_SHELF.getStatus())))) {
            this.redisStringAdapter.set(this.getPointsMallListKey(), (Object)pointMalls);
        }
        return pointMalls;
    }

    private KeyGenerator getPointsMallListKey() {
        return ThirdpartyRedisConfig.POINTS_MALL_KEY.copy().appendKey((Object)"list");
    }

    private String generateOrderNo() {
        String orderPrefix = "Balance";
        return NidGeneratorUtil.getOrderNo((String)orderPrefix);
    }

    private String generateJumpUrl(Long userId, String url) {
        HashMap map = Maps.newHashMap();
        this.addCommonParams(map, userId);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            map.put("redirect", url);
        }
        String sign = MD5Sign.sign((HashMap)map, (String)this.pointMallConfigProperties.getAppSecret());
        map.put("sign", sign);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = this.encode(url);
            map.put("redirect", url);
        }
        return this.getFullLink(map);
    }

    private String getFullLink(Map<String, String> map) {
        String params = Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
        String jumpUrl = this.pointMallConfigProperties.getStoreUrl() + "?" + params;
        return jumpUrl;
    }

    private HashMap<String, String> addCommonParams(StoreNeceParam storeNeceParam) {
        HashMap map = Maps.newHashMap();
        map.put("appUid", storeNeceParam.getAppUid());
        map.put("appKey", this.pointMallConfigProperties.getAppKey());
        map.put("timestamp", storeNeceParam.getTimestamp());
        return map;
    }

    private void addCommonParams(Map<String, String> map, Long userId) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        map.put("appUid", String.valueOf(userId));
        map.put("appKey", this.pointMallConfigProperties.getAppKey());
        map.put("appType", this.pointMallConfigProperties.getAppType());
        map.put("timestamp", timestamp);
    }

    private String decode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                str = this.decode(str, "utf-8");
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    private String decode(String str, String enc) throws Exception {
        return URLDecoder.decode(str, enc);
    }

    private String encode(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                str = this.encode(str, "utf-8");
            }
            catch (Exception e) {
                this.logger.error("\u7f16\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        return str;
    }

    private String encode(String str, String enc) throws Exception {
        return URLEncoder.encode(str, enc);
    }
}

