/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.fossicker.activity.facade.Taoqi365ParseUrlFacadeService;
import com.bxm.fossicker.thirdparty.config.ThirdpartyProperties;
import com.bxm.fossicker.thirdparty.model.dto.UnicomPackageDTO;
import com.bxm.fossicker.thirdparty.model.param.UnicomPackageParam;
import com.bxm.fossicker.thirdparty.service.UnicomPackageService;
import com.bxm.fossicker.thirdparty.util.DeepCopyUtil;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnicomPackageServiceImpl
implements UnicomPackageService {
    private static final Logger log = LogManager.getLogger(UnicomPackageServiceImpl.class);
    @Autowired
    private ThirdpartyProperties properties;
    @Autowired
    private Taoqi365ParseUrlFacadeService taoqi365ParseUrlFacadeService;
    private static final String URL_PREFIX = "https://tq.jfshou.cn";

    @Override
    public List<UnicomPackageDTO> infoList(UnicomPackageParam param) {
        return this.make(param, this.properties.getWechatOssUrl());
    }

    @Override
    public List<UnicomPackageDTO> infoListForApp(UnicomPackageParam param) {
        return this.make(param, this.properties.getAppOssUrl());
    }

    private List<UnicomPackageDTO> make(UnicomPackageParam param, String baseDateUrl) {
        log.debug("input param : {}", (Object)param);
        List list = new ArrayList();
        ArrayList<UnicomPackageDTO> listNew = new ArrayList();
        try {
            String json = OkHttpUtils.get((String)baseDateUrl);
            list = JSONArray.parseArray((String)json, UnicomPackageDTO.class);
            listNew = DeepCopyUtil.deepCopy(list);
        }
        catch (Exception e) {
            log.error("error msg : {}", (Throwable)e);
        }
        listNew.forEach(content -> content.getItems().forEach(item -> {
            if (StringUtils.startsWith((CharSequence)item.getUrl(), (CharSequence)URL_PREFIX)) {
                String afterParseUrl = this.taoqi365ParseUrlFacadeService.parseUrl(item.getUrl(), param.getPhone(), this.properties.getTaoqi365AgentId());
                item.setUrl(afterParseUrl);
            }
        }));
        if (log.isDebugEnabled()) {
            log.debug(" uicome result : {}", (Object)JSON.toJSONString(listNew));
        }
        return listNew;
    }
}

