/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.bxm.fossicker.thirdpart.facade.dto.WxUserInfo;
import com.bxm.fossicker.thirdparty.enums.JsapiSignatureType;
import com.bxm.fossicker.thirdparty.model.vo.WxJsapiSignatureVO;
import com.bxm.fossicker.thirdparty.service.WxMpAuthService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpAuthServiceImpl
extends BaseService
implements WxMpAuthService {
    @Autowired
    private WxMpService wxMpService;
    @Autowired
    private WxMpService wxMpService2;

    @Override
    public WxUserInfo getUserByCode(String code) {
        WxUserInfo wxUserInfo = this.getWxUserInfoByCode(code);
        return wxUserInfo;
    }

    @Override
    public WxUserInfo getUserByCode2(String code) {
        WxUserInfo wxUserInfo = this.getWxUserInfoByCode2(code);
        return wxUserInfo;
    }

    @Override
    public WxJsapiSignatureVO getWxJsapiSignature(String url, JsapiSignatureType type) {
        WxJsapiSignatureVO wxJsapiSignatureVO = new WxJsapiSignatureVO();
        try {
            WxJsapiSignature wxJsapiSignature = null;
            wxJsapiSignature = Objects.equals((Object)type, (Object)JsapiSignatureType.PAYMENT) ? this.wxMpService2.createJsapiSignature(url) : this.wxMpService.createJsapiSignature(url);
            if (null != wxJsapiSignature) {
                BeanUtils.copyProperties((Object)wxJsapiSignature, (Object)wxJsapiSignatureVO);
                return wxJsapiSignatureVO;
            }
        }
        catch (WxErrorException e) {
            this.logger.error("\u83b7\u53d6js \u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
        }
        return wxJsapiSignatureVO;
    }

    private WxUserInfo getWxUserInfoByCode2(String code) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        if (StringUtils.isBlank((CharSequence)code)) {
            return wxUserInfo;
        }
        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService2.oauth2getAccessToken(code);
            WxMpUser wxMpUser = this.wxMpService2.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = this.convertWxMpUser(wxMpUser);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return wxUserInfo;
        }
        return wxUserInfo;
    }

    private WxUserInfo getWxUserInfoByCode(String code) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        if (StringUtils.isBlank((CharSequence)code)) {
            return wxUserInfo;
        }
        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = this.convertWxMpUser(wxMpUser);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return wxUserInfo;
        }
        return wxUserInfo;
    }

    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenId(wxMpUser.getOpenId());
        wxUserInfo.setUnionId(wxMpUser.getUnionId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        wxUserInfo.setNickname(wxMpUser.getNickname());
        return wxUserInfo;
    }
}

