/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.thirdpart.facade.service.WxMpMessageFacadeService;
import com.bxm.fossicker.thirdparty.config.ThirdpartyProperties;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpMessageServiceImpl
implements WxMpMessageFacadeService {
    private static final Logger log = LoggerFactory.getLogger(WxMpMessageServiceImpl.class);
    private WxMpService wxMpService;
    private ThirdpartyProperties thirdpartyProperties;

    public Message singlePush(WechatMpPushMessage message) {
        if (!this.thirdpartyProperties.isEnableWxMpTempMsg()) {
            log.debug("\u8c03\u7528\u4e86\u516c\u4f17\u53f7\u63a8\u9001\uff0c\u4f46\u662f\u516c\u4f17\u53f7\u63a8\u9001\u529f\u80fd\u5f00\u5173[thirdparty.config.enableWxMpTempMsg]\u4e3afalse");
            return Message.build((boolean)false, (String)"\u672a\u5f00\u542f\u516c\u4f17\u53f7\u63a8\u9001\u529f\u80fd");
        }
        if (null == message || StringUtils.isBlank((String)message.getOid()) || MapUtils.isEmpty((Map)message.getValueMap())) {
            log.warn("\u4f7f\u7528\u516c\u4f17\u53f7\u63a8\u9001\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574:{}", (Object)message);
            return Message.build((boolean)false, (String)"\u672a\u5f00\u542f\u516c\u4f17\u53f7\u63a8\u9001\u529f\u80fd");
        }
        List<WxMpTemplateData> wxMaTemplateDataList = this.generateTemplate(message);
        return this.sendTemplate(message, wxMaTemplateDataList, 3);
    }

    private Message sendTemplate(WechatMpPushMessage message, List<WxMpTemplateData> list, int retryTimes) {
        if (retryTimes == 0) {
            log.error("\u91cd\u8bd5\u540e\u53d1\u9001\u6a21\u677f\u6d88\u606f\u4ecd\u7136\u5931\u8d25");
            return Message.build((boolean)false);
        }
        try {
            String templateId = message.getWxMpTemplate().getTemplateId();
            log.debug("\u7ed9\u7528\u6237[{}]\u53d1\u9001[{}]\u6a21\u677f\u6d88\u606f", (Object)message.getUserId(), (Object)templateId);
            String msgId = this.wxMpService.getTemplateMsgService().sendTemplateMsg(WxMpTemplateMessage.builder().templateId(templateId).data(list).toUser(message.getOid()).build());
            log.info("\u7d66\u7528\u6236[{}]\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u6210\u529f\uff0c\u6d88\u606fID[{}]", (Object)message.getUserId(), (Object)msgId);
            return Message.build((boolean)true);
        }
        catch (WxErrorException e) {
            log.warn("\u7ed9\u7528\u6237\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return this.sendTemplate(message, list, --retryTimes);
        }
    }

    private List<WxMpTemplateData> generateTemplate(WechatMpPushMessage message) {
        ArrayList templateDataList = Lists.newArrayList();
        message.getValueMap().forEach((postion, content) -> templateDataList.add(new WxMpTemplateData(postion, content)));
        return templateDataList;
    }

    @Autowired
    public WxMpMessageServiceImpl(WxMpService wxMpService, ThirdpartyProperties thirdpartyProperties) {
        this.wxMpService = wxMpService;
        this.thirdpartyProperties = thirdpartyProperties;
    }
}

