/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.fossicker.thirdparty.config.XiaojuProperties;
import com.bxm.fossicker.thirdparty.model.dto.XiaojuAuthDTO;
import com.bxm.fossicker.thirdparty.model.dto.XiaojuLinkDTO;
import com.bxm.fossicker.thirdparty.model.param.XiaojuAuthParam;
import com.bxm.fossicker.thirdparty.service.XiaojuService;
import com.bxm.fossicker.thirdparty.util.AESUtil;
import com.bxm.fossicker.thirdparty.util.SignUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XiaojuServiceImpl
implements XiaojuService {
    private static final Logger log = LoggerFactory.getLogger(XiaojuServiceImpl.class);
    private final XiaojuProperties xiaojuProperties;
    private final OKHttpService okHttpService;

    @Override
    public Message getXiaojuLink(XiaojuAuthParam xiaojuAuthParam) {
        JSONObject jsonObject;
        String status;
        String encryptPhone = this.getPhone(xiaojuAuthParam.getPhone());
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("encryptPhone", encryptPhone);
        paramMap.put("deliveryMethod", "LINK");
        paramMap.put("openChannel", "1");
        paramMap.put("bizLine", "ENERGY");
        String body = JSONObject.toJSONString((Object)paramMap);
        String result = this.requestForResult(body, "/user/auth");
        if (StringUtils.isNotBlank((CharSequence)result) && "10000".equals(status = (jsonObject = JSONObject.parseObject((String)result)).getString("status"))) {
            JSONObject dataObj = jsonObject.getJSONObject("data");
            String link = dataObj.getString("link");
            return Message.build((boolean)true).addParam("xiaojuLinkDTO", (Object)new XiaojuLinkDTO(link));
        }
        log.error("\u5c0f\u6854\u52a0\u6cb9\u9690\u5f0f\u767b\u5f55\u5931\u8d25\uff0c\u53c2\u6570\uff1a[{}]\uff0c\u7ed3\u679c\uff1a[{}]", (Object)JSONObject.toJSONString((Object)xiaojuAuthParam), (Object)result);
        return Message.build((boolean)false).setMessage("\u5c0f\u6854\u52a0\u6cb9\u9690\u5f0f\u767b\u5f55\u5931\u8d25");
    }

    private String getPhone(String phone) throws Exception {
        String key = this.xiaojuProperties.getAppSecret().substring(0, 16);
        return AESUtil.encrypt(phone, key);
    }

    private String requestForResult(String body, String path) throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("open-am.xiaojukeji.com/am/open/api").setPath(path).build();
        HttpPost request = new HttpPost(uri);
        ContentType contentType = ContentType.APPLICATION_JSON;
        StringEntity se = new StringEntity(body, contentType);
        se.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)se);
        request.setHeader("x-cas-key", this.xiaojuProperties.getAppKey());
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        request.setHeader("x-date", date);
        request.setHeader("content-type", contentType.getMimeType());
        request.setHeader("content-md5", SignUtil.md5Encrypt(body));
        String signSource = SignUtil.buildSignSource(request.getMethod(), body, contentType.getMimeType(), date, this.xiaojuProperties.getAppKey(), uri.getPath(), uri.getQuery());
        String sign = SignUtil.calculateSign(signSource, this.xiaojuProperties.getAppSecret());
        request.setHeader("sign", sign);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    @Override
    public Message getOauthcode(String encryptPhone) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("encryptPhone", encryptPhone);
        String body = JSONObject.toJSONString((Object)paramMap);
        String result = this.requestForResult(body, "/oauthcode/get");
        if (StringUtils.isNotBlank((CharSequence)result)) {
            XiaojuAuthDTO xiaojuAuthDTO = (XiaojuAuthDTO)JSONObject.parseObject((String)result, XiaojuAuthDTO.class);
            return Message.build((boolean)true).addParam("xiaojuAuthDTO", (Object)xiaojuAuthDTO);
        }
        log.error("\u5c0f\u6854\u52a0\u6cb9\u83b7\u53d6oauthcode\u5931\u8d25,\u53c2\u6570:[{}]\uff0c\u7ed3\u679c\uff1a[{}]", (Object)encryptPhone, (Object)result);
        return Message.build((boolean)false).setMessage("\u5c0f\u6854\u52a0\u6cb9\u83b7\u53d6oauthcode\u5931\u8d25");
    }

    @Autowired
    public XiaojuServiceImpl(XiaojuProperties xiaojuProperties, OKHttpService okHttpService) {
        this.xiaojuProperties = xiaojuProperties;
        this.okHttpService = okHttpService;
    }
}

