/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert;

import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Callback;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.AbstractCallback;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.DefaultCallback;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class AdvertCallback
implements Callback,
ApplicationRunner,
ApplicationContextAware {
    private Map<String, Callback> callbackMap;
    private DefaultCallback defaultCallback = new DefaultCallback();
    private ApplicationContext applicationContext;

    private Callback get(AdvertClickHistoryBean click) {
        Callback callback = this.callbackMap.get(click.getType());
        if (callback == null) {
            return this.defaultCallback;
        }
        return callback;
    }

    @Override
    public void active(AdvertClickHistoryBean click) {
        this.get(click).active(click);
    }

    @Override
    public void login(AdvertClickHistoryBean click) {
        this.get(click).login(click);
    }

    @Override
    public void payment(AdvertClickHistoryBean click) {
        this.get(click).payment(click);
    }

    @Override
    public void nextDayLeft(AdvertClickHistoryBean click) {
        this.get(click).nextDayLeft(click);
    }

    public void run(ApplicationArguments args) {
        Map beans = this.applicationContext.getBeansOfType(AbstractCallback.class);
        this.callbackMap = Maps.newHashMap();
        beans.values().forEach(callback -> this.callbackMap.put(callback.platform().name(), (Callback)callback));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

