/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert;

import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Converter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.Advert360Converter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.BxmClickConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.BxmConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.BxmFormConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.DefaultConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.DoumengFormConvert;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.FensitongFormConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.KuaishouClickConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.KuaishouFormConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.QttConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.QttFormConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.TtConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.TtFormConverter;
import com.bxm.fossicker.thirdparty.service.impl.advert.converter.TuiaFormConverter;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdvertConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(AdvertConverter.class);
    private static Map<Class<?>, Converter<?>> converterMap = Maps.newHashMap();
    private Converter defaultConverter = new DefaultConverter();

    private static void initConvert(Converter converter) {
        converterMap.put(converter.type(), converter);
    }

    private Converter get(Object param) {
        Converter<?> converter = converterMap.get(param.getClass());
        if (null == converter) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u4f7f\u7528\u9ed8\u8ba4\u8f6c\u6362\u5668\uff0c\u53c2\u6570\uff1a{}", (Object)param.getClass().getSimpleName());
            return this.defaultConverter;
        }
        return converter;
    }

    public EquipmentParam equipment(Object param) {
        return this.get(param).equipment(param);
    }

    public AdvertClickHistoryBean history(Object param) {
        return this.get(param).history(param);
    }

    static {
        AdvertConverter.initConvert(new QttConverter());
        AdvertConverter.initConvert(new TtConverter());
        AdvertConverter.initConvert(new BxmConverter());
        AdvertConverter.initConvert(new QttFormConverter());
        AdvertConverter.initConvert(new TtFormConverter());
        AdvertConverter.initConvert(new KuaishouFormConverter());
        AdvertConverter.initConvert(new BxmFormConverter());
        AdvertConverter.initConvert(new DoumengFormConvert());
        AdvertConverter.initConvert(new TuiaFormConverter());
        AdvertConverter.initConvert(new FensitongFormConverter());
        AdvertConverter.initConvert(new Advert360Converter());
        AdvertConverter.initConvert(new BxmClickConverter());
        AdvertConverter.initConvert(new KuaishouClickConverter());
    }
}

