/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.callback;

import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.fossicker.thirdparty.constant.ThirdpartyRedisConfig;
import com.bxm.fossicker.thirdparty.domain.AdvertClickHistoryMapper;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Callback;
import com.bxm.fossicker.thirdparty.service.impl.advert.CallbackEventType;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(AbstractCallback.class);
    @Resource
    OKHttpService okHttpService;
    @Resource
    AdvertClickHistoryMapper advertClickHistoryMapper;
    @Resource
    RedisHashMapAdapter redisHashMapAdapter;

    void modifyHistory(AdvertClickHistoryBean click, CallbackEventType eventType) {
        this.advertClickHistoryMapper.updateByPrimaryKey(click);
        KeyGenerator key = ThirdpartyRedisConfig.ADVERT_EVENT_CALLBACK_CACHE.copy().appendKey((Object)click.getEquipmentId());
        this.redisHashMapAdapter.put(key, eventType.name(), (Object)Boolean.TRUE);
        log.debug("\u8bbe\u5907[{}]\u5b8c\u6210\u4e8b\u4ef6[{}]\u89e6\u53d1", (Object)click.getEquipmentId(), (Object)eventType.name());
    }
}

