/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.callback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.CallbackEventType;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.AbstractCallback;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Advert360Callback
extends AbstractCallback {
    private static final Logger log = LoggerFactory.getLogger(Advert360Callback.class);

    @Override
    public void active(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "9");
        if (log.isDebugEnabled()) {
            log.debug("360\u89e6\u53d1\u6fc0\u6d3b\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, this.addSignature(paramMap), (Map)Maps.newHashMap());
        this.parseResponse(response);
        click.setEffectTime(new Date());
        this.modifyHistory(click, CallbackEventType.ACTIVE);
    }

    @Override
    public void login(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "1");
        if (log.isDebugEnabled()) {
            log.debug("360\u89e6\u53d1\u767b\u5f55\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, this.addSignature(paramMap), (Map)Maps.newHashMap());
        this.parseResponse(response);
        this.modifyHistory(click, CallbackEventType.LOGIN);
    }

    @Override
    public void payment(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "16");
        if (log.isDebugEnabled()) {
            log.debug("360\u89e6\u53d1\u767b\u5f55\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, this.addSignature(paramMap), (Map)Maps.newHashMap());
        this.parseResponse(response);
        this.modifyHistory(click, CallbackEventType.PAYMENT);
    }

    private void parseResponse(String response) {
        JSONObject json = JSONObject.parseObject((String)response);
        if (null != json) {
            log.debug("360\u56de\u8c03\uff0c\u56de\u8c03\u7ed3\u679c:{}", (Object)json.toJSONString());
            if (0 != json.getIntValue("errno")) {
                log.error("360\u56de\u8c03\u5931\u8d25\uff0c\u56de\u8c03\u7ed3\u679c:{}", (Object)json.toJSONString());
            }
        }
    }

    private Map<String, String> addSignature(Map<String, String> paramMap) {
        return paramMap;
    }

    private Map<String, String> build(AdvertClickHistoryBean click) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("OS", this.restorOs(click));
        paramMap.put("UniqueID", click.getUid());
        paramMap.put("activetime", String.valueOf(System.currentTimeMillis() / 1000L));
        if (StringUtils.isNotBlank((CharSequence)click.getImeiMd5())) {
            paramMap.put("imei_md5", click.getImeiMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)click.getIdfa())) {
            paramMap.put("IDFA", click.getIdfa());
        }
        if (StringUtils.isNotBlank((CharSequence)click.getUnitId())) {
            paramMap.put("MAC_MD5", click.getUnitId());
        }
        return paramMap;
    }

    private String restorOs(AdvertClickHistoryBean click) {
        if (String.valueOf(PlatformEnum.IOS.getCode()).equals(click.getOs())) {
            return "1";
        }
        return "0";
    }

    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.ADVERT_360;
    }
}

