/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.callback;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.thirdparty.config.FensitongProperties;
import com.bxm.fossicker.thirdparty.constant.ThirdpartyRedisConfig;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.AbstractCallback;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FensitongFormCallback
extends AbstractCallback {
    private static final Logger log = LoggerFactory.getLogger(FensitongFormCallback.class);
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private FensitongProperties fensitongProperties;
    private static final String CALLBACK_URL = "https://api.biz.weibo.com/track/activate";

    @Override
    public void active(AdvertClickHistoryBean click) {
    }

    @Override
    public void login(AdvertClickHistoryBean click) {
    }

    @Override
    public void payment(AdvertClickHistoryBean click) {
        log.debug("\u7c89\u4e1d\u901a\u8868\u5355payment\u70b9\u51fb\u56de\u8c03\uff1a{}", (Object)click);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("time", String.valueOf(System.currentTimeMillis()));
        paramMap.put("behavior", "1001");
        paramMap.put("mark_id", click.getUnitId());
        paramMap.put("host", this.fensitongProperties.getServerHost());
        String accessToken = (String)this.redisStringAdapter.get(ThirdpartyRedisConfig.ADVERT_FENSTONG_ACCESS_TOKEN.copy(), String.class);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.error("\u7c89\u4e1d\u901a\u83b7\u53d6access_token\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f7f\u7528refresh_token\u5237\u65b0");
            String refreshToken = (String)this.redisStringAdapter.get(ThirdpartyRedisConfig.ADVERT_FENSITONG_REFRESH_TOKEN.copy(), String.class);
            if (StringUtils.isBlank((CharSequence)refreshToken)) {
                log.error("\u7c89\u4e1d\u901a\u83b7\u53d6refresh_token\u5931\u8d25\uff0c\u5df2\u8fc7\u671f\uff0c\u8bf7\u7acb\u5373\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
            }
            HashMap refreshParamMap = Maps.newHashMap();
            refreshParamMap.put("client_id", this.fensitongProperties.getClientId());
            refreshParamMap.put("grant_type", "refresh_token");
            refreshParamMap.put("refresh_token", refreshToken);
            String result = this.okHttpService.get(this.fensitongProperties.getRefreshTokenUrl(), (Map)refreshParamMap, (Map)Maps.newHashMap());
            if (StringUtils.isBlank((CharSequence)result)) {
                log.error("\u7c89\u4e1d\u901a\u6839\u636erefresh_token\u83b7\u53d6access_token\u5931\u8d25\uff0c\u8bf7\u7acb\u5373\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u53c2\u6570:[{}]\uff0c\u8fd4\u56de:[{}]", (Object)JSONObject.toJSONString((Object)refreshParamMap), (Object)result);
            }
            log.debug("\u7c89\u4e1d\u901a\u6388\u6743\u83b7\u5f97access_token\u7ed3\u679c:[{}]", (Object)result);
            JSONObject json = JSONObject.parseObject((String)result);
            if (Objects.isNull(json.get((Object)"access_token"))) {
                log.error("\u7c89\u4e1d\u901a\u6839\u636erefresh_token\u83b7\u53d6access_token\u5931\u8d25\uff0c\u8bf7\u7acb\u5373\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u53c2\u6570:[{}]\uff0c\u8fd4\u56de:[{}]", (Object)JSONObject.toJSONString((Object)refreshParamMap), (Object)result);
            }
            accessToken = json.getString("access_token");
            this.redisStringAdapter.set(ThirdpartyRedisConfig.ADVERT_FENSTONG_ACCESS_TOKEN.copy(), (Object)accessToken, (long)json.getInteger("expires_in").intValue());
        }
        HashMap headerMap = Maps.newHashMap();
        headerMap.put("Authorization", "Bearer " + accessToken);
        headerMap.put("Accept", "application/json,application/text+gw2.0");
        String response = this.okHttpService.get(CALLBACK_URL, (Map)paramMap, (Map)headerMap);
        log.info("\u7c89\u4e1d\u901a\u8868\u5355\u5e7f\u544a\u4ed8\u8d39\u56de\u8c03,\u4e0a\u62a5\u7ed3\u679c\uff1a{}", (Object)response);
    }

    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.FENSITONG_FORM;
    }
}

