/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.callback;

import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.CallbackEventType;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.AbstractCallback;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QttCallback
extends AbstractCallback {
    private static final Logger log = LoggerFactory.getLogger(QttCallback.class);

    @Override
    public void active(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack() + "&op2=0";
        try {
            callbackUrl = URLDecoder.decode(callbackUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        click.setEffectTime(new Date());
        this.modifyHistory(click, CallbackEventType.ACTIVE);
        this.okHttpService.get(callbackUrl, (Map)Maps.newHashMap());
    }

    @Override
    public void login(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack() + "&op2=1";
        this.modifyHistory(click, CallbackEventType.LOGIN);
        this.okHttpService.get(callbackUrl, (Map)Maps.newHashMap());
    }

    @Override
    public void payment(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack() + "&op2=2";
        this.modifyHistory(click, CallbackEventType.PAYMENT);
        this.okHttpService.get(callbackUrl, (Map)Maps.newHashMap());
    }

    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.QTT;
    }
}

