/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.callback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.CallbackEventType;
import com.bxm.fossicker.thirdparty.service.impl.advert.callback.AbstractCallback;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TtCallback
extends AbstractCallback {
    private static final Logger log = LoggerFactory.getLogger(TtCallback.class);

    @Override
    public void active(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "0");
        if (log.isDebugEnabled()) {
            log.debug("\u4eca\u65e5\u5934\u6761\u89e6\u53d1\u6fc0\u6d3b\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, paramMap, (Map)Maps.newHashMap());
        this.parseResponse(response);
        click.setEffectTime(new Date());
        this.modifyHistory(click, CallbackEventType.ACTIVE);
    }

    @Override
    public void login(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "1");
        if (log.isDebugEnabled()) {
            log.debug("\u4eca\u65e5\u5934\u6761\u89e6\u53d1\u767b\u5f55\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, paramMap, (Map)Maps.newHashMap());
        this.parseResponse(response);
        this.modifyHistory(click, CallbackEventType.LOGIN);
    }

    @Override
    public void payment(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "2");
        if (log.isDebugEnabled()) {
            log.debug("\u4eca\u65e5\u5934\u6761\u89e6\u53d1\u767b\u5f55\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, paramMap, (Map)Maps.newHashMap());
        this.parseResponse(response);
        this.modifyHistory(click, CallbackEventType.PAYMENT);
    }

    private void parseResponse(String response) {
        JSONObject json = JSONObject.parseObject((String)response);
        if (null != json) {
            log.debug("\u4eca\u65e5\u5934\u6761\u56de\u8c03\uff0c\u56de\u8c03\u7ed3\u679c:{}", (Object)json.toJSONString());
            if (0 != json.getIntValue("ret")) {
                log.error("\u4eca\u65e5\u5934\u6761\u56de\u8c03\u5931\u8d25\uff0c\u56de\u8c03\u7ed3\u679c:{}", (Object)json.toJSONString());
            }
        }
    }

    private Map<String, String> build(AdvertClickHistoryBean click) {
        HashMap paramMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)click.getImei())) {
            paramMap.put("muid", click.getImei());
        } else if (StringUtils.isNotBlank((CharSequence)click.getIdfa())) {
            paramMap.put("muid", click.getIdfa());
        }
        paramMap.put("os", this.restorOs(click));
        paramMap.put("imei", click.getImei());
        paramMap.put("idfa", click.getIdfa());
        paramMap.put("source", "hl");
        paramMap.put("conv_time", String.valueOf(System.currentTimeMillis()));
        return paramMap;
    }

    @Override
    public void nextDayLeft(AdvertClickHistoryBean click) {
        String callbackUrl = click.getCallBack();
        Map<String, String> paramMap = this.build(click);
        paramMap.put("event_type", "6");
        if (log.isDebugEnabled()) {
            log.debug("\u4eca\u65e5\u5934\u6761\u89e6\u53d1\u6b21\u65e5\u7559\u5b58\u5e7f\u544a\u56de\u8c03\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
        }
        String response = this.okHttpService.get(callbackUrl, paramMap, (Map)Maps.newHashMap());
        this.parseResponse(response);
    }

    private String restorOs(AdvertClickHistoryBean click) {
        if (String.valueOf(PlatformEnum.IOS.getCode()).equals(click.getOs())) {
            return "1";
        }
        return "0";
    }

    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.TT;
    }
}

