/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.converter;

import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.param.Advert360Param;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Converter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;

public class Advert360Converter
implements Converter<Advert360Param> {
    @Override
    public EquipmentParam equipment(Advert360Param param) {
        EquipmentParam equipmentParam = new EquipmentParam();
        equipmentParam.setImeiMd5(param.getImeiMd5());
        equipmentParam.setIdfa(param.getIdfa());
        equipmentParam.setPhoneModel(param.getDevicetype());
        equipmentParam.setOperatingSystem(this.adpter(param.getOs()));
        return equipmentParam;
    }

    private String adpter(String os) {
        if ("0".equals(os)) {
            return String.valueOf(PlatformEnum.ANDROID.getCode());
        }
        return String.valueOf(PlatformEnum.IOS.getCode());
    }

    @Override
    public AdvertClickHistoryBean history(Advert360Param param) {
        AdvertClickHistoryBean entity = AdvertClickHistoryBean.builder().imeiMd5(param.getImeiMd5()).idfa(param.getIdfa()).callBack(param.getCallback()).uid(param.getUniqueID()).unitId(param.getMacMd5()).createTime(new Date()).type(ThridpartyAdvertEnum.ADVERT_360.name()).os(this.adpter(param.getOs())).build();
        if (StringUtils.isBlank((CharSequence)param.getClicktime())) {
            entity.setClickTime(new Date());
        } else if (NumberUtils.isDigits((String)param.getClicktime())) {
            long clickSecond = NumberUtils.toLong((String)param.getClicktime());
            entity.setClickTime(new Date(clickSecond * 1000L));
        }
        return entity;
    }

    @Override
    public Class<?> type() {
        return Advert360Param.class;
    }
}

