/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.converter;

import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.param.BxmClickParam;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Converter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;

public class BxmClickConverter
implements Converter<BxmClickParam> {
    @Override
    public EquipmentParam equipment(BxmClickParam param) {
        EquipmentParam equipmentParam = new EquipmentParam();
        equipmentParam.setAndroidId(param.getAndroidid());
        equipmentParam.setAndroidIdMd5(param.getAndroidid_md5());
        equipmentParam.setIdfa(param.getIdfa());
        equipmentParam.setIdfaMd5(param.getIdfa_md5());
        equipmentParam.setImei(param.getImei());
        equipmentParam.setImeiMd5(param.getImei_md5());
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            equipmentParam.setImei(param.getOaid());
        }
        equipmentParam.setOperatingSystem(this.adapter(param));
        return equipmentParam;
    }

    private String adapter(BxmClickParam param) {
        if (StringUtils.isNotBlank((CharSequence)param.getIdfa())) {
            return String.valueOf(PlatformEnum.IOS.getCode());
        }
        return String.valueOf(PlatformEnum.ANDROID.getCode());
    }

    @Override
    public AdvertClickHistoryBean history(BxmClickParam param) {
        Date now;
        Date clickTime = now = new Date();
        if (null != param.getTime()) {
            clickTime = new Date(param.getTime());
        }
        AdvertClickHistoryBean clickHistoryBean = AdvertClickHistoryBean.builder().imei(param.getImei()).androidId(param.getAndroidid()).idfa(param.getIdfa()).callBack(param.getCallback()).createTime(now).clickTime(clickTime).type(ThridpartyAdvertEnum.BXM_CLICK.name()).os(this.adapter(param)).build();
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            clickHistoryBean.setImei(param.getOaid());
        }
        return clickHistoryBean;
    }

    @Override
    public Class<?> type() {
        return BxmClickParam.class;
    }
}

