/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.converter;

import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.param.KuaishouClickParam;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Converter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;

public class KuaishouClickConverter
implements Converter<KuaishouClickParam> {
    @Override
    public EquipmentParam equipment(KuaishouClickParam param) {
        EquipmentParam equipmentParam = new EquipmentParam();
        equipmentParam.setAndroidIdMd5(param.getAndroidIdMd5());
        equipmentParam.setIdfaMd5(param.getIdfaMd5());
        equipmentParam.setImeiMd5(param.getImei());
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            equipmentParam.setImei(param.getOaid());
        }
        equipmentParam.setOperatingSystem(this.adapter(param));
        return equipmentParam;
    }

    private String adapter(KuaishouClickParam param) {
        if (StringUtils.isNotBlank((CharSequence)param.getIdfaMd5())) {
            return String.valueOf(PlatformEnum.IOS.getCode());
        }
        return String.valueOf(PlatformEnum.ANDROID.getCode());
    }

    @Override
    public AdvertClickHistoryBean history(KuaishouClickParam param) {
        Date now;
        Date clickTime = now = new Date();
        if (null != param.getTs()) {
            clickTime = new Date(NumberUtils.parseToLong((String)param.getTs()));
        }
        AdvertClickHistoryBean clickHistoryBean = AdvertClickHistoryBean.builder().imei(param.getImei()).androidId(param.getAndroidIdMd5()).idfa(param.getIdfaMd5()).callBack(param.getCallback()).createTime(now).clickTime(clickTime).type(ThridpartyAdvertEnum.KUAISHOU_CLICK.name()).os(this.adapter(param)).build();
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            clickHistoryBean.setImei(param.getOaid());
        }
        return clickHistoryBean;
    }

    @Override
    public Class<?> type() {
        return KuaishouClickParam.class;
    }
}

