/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.advert.converter;

import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.enums.PlatformEnum;
import com.bxm.fossicker.thirdparty.enums.ThridpartyAdvertEnum;
import com.bxm.fossicker.thirdparty.model.param.TtAdvertParam;
import com.bxm.fossicker.thirdparty.model.vo.AdvertClickHistoryBean;
import com.bxm.fossicker.thirdparty.service.impl.advert.Converter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;

public class TtConverter
implements Converter<TtAdvertParam> {
    @Override
    public EquipmentParam equipment(TtAdvertParam param) {
        EquipmentParam equipmentParam = new EquipmentParam();
        equipmentParam.setAndroidIdMd5(param.getAndroidid());
        equipmentParam.setImeiMd5(param.getImei());
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            equipmentParam.setImeiMd5(param.getOaid());
        }
        equipmentParam.setIdfa(param.getIdfa());
        equipmentParam.setOperatingSystem(this.adpterOS(param.getOs()));
        return equipmentParam;
    }

    private String adpterOS(String os) {
        if ("0".equals(os)) {
            return String.valueOf(PlatformEnum.ANDROID.getCode());
        }
        return String.valueOf(PlatformEnum.IOS.getCode());
    }

    @Override
    public AdvertClickHistoryBean history(TtAdvertParam param) {
        AdvertClickHistoryBean clickHistoryBean = AdvertClickHistoryBean.builder().imei(param.getImei()).androidId(param.getAndroidid()).idfa(param.getIdfa()).callBack(param.getCallback_url()).createTime(new Date()).clickTime(DateUtils.parseDateNonStrict((String)param.getTimestamp())).unitId(param.getCid()).planId(param.getAdid()).type(ThridpartyAdvertEnum.TT.name()).os(this.adpterOS(param.getOs())).build();
        if (StringUtils.isNotBlank((CharSequence)param.getOaid())) {
            clickHistoryBean.setImei(param.getOaid());
        }
        return clickHistoryBean;
    }

    @Override
    public Class<?> type() {
        return TtAdvertParam.class;
    }
}

